/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.BoundingRegion;
import com.ibm.athena.smartermaps.DisputedTerritoriesUnit;
import com.ibm.athena.smartermaps.GroupsAndAliases;
import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.ISmarterMaps;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.athena.smartermaps.SmarterMapsResult;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.athena.smartermaps.model.MapIndexer;
import com.ibm.athena.smartermaps.util.MapsUtilities;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SmarterMaps
implements ISmarterMaps {
    public static final String CHINA_TAIWAN_PROPERTY = "ChinaTaiwanPrecedence";
    public static final String CHINA = "China";
    public static final String TAIWAN = "Taiwan";
    public static final String INDIA_PAKISTAN_PROPERTY = "IndiaPakistanPrecedence";
    public static final String INDIA = "India";
    public static final String PAKISTAN = "Pakistan";
    public static final String JAMMU_AND_KASHMIR = "Jammu and Kashmir";
    public static final String NORTHERN_AREAS = "Northern Areas";
    public static final String ISRAEL_WEST_BANK_PROPERTY = "IsraelWestBankPrecedence";
    public static final String ISRAEL = "Israel";
    public static final String WESTBANK = "WestBank";
    public static final String WEST_BANK = "West Bank";
    public static final String EASTERN_ASIA = "Eastern Asia";
    private static final String DOMAIN_NAME = "DOMAIN_NAME";
    private BoundingRegion boundingRegion = null;
    private static final LocationIndexer indexer = LocationIndexer.getInstance();
    private int confidenceLevel = 80;
    private List<DisputedTerritories> dTerritories = new ArrayList<DisputedTerritories>();
    private String m_domainName;
    private DisputedTerritoriesUnit disputedUnit = new DisputedTerritoriesUnit();
    private GroupsAndAliases groupsAndAliases = new GroupsAndAliases();

    public SmarterMaps() {
        this.boundingRegion = new BoundingRegion();
        this.disputedUnit = new DisputedTerritoriesUnit();
    }

    public SmarterMaps(Properties properties) {
        this();
        this.setDisputedTerritoriesList(properties);
    }

    @Override
    public JSONObject generateSmallestRegion(List<ISMLocation> sMLocations) {
        return this.generateSmallestRegion(sMLocations, null);
    }

    @Override
    public JSONObject generateSmallestRegion(List<ISMLocation> iLocations, String title) {
        JSONObject geoJSON;
        boolean boundingRegionFlag;
        if (iLocations == null) {
            SmarterMapsResult result = new SmarterMapsResult();
            result.setStatus(Status.FAILURE);
            return result.convertToJSON();
        }
        SmarterMapsResult result = this.execute(iLocations = this.removeDuplicates(iLocations), title, boundingRegionFlag = false);
        if (result.getGeoJSON() == null) {
            return result.convertToJSON();
        }
        if (result.getMapName().equals("Europe")) {
            List<Integer> ids = indexer.getLocationIds("Russia");
            LocationEntry entry = indexer.getLocation(ids.get(0));
            boolean withRussia = false;
            for (ISMLocation sMLocation : iLocations) {
                if (!indexer.equalsNameOrAlias(sMLocation.getName(), entry)) continue;
                withRussia = true;
                break;
            }
            if (!withRussia) {
                return this.performGenerateBoundingRegion(iLocations, result.convertToJSON());
            }
        }
        if ((geoJSON = result.convertToJSON()) != null) {
            this.disputedUnit.processDisputedTerritories(geoJSON, this.dTerritories);
        }
        return geoJSON;
    }

    public List<ISMLocation> removeDuplicates(List<ISMLocation> iLocations) {
        ArrayList<ISMLocation> resultList = new ArrayList<ISMLocation>();
        HashSet<ISMLocation> resultSet = new HashSet<ISMLocation>();
        resultSet.addAll(iLocations);
        resultList.addAll(resultSet);
        return resultList;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations) {
        return this.generateBoundingRegion(sMLocations, null);
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, String title) {
        JSONObject smallestRegion = this.generateSmallestRegion(sMLocations, title);
        String status = (String)smallestRegion.get((Object)"status");
        if (!status.equals(Status.FAILURE.getName())) {
            smallestRegion = this.performGenerateBoundingRegion(sMLocations, smallestRegion);
        }
        return smallestRegion;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        return this.generateBoundingRegion(sMLocations, null, topPercent, bottomPercent, leftPercent, rightPercent);
    }

    private JSONObject performGenerateBoundingRegion(List<ISMLocation> sMLocations, Object object1, JSONObject smallestRegion, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        try {
            smallestRegion = this.boundingRegion.generateBoundingRegion((ArrayList)sMLocations, smallestRegion, topPercent, bottomPercent, leftPercent, rightPercent);
        }
        catch (Exception e) {
            smallestRegion.put((Object)"status", (Object)Status.FAILURE.getName());
            smallestRegion.put((Object)"failureMessage", (Object)e.getMessage());
        }
        return smallestRegion;
    }

    private JSONObject performGenerateBoundingRegion(List<ISMLocation> iLocations, JSONObject smallestRegion) {
        try {
            smallestRegion = this.boundingRegion.generateBoundingRegion((ArrayList)iLocations, smallestRegion);
        }
        catch (Exception e) {
            smallestRegion.put((Object)"status", (Object)Status.FAILURE.getName());
            smallestRegion.put((Object)"failureMessage", (Object)e.getMessage());
        }
        return smallestRegion;
    }

    private boolean isKnownAncestry(ISMLocation iLocation) {
        List<ISMLocation> ancestryList = iLocation.getAncestryLocations();
        for (ISMLocation location : ancestryList) {
            List<Integer> ids = indexer.getLocationIds(location.getName());
            if (ids != null && !ids.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<Integer> getValidAncestryIds(ISMLocation iLocation, List<DisputedTerritories> dTerritories) {
        List<ISMLocation> ancestryList = iLocation.getAncestryLocations();
        List<Integer> ids = indexer.getLocationIds(iLocation.getName());
        for (Integer id : ids) {
            List<Integer> ancestryIds = indexer.getPathToRoot(id, dTerritories);
            int nbMatches = ancestryList.size();
            for (int i = 0; i < ancestryIds.size() - 1; ++i) {
                Integer ancestryId = ancestryIds.get(i);
                String ancestryName = ancestryList.get(nbMatches - 1).getName();
                List<Integer> curLocationIds = indexer.getLocationIds(ancestryName);
                if (!curLocationIds.contains(ancestryId) || --nbMatches != 0) continue;
                return ancestryIds;
            }
        }
        return null;
    }

    private boolean isIdenticalPath(List<Integer> ancestryIds, List<Integer> curIds) {
        if (ancestryIds.size() != curIds.size()) {
            return false;
        }
        for (int i = 0; i < curIds.size(); ++i) {
            if (ancestryIds.get(i) == curIds.get(i)) continue;
            return false;
        }
        return true;
    }

    private List<String> iLocationToString(List<ISMLocation> iLocations) {
        ArrayList<String> stringList = new ArrayList<String>(iLocations.size());
        for (ISMLocation sMLocation : iLocations) {
            stringList.add(sMLocation.getName());
        }
        return stringList;
    }

    private SmarterMapsResult execute(List<ISMLocation> iLocationsInit, String title, boolean boundingRegion) {
        String name;
        String name2;
        SmarterMapsResult result = new SmarterMapsResult();
        indexer.clearUnmatchedNames();
        indexer.clearAmbiguityMessage();
        List<Integer> ids = null;
        ArrayList<ISMLocation> sMLocations = new ArrayList<ISMLocation>();
        ArrayList<String> locationNames = new ArrayList<String>();
        ArrayList<ISMLocation> iLocations = new ArrayList<ISMLocation>();
        Map<String, List<Integer>> groups = this.getGroups();
        for (ISMLocation sMLocation : iLocationsInit) {
            name2 = sMLocation.getName();
            List<Integer> elements = groups.get(name2);
            if (elements != null && !elements.isEmpty()) {
                for (int i = 0; i < elements.size(); ++i) {
                    String elementName = indexer.getLocation(elements.get(i)).getName();
                    SMLocation iLocation = new SMLocation(elementName);
                    iLocations.add(iLocation);
                }
                continue;
            }
            iLocations.add(sMLocation);
        }
        for (ISMLocation sMLocation : iLocations) {
            name2 = sMLocation.getName();
            ids = indexer.getLocationIds(name2);
            if (ids == null || ids.isEmpty()) {
                result.addUnmatchedName(name2);
                continue;
            }
            List<ISMLocation> ancestryLocations = sMLocation.getAncestryLocations();
            if (ancestryLocations != null && !ancestryLocations.isEmpty()) {
                if (!this.isKnownAncestry(sMLocation)) {
                    sMLocations.add(sMLocation);
                    continue;
                }
                boolean res = false;
                List<Integer> ancestryToRoot = this.getValidAncestryIds(sMLocation, this.dTerritories);
                if (ancestryToRoot != null) {
                    for (Integer id : ids) {
                        List<Integer> idRoot = indexer.getPathToRoot(id, this.dTerritories);
                        res = this.isIdenticalPath(ancestryToRoot, idRoot);
                        if (!res || indexer.getLocation(id).getType() == LocationEntry.Type.CITY) continue;
                        locationNames.add(name2);
                        result.addUniqueLocationID(id);
                        break;
                    }
                } else {
                    if (result.getStatus() == Status.UNKNOWN || result.getStatus() == Status.SUCCESS) {
                        result.setStatus(Status.WARNING);
                    }
                    String message = result.getAmbiguityMessage();
                    ArrayList<String> ancestorNames = new ArrayList<String>();
                    for (ISMLocation loc : ancestryLocations) {
                        ancestorNames.add(loc.getName());
                    }
                    message = message + " " + name2 + " has incorrect ancestors: " + ancestorNames;
                    result.setWarningMessage(message);
                }
            }
            sMLocations.add(sMLocation);
        }
        int nbLocations = iLocations.size();
        if (result.getUnmatchedNames().size() == nbLocations && this.m_domainName != null && this.m_domainName.equalsIgnoreCase("WhiteSox")) {
            List<MapIndexer> indexes = MapIndexer.getNonMapIndexers();
            int nbUnmatched = 0;
            for (MapIndexer index : indexes) {
                Map<Integer, String> locations = index.getLocations();
                for (ISMLocation location : iLocations) {
                    name = location.getName();
                    if (locations.containsValue(name = MapsUtilities.removeExtraWS(name))) continue;
                    ++nbUnmatched;
                }
                int level = 100 * (nbLocations - nbUnmatched) / nbLocations;
                this.confidenceLevel = 20;
                if (level > this.confidenceLevel) {
                    result.setGeoJSON(index.getGeoJSON());
                    result.setStatus(Status.SUCCESS);
                    result.setMapName("WhiteSox");
                    return result;
                }
                nbUnmatched = 0;
            }
        }
        List<String> unmatchedNames = indexer.getUnmatchedNames();
        for (String name3 : unmatchedNames) {
            result.addUnmatchedName(name3);
        }
        int nbUnmatched = result.getUnmatchedNames().size();
        if (nbLocations == nbUnmatched) {
            result.setStatus(Status.FAILURE);
            result.setFailureMessage("None of the locations match");
            return result;
        }
        int level = 100 * (nbLocations - nbUnmatched) / nbLocations;
        if (level < this.confidenceLevel) {
            result.setStatus(Status.FAILURE);
            result.setFailureMessage("Less than " + this.confidenceLevel + "% of the locations match. \nUnmatched Locations:" + result.getUnmatchedNames());
            return result;
        }
        boolean fail = false;
        StringBuffer failureMessage = new StringBuffer();
        for (ISMLocation sMLocation : sMLocations) {
            name = sMLocation.getName();
            ids = indexer.getLocationIds(name);
            if (ids.size() == 1) {
                Integer id = (Integer)ids.toArray()[0];
                if (indexer.getLocation(id).getType() == LocationEntry.Type.CITY) continue;
                result.addUniqueLocationID(id);
                locationNames.add(name);
                continue;
            }
            result.addAmbiguousNames(name);
            Integer locId = null;
            try {
                locId = indexer.disambiguate(name, title, this.iLocationToString(sMLocations), this.dTerritories);
            }
            catch (Exception e) {
                fail = true;
                failureMessage.append(e.getMessage());
                continue;
            }
            if (indexer.getLocation(locId).getType() == LocationEntry.Type.CITY) continue;
            result.addUniqueLocationID(locId);
            locationNames.add(name);
        }
        if (fail) {
            result.setStatus(Status.FAILURE);
            result.setFailureMessage(failureMessage.toString());
            return result;
        }
        int nbGood = result.getUniqueLocationIDs().size();
        level = 100 * nbGood / nbLocations;
        if (level < this.confidenceLevel) {
            result.setStatus(Status.FAILURE);
            result.setFailureMessage("Less than " + this.confidenceLevel + "% of the locations match");
            return result;
        }
        result.resolveGeoJSON(locationNames, this.dTerritories, boundingRegion);
        JSONObject gj = result.getGeoJSON();
        gj = this.resolveGroups(gj);
        result.setGeoJSON(gj);
        result.updateStatus();
        result.setAmbiguityMessage(indexer.getAmbiguityMessage());
        return result;
    }

    private JSONObject resolveGroups(JSONObject gj) {
        Map<String, List<Integer>> groups = this.getGroups();
        if (groups != null) {
            Set<String> groupNames = groups.keySet();
            for (String groupName : groupNames) {
                List<Integer> ids = groups.get(groupName);
                gj = indexer.mergePolygons(gj, groupName, ids, this.dTerritories);
            }
        }
        return gj;
    }

    @Override
    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    @Override
    public void setConfidenceLevel(int confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public JSONObject addAliases(String path) {
        return this.groupsAndAliases.addAliases(path);
    }

    @Override
    public JSONObject addAliases(InputStream is) {
        return this.groupsAndAliases.addAliases(is);
    }

    @Override
    public JSONObject addGroups(String path) {
        return this.groupsAndAliases.addGroups(path, this.dTerritories);
    }

    @Override
    public JSONObject addGroups(InputStream is) {
        return this.groupsAndAliases.addGroups(is, this.dTerritories);
    }

    @Override
    public boolean isMappable(List<ISMLocation> sMLocations) {
        JSONObject map = this.generateSmallestRegion(sMLocations);
        return !map.get((Object)"status").equals(Status.FAILURE.getName());
    }

    @Override
    public boolean isMappable(List<ISMLocation> sMLocations, String columnHeader) {
        JSONObject map = this.generateSmallestRegion(sMLocations, columnHeader);
        return !map.get((Object)"status").equals(Status.FAILURE.getName());
    }

    @Override
    public JSONObject addGroup(String groupName, List<String> groupElements) {
        return this.groupsAndAliases.addGroup(groupName, groupElements, this.dTerritories);
    }

    @Override
    public Map<String, List<Integer>> getGroups() {
        return this.groupsAndAliases.getGroups();
    }

    private void setDisputedTerritoriesList(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            String string = (String)properties.get(CHINA_TAIWAN_PROPERTY);
            if (string != null) {
                if (string.equalsIgnoreCase(CHINA)) {
                    this.dTerritories.add(DisputedTerritories.ChinaPrecedence);
                } else if (string.equalsIgnoreCase(TAIWAN)) {
                    this.dTerritories.add(DisputedTerritories.TaiwanPrecedence);
                }
            }
            if ((string = (String)properties.get(INDIA_PAKISTAN_PROPERTY)) != null) {
                if (string.equalsIgnoreCase(INDIA)) {
                    this.dTerritories.add(DisputedTerritories.IndiaPrecedence);
                } else if (string.equalsIgnoreCase(PAKISTAN)) {
                    this.dTerritories.add(DisputedTerritories.PakistanPrecedence);
                }
            }
            if ((string = (String)properties.get(ISRAEL_WEST_BANK_PROPERTY)) != null) {
                if (string.equalsIgnoreCase(ISRAEL)) {
                    this.dTerritories.add(DisputedTerritories.IsraelPrecedence);
                } else if (string.equalsIgnoreCase(WESTBANK)) {
                    this.dTerritories.add(DisputedTerritories.WestBankPrecedence);
                }
            }
            if ((string = (String)properties.get(DOMAIN_NAME)) != null) {
                this.m_domainName = string;
            }
        }
    }

    public boolean isGenericRegion(List<ISMLocation> locations) {
        if (locations == null || locations.isEmpty()) {
            return false;
        }
        String[] genericRegions = new String[]{"north", "south", "east", "west", "central", "north east", "north west", "south east", "south west"};
        int threshold = 80;
        List<String> list = Arrays.asList(genericRegions);
        int found = 0;
        for (ISMLocation loc : locations) {
            if (!list.contains(loc.getName().toLowerCase())) continue;
            ++found;
        }
        return found * 100 / locations.size() >= threshold;
    }

    @Override
    public JSONObject generateBoundingRegion(List<ISMLocation> sMLocations, String columnHeader, int topPercent, int bottomPercent, int leftPercent, int rightPercent) {
        JSONObject smallestRegion = this.generateSmallestRegionForBounding(sMLocations, columnHeader);
        String status = (String)smallestRegion.get((Object)"status");
        if (!status.equals(Status.FAILURE.getName())) {
            smallestRegion = this.performGenerateBoundingRegion(sMLocations, null, smallestRegion, topPercent, bottomPercent, leftPercent, rightPercent);
        }
        return smallestRegion;
    }

    public JSONObject generateSmallestRegionForBounding(List<ISMLocation> iLocations, String title) {
        boolean boundingRegionFlag;
        if (iLocations == null) {
            SmarterMapsResult result = new SmarterMapsResult();
            result.setStatus(Status.FAILURE);
            return result.convertToJSON();
        }
        SmarterMapsResult result = this.execute(iLocations = this.removeDuplicates(iLocations), title, boundingRegionFlag = true);
        if (result.getGeoJSON() == null) {
            return result.convertToJSON();
        }
        JSONObject geoJSON = result.convertToJSON();
        if (geoJSON != null) {
            this.disputedUnit.processDisputedTerritories(geoJSON, this.dTerritories);
        }
        return geoJSON;
    }

    public static enum Status {
        SUCCESS("OK"),
        FAILURE("Fail"),
        WARNING("Warning"),
        UNKNOWN("Unknown");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum DisputedTerritories {
        ChinaPrecedence,
        TaiwanPrecedence,
        IndiaPrecedence,
        PakistanPrecedence,
        IsraelPrecedence,
        WestBankPrecedence;

    }
}

