/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.SmarterMaps;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SmarterMapsResult {
    private Set<String> unmatchedNames = new HashSet<String>();
    private Set<String> ambiguousNames = new HashSet<String>();
    private List<Integer> uniqueLocationIDs = new ArrayList<Integer>();
    private JSONArray changedNames = new JSONArray();
    private SmarterMaps.Status status = SmarterMaps.Status.UNKNOWN;
    private String failureMessage = "";
    private String ambiguityMessage = "";
    private String warningMessage = "";
    private JSONObject geoJSON = null;
    private String mapName = "";
    private String projection = "";
    private LocationIndexer indexer = LocationIndexer.getInstance();

    public JSONObject convertToJSON() {
        JSONObject output = new JSONObject();
        output.put((Object)"status", (Object)this.status.getName());
        if (this.failureMessage.length() > 0) {
            output.put((Object)"failureMessage", (Object)this.failureMessage);
            return output;
        }
        JSONArray unmatchedNameArray = new JSONArray();
        unmatchedNameArray.addAll(this.getUnmatchedNames());
        if (unmatchedNameArray.size() > 0) {
            output.put((Object)"unmatched", (Object)unmatchedNameArray);
        }
        JSONArray ambiguousNameArray = new JSONArray();
        ambiguousNameArray.addAll(this.getAmbiguousNames());
        if (ambiguousNameArray.size() > 0) {
            output.put((Object)"ambiguous", (Object)ambiguousNameArray);
            if (!this.ambiguityMessage.isEmpty()) {
                output.put((Object)"ambiguityMessage", (Object)this.ambiguityMessage);
            }
        }
        if (!this.warningMessage.isEmpty()) {
            output.put((Object)"warningMessage", (Object)this.warningMessage);
        }
        output.put((Object)"geojson", (Object)this.getGeoJSON());
        output.put((Object)"mapName", (Object)this.getMapName());
        output.put((Object)"projection", (Object)this.getProjection());
        return output;
    }

    public void addUnmatchedName(String unMatchedName) {
        this.unmatchedNames.add(unMatchedName);
    }

    public void addUniqueLocationID(Integer id) {
        this.uniqueLocationIDs.add(id);
    }

    public void addAmbiguousNames(String ambigousName) {
        this.ambiguousNames.add(ambigousName);
    }

    public void setStatus(SmarterMaps.Status status) {
        this.status = status;
    }

    void setGeoJSON(JSONObject geoJSON) {
        this.geoJSON = geoJSON;
    }

    public void updateStatus() {
        if (this.geoJSON == null) {
            this.setStatus(SmarterMaps.Status.FAILURE);
            this.setFailureMessage("The map cannot be generated");
        } else {
            if (this.status == SmarterMaps.Status.WARNING) {
                return;
            }
            if (!this.getUnmatchedNames().isEmpty() || !this.getAmbiguousNames().isEmpty()) {
                this.setStatus(SmarterMaps.Status.WARNING);
            } else {
                this.setStatus(SmarterMaps.Status.SUCCESS);
            }
        }
    }

    public void resolveGeoJSON(List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories, boolean boundingRegion) {
        List<Integer> locIds = this.getUniqueLocationIDs();
        if (!locIds.isEmpty()) {
            if (locIds.size() == 1) {
                int locId = (Integer)locIds.toArray()[0];
                LocationEntry entry = this.indexer.getLocation(locId);
                int parentId = entry.getParents().get(0);
                LocationEntry parentEntry = this.indexer.getLocation(parentId);
                List<Integer> childrenIds = parentEntry.getChildren();
                if (childrenIds.size() > 1) {
                    int sibling = childrenIds.get(0);
                    if (sibling == locId) {
                        sibling = childrenIds.get(1);
                    }
                    locIds.add(sibling);
                    locationNames.add(this.indexer.getLocation(sibling).getName());
                    this.geoJSON = this.indexer.getSmallestGeoJSON(locIds, locationNames, dTerritories, boundingRegion);
                } else {
                    try {
                        this.geoJSON = (JSONObject)JSON.parse((String)parentEntry.getGeoJSON());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mapName = this.indexer.getLocation(parentId).getName();
            } else {
                this.geoJSON = this.indexer.getSmallestGeoJSON(locIds, locationNames, dTerritories, boundingRegion);
                Integer mapId = this.indexer.getNearestCommonAncestorId(locIds, dTerritories);
                this.mapName = this.indexer.getLocation(mapId).getName();
                if (this.indexer.getLocation(mapId).getType() == LocationEntry.Type.COUNTRY) {
                    this.geoJSON = this.replaceRegions(locIds, locationNames, mapId);
                }
            }
            int len = locIds.size();
            for (int i = 0; i < len; ++i) {
                String officialName;
                int locId = locIds.get(i);
                String locname = locationNames.get(i);
                if (locname.equals(officialName = this.indexer.getLocation(locId).getName())) continue;
                this.replaceNameInGeoJson(locname, officialName);
            }
        }
    }

    private void replaceNameInGeoJson(String newName, String officialName) {
        JSONArray featuresObjArr = (JSONArray)this.geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name = propObj.get((Object)"name").toString();
            if (!name.equals(officialName)) continue;
            propObj.put((Object)"name", (Object)newName);
        }
    }

    private JSONObject replaceRegions(List<Integer> locIds, List<String> locationNames, Integer mapId) {
        JSONObject newGeoJson = new JSONObject();
        newGeoJson.put((Object)"type", (Object)"FeatureCollection");
        JSONArray newFeatures = new JSONArray();
        newGeoJson.put((Object)"features", (Object)newFeatures);
        HashMap<String, JSONObject> mapOfRegionFeatures = new HashMap<String, JSONObject>();
        for (Integer locId : locIds) {
            LocationEntry entry = this.indexer.getLocation(locId);
            if (entry.getType() != LocationEntry.Type.REGION) continue;
            String name = this.indexer.getLocation(locId).getName();
            JSONObject regionFeature = new JSONObject();
            JSONObject regionProperties = new JSONObject();
            JSONObject regionGeometry = new JSONObject();
            regionProperties.put((Object)"name", (Object)name);
            regionGeometry.put((Object)"type", (Object)"MultiPolygon");
            regionGeometry.put((Object)"coordinates", (Object)new JSONArray());
            regionFeature.put((Object)"type", (Object)"Feature");
            regionFeature.put((Object)"properties", (Object)regionProperties);
            regionFeature.put((Object)"geometry", (Object)regionGeometry);
            mapOfRegionFeatures.put(name, regionFeature);
        }
        JSONArray featuresObjArr = (JSONArray)this.geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String region1 = (String)propObj.get((Object)"region");
            if (!locationNames.contains(region1)) {
                newFeatures.add((Object)featureObj);
                continue;
            }
            JSONObject regionFeature1 = (JSONObject)mapOfRegionFeatures.get(region1);
            if (regionFeature1 == null) {
                newFeatures.add((Object)featureObj);
                continue;
            }
            JSONObject geom = (JSONObject)regionFeature1.get((Object)"geometry");
            JSONArray regionCoordinates = (JSONArray)geom.get((Object)"coordinates");
            JSONObject geometryObj = (JSONObject)featureObj.get((Object)"geometry");
            String type = (String)geometryObj.get((Object)"type");
            if (type.equals("Polygon")) {
                regionCoordinates.add(geometryObj.get((Object)"coordinates"));
                continue;
            }
            if (!type.equals("MultiPolygon")) continue;
            JSONArray multiPolygon = (JSONArray)geometryObj.get((Object)"coordinates");
            for (int j = 0; j < multiPolygon.size(); ++j) {
                JSONArray multiPoly = (JSONArray)multiPolygon.get(j);
                regionCoordinates.add((Object)multiPoly);
            }
        }
        Collection values = mapOfRegionFeatures.values();
        for (JSONObject regionFeature : values) {
            newFeatures.add((Object)regionFeature);
        }
        return newGeoJson;
    }

    public List<Integer> getUniqueLocationIDs() {
        return this.uniqueLocationIDs;
    }

    public Set<String> getUnmatchedNames() {
        return this.unmatchedNames;
    }

    public JSONArray getChangedNames() {
        return this.changedNames;
    }

    public Set<String> getAmbiguousNames() {
        return this.ambiguousNames;
    }

    public SmarterMaps.Status getStatus() {
        return this.status;
    }

    public JSONObject getGeoJSON() {
        return this.geoJSON;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getAmbiguityMessage() {
        return this.ambiguityMessage;
    }

    public void setAmbiguityMessage(String ambiguityMessage) {
        this.ambiguityMessage = ambiguityMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public void setMapName(String name) {
        this.mapName = name;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public String getProjection() {
        this.projection = this.mapName.compareToIgnoreCase("North America") == 0 || this.mapName.compareToIgnoreCase("Northern America") == 0 || this.mapName.compareToIgnoreCase("Canada") == 0 ? "stereographic" : (this.mapName.compareToIgnoreCase("WhiteSox") == 0 ? "simple" : "mercator");
        return this.projection;
    }

    public void setProjection(String _projection) {
        this.projection = _projection;
    }
}

