/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.SmarterMaps;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class AmbiguityHandler {
    private LocationIndexer indexer = null;
    private String ambiguityMessage = "";

    public void setIndexer(LocationIndexer indexer) {
        this.indexer = indexer;
    }

    public String getAmbiguityMessage() {
        return this.ambiguityMessage;
    }

    public void clearAmbiguityMessage() {
        this.ambiguityMessage = "";
    }

    public Integer disambiguate(String name, String title, List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories) {
        List<Integer> locIds = this.indexer.getLocationIds(name);
        Integer id = this.getLocationIdFromCommonParents(name, locationNames);
        if (id != null) {
            return id;
        }
        LocationEntry.Type type = this.findColumnType(title);
        ArrayList<Integer> locList = new ArrayList<Integer>(locIds);
        int lastLocId = -1;
        int count = 0;
        for (Integer locId : locList) {
            if (this.indexer.getLocation(locId).getType() != type) continue;
            ++count;
            lastLocId = locId;
        }
        if (count == 1) {
            return lastLocId;
        }
        this.ambiguityMessage = this.ambiguityMessage + name + " is:";
        for (Integer locId : locIds) {
            LocationEntry entry = this.indexer.getLocation(locId);
            Integer parentId = entry.getParents().get(0);
            LocationEntry parent = this.indexer.getLocation(parentId);
            this.ambiguityMessage = this.ambiguityMessage + "\n" + (Object)((Object)entry.getType()) + " in " + parent.getName();
            if (parent.getType() == LocationEntry.Type.COUNTRY) continue;
            parentId = parent.getParents().get(0);
            this.ambiguityMessage = this.ambiguityMessage + ", " + this.indexer.getLocation(parentId).getName();
        }
        this.ambiguityMessage = this.ambiguityMessage + "\n";
        boolean hasDifferentTypes = this.hasDifferentTypes(name);
        if (!hasDifferentTypes) {
            return this.disambiguateSameType(name, locationNames, dTerritories);
        }
        return this.disambiguateDifferentTypes(name, title, locationNames, dTerritories);
    }

    private Integer getLocationIdFromCommonParents(String name, List<String> locationNames) {
        List<Integer> commonParents = this.getCommonParents(locationNames);
        if (commonParents.size() == 1) {
            Integer parentId = commonParents.get(0);
            LocationEntry parent = this.indexer.getLocation(parentId);
            List<Integer> children = parent.getChildren();
            for (Integer child : children) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(this.indexer.getLocation(child).getName());
                names.addAll(this.indexer.getLocation(child).getAliases());
                for (String name2 : names) {
                    if (!this.indexer.equalsNormalized(name, name2)) continue;
                    return child;
                }
            }
        }
        return null;
    }

    private Integer disambiguateSameType(String name, List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories) {
        Integer result = null;
        Integer id1 = this.getLocationIdFromCommonParents(name, locationNames);
        if (id1 != null) {
            return id1;
        }
        Integer smallestAncestor = this.getSmallestAncestor(locationNames, dTerritories);
        List<Integer> locIds = this.indexer.getLocationIds(name);
        ArrayList<Integer> idsForThisAncestor = new ArrayList<Integer>();
        for (Integer locId : locIds) {
            if (!this.isAncestor(smallestAncestor, locId, dTerritories)) continue;
            idsForThisAncestor.add(locId);
        }
        if (idsForThisAncestor.size() == 1) {
            result = (Integer)idsForThisAncestor.get(0);
        } else {
            int maxPop = 0;
            Integer maxId = -1;
            for (Integer id : idsForThisAncestor) {
                int pop = this.indexer.getLocation(id).getPop();
                if (pop <= maxPop) continue;
                maxPop = pop;
                maxId = id;
            }
            result = maxId > -1 ? maxId : (Integer)idsForThisAncestor.get(0);
        }
        return result;
    }

    private Integer disambiguateDifferentTypes(String name, String title, List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories) throws RuntimeException {
        LocationEntry.Type titleType = this.findColumnType(title);
        if (titleType == null) {
            titleType = this.getCommonType(locationNames);
        }
        Integer smallestAncestor = this.getSmallestAncestor(locationNames, dTerritories);
        int maxPop = 0;
        Integer maxId = -1;
        List<Integer> locIds = this.indexer.getLocationIds(name);
        ArrayList<Integer> foundLocIds = new ArrayList<Integer>();
        for (Integer locId : locIds) {
            LocationEntry entry = this.indexer.getLocation(locId);
            if (!this.isAncestor(smallestAncestor, locId, dTerritories)) continue;
            LocationEntry.Type entryType = entry.getType();
            foundLocIds.add(locId);
            if (entryType != LocationEntry.Type.CITY) continue;
            int pop = entry.getPop();
            if (maxPop != 0 && pop <= maxPop) continue;
            maxPop = pop;
            maxId = locId;
        }
        if (foundLocIds.size() == 1) {
            return (Integer)foundLocIds.get(0);
        }
        ArrayList<Integer> subregions = new ArrayList<Integer>();
        ArrayList<Integer> provinces = new ArrayList<Integer>();
        ArrayList<Integer> regions = new ArrayList<Integer>();
        ArrayList<Integer> cities = new ArrayList<Integer>();
        ArrayList<Integer> countries = new ArrayList<Integer>();
        for (Integer locId : foundLocIds) {
            LocationEntry entry = this.indexer.getLocation(locId);
            switch (entry.getType()) {
                case SUBREGION: {
                    subregions.add(locId);
                    break;
                }
                case PROVINCE: {
                    provinces.add(locId);
                    break;
                }
                case REGION: {
                    regions.add(locId);
                    break;
                }
                case CITY: {
                    cities.add(locId);
                    break;
                }
                case COUNTRY: {
                    countries.add(locId);
                    break;
                }
            }
        }
        if (titleType == LocationEntry.Type.SUBREGION) {
            if (subregions.size() == 1) {
                return (Integer)subregions.get(0);
            }
        } else if (titleType == LocationEntry.Type.COUNTRY) {
            if (countries.size() == 1) {
                return (Integer)countries.get(0);
            }
        } else if (titleType == LocationEntry.Type.REGION) {
            if (regions.size() == 1) {
                return (Integer)regions.get(0);
            }
        } else {
            if (titleType == LocationEntry.Type.PROVINCE && provinces.size() > 0) {
                if (provinces.size() == 1) {
                    return (Integer)provinces.get(0);
                }
                StringBuffer where = new StringBuffer();
                for (Integer province : provinces) {
                    Integer parentId = this.indexer.getLocation(province).getParents().get(0);
                    where.append(this.indexer.getLocation(parentId).getName() + " and ");
                }
                throw new RuntimeException("Cannot draw the map because it contains duplicate names: " + name + " appears as " + (Object)((Object)titleType) + " in : " + where.substring(0, where.length() - 4));
            }
            if (cities.size() > 0) {
                return maxId;
            }
        }
        if (this.isAncestor((Integer)foundLocIds.get(0), (Integer)foundLocIds.get(1), dTerritories)) {
            return (Integer)foundLocIds.get(0);
        }
        if (this.isAncestor((Integer)foundLocIds.get(1), (Integer)foundLocIds.get(0), dTerritories)) {
            return (Integer)foundLocIds.get(1);
        }
        System.out.println("Unknown ambiguity case " + name);
        return null;
    }

    private LocationEntry.Type findColumnType(String title) {
        if (title == null) {
            return null;
        }
        String lowerCaseTitle = title.toLowerCase();
        LocationEntry.Type titleType = null;
        if (lowerCaseTitle.equals("city") || lowerCaseTitle.equals("cities")) {
            titleType = LocationEntry.Type.CITY;
        } else if (lowerCaseTitle.equals("region") || lowerCaseTitle.equals("regions")) {
            titleType = LocationEntry.Type.GROUP;
        } else if (lowerCaseTitle.equals("province") || lowerCaseTitle.equals("provinces") || lowerCaseTitle.equals("state") || lowerCaseTitle.equals("states")) {
            titleType = LocationEntry.Type.PROVINCE;
        } else if (lowerCaseTitle.equals("country") || lowerCaseTitle.equals("countries")) {
            titleType = LocationEntry.Type.COUNTRY;
        } else {
            return null;
        }
        return titleType;
    }

    private LocationEntry.Type getCommonType(List<String> locationNames) {
        LocationEntry.Type titleType = null;
        int cityCount = 0;
        int groupCount = 0;
        int provinceCount = 0;
        int countryCount = 0;
        int subregionCount = 0;
        for (String locationName : locationNames) {
            if (this.nameCanBe(LocationEntry.Type.SUBREGION, locationName)) {
                ++subregionCount;
            }
            if (this.nameCanBe(LocationEntry.Type.CITY, locationName)) {
                ++cityCount;
            }
            if (this.nameCanBe(LocationEntry.Type.PROVINCE, locationName)) {
                ++provinceCount;
            }
            if (this.nameCanBe(LocationEntry.Type.GROUP, locationName)) {
                ++groupCount;
            }
            if (!this.nameCanBe(LocationEntry.Type.COUNTRY, locationName)) continue;
            ++countryCount;
        }
        int len = locationNames.size();
        if (titleType == LocationEntry.Type.SUBREGION && subregionCount == len) {
            return titleType;
        }
        if (titleType == LocationEntry.Type.COUNTRY && countryCount == len) {
            return titleType;
        }
        if (titleType == LocationEntry.Type.PROVINCE && provinceCount == len) {
            return titleType;
        }
        if (titleType == LocationEntry.Type.CITY && cityCount == len) {
            return titleType;
        }
        if (titleType == null) {
            if (cityCount == len) {
                return LocationEntry.Type.CITY;
            }
            if (subregionCount == len) {
                return LocationEntry.Type.SUBREGION;
            }
            if (provinceCount == len) {
                return LocationEntry.Type.PROVINCE;
            }
            if (countryCount == len) {
                return LocationEntry.Type.COUNTRY;
            }
        }
        if (len >= 5) {
            len = (int)(0.8 * (double)len);
        }
        if (cityCount >= len) {
            titleType = LocationEntry.Type.CITY;
        } else if (countryCount >= len) {
            titleType = LocationEntry.Type.COUNTRY;
        } else if (provinceCount + countryCount >= len) {
            titleType = LocationEntry.Type.PROVINCE;
        } else if (groupCount >= len) {
            titleType = LocationEntry.Type.GROUP;
        } else {
            return null;
        }
        return titleType;
    }

    private boolean isAncestor(Integer smallestAncestor, Integer locId, List<SmarterMaps.DisputedTerritories> dTerritories) {
        List<Integer> path = this.indexer.getPathToRoot(locId, dTerritories);
        return path.contains(smallestAncestor);
    }

    private boolean nameCanBe(LocationEntry.Type nameType, String locationName) {
        List<Integer> locIds = this.indexer.getLocationIds(locationName);
        for (Integer locId : locIds) {
            LocationEntry.Type type = this.indexer.getLocation(locId).getType();
            if (type != nameType) continue;
            return true;
        }
        return false;
    }

    private Integer getSmallestAncestor(List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories) {
        ArrayList commonAncestors = null;
        for (String name : locationNames) {
            List<Integer> locIds = this.indexer.getLocationIds(name);
            if (locIds.size() == 0) continue;
            HashSet<Integer> ancestors = new HashSet<Integer>();
            for (Integer locId : locIds) {
                List<Integer> path = this.indexer.getPathToRoot(locId, dTerritories);
                ancestors.addAll(path);
            }
            if (commonAncestors == null) {
                commonAncestors = new ArrayList(ancestors);
                continue;
            }
            ArrayList<Integer> newCommonAncestors = new ArrayList<Integer>();
            for (Integer commonAncestor : commonAncestors) {
                if (!ancestors.contains(commonAncestor)) continue;
                newCommonAncestors.add(commonAncestor);
            }
            commonAncestors = newCommonAncestors;
        }
        Integer max = (Integer)Collections.max(commonAncestors);
        return max;
    }

    private List<Integer> getCommonParents(List<String> locationNames) {
        ArrayList commonParents = null;
        for (String name : locationNames) {
            List<Integer> locIds = this.indexer.getLocationIds(name);
            if (locIds.size() == 0) continue;
            ArrayList<Integer> parents = new ArrayList<Integer>();
            for (Integer locId : locIds) {
                parents.addAll(this.indexer.getLocation(locId).getParents());
            }
            if (commonParents == null) {
                commonParents = new ArrayList(parents);
                continue;
            }
            ArrayList<Integer> newCommonParents = new ArrayList<Integer>();
            for (Integer commonParent : commonParents) {
                if (!parents.contains(commonParent)) continue;
                newCommonParents.add(commonParent);
            }
            commonParents = newCommonParents;
        }
        return commonParents;
    }

    private boolean hasDifferentTypes(String name) {
        List<Integer> locIds = this.indexer.getLocationIds(name);
        HashSet<LocationEntry.Type> types = new HashSet<LocationEntry.Type>();
        for (Integer locId : locIds) {
            types.add(this.indexer.getLocation(locId).getType());
        }
        return types.size() > 1;
    }

    public Integer disambiguate(String name, String title, List<String> locationNames) {
        return this.disambiguate(name, title, locationNames, null);
    }
}

