/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.SmarterMaps;
import com.ibm.athena.smartermaps.model.AddressIndex;
import com.ibm.athena.smartermaps.model.AmbiguityHandler;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationTableHandler;
import com.ibm.athena.smartermaps.util.MapsUtilities;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class LocationIndexer {
    private static final LocationIndexer INSTANCE = new LocationIndexer();
    private Map<Integer, LocationEntry> locationTable = null;
    private MapsUtilities mapUtilities = null;
    private AmbiguityHandler ambiguityHandler = null;
    private LocationTableHandler locationTableHandler = null;
    private List<String> unmatchedNames = new ArrayList<String>();
    private static final String ALASKA = "Alaska";
    private static final String HAWAII = "Hawaii";

    private LocationIndexer() {
        this.mapUtilities = new MapsUtilities();
        this.ambiguityHandler = new AmbiguityHandler();
        this.ambiguityHandler.setIndexer(this);
        this.locationTableHandler = new LocationTableHandler();
        try {
            this.locationTable = this.locationTableHandler.getLocationTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LocationIndexer getInstance() {
        return INSTANCE;
    }

    public String getAmbiguityMessage() {
        return this.ambiguityHandler.getAmbiguityMessage();
    }

    public AmbiguityHandler getAmbiguityHandler() {
        return this.ambiguityHandler;
    }

    public List<AddressIndex> getAllNames() {
        ArrayList<AddressIndex> allNames = new ArrayList<AddressIndex>();
        Set<Integer> keys = this.locationTable.keySet();
        for (Integer locId : keys) {
            LocationEntry locationEntry = this.locationTable.get(locId);
            String name = locationEntry.getName();
            allNames.add(new AddressIndex(name, locId));
            List<String> aliases = locationEntry.getAliases();
            if (aliases.size() <= 0) continue;
            for (int i = 0; i < aliases.size(); ++i) {
                allNames.add(new AddressIndex(aliases.get(i), locId));
            }
        }
        return allNames;
    }

    public JSONObject getFeatureForName(JSONObject geoJSON, LocationEntry entry) {
        JSONArray featuresObjArr = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name = propObj.get((Object)"name").toString();
            if (!this.equalsNameOrAlias(name, entry)) continue;
            return featureObj;
        }
        return null;
    }

    public LocationEntry getLocation(Integer locationId) {
        return this.locationTable.get(locationId);
    }

    public List<Integer> getLocationIds(String name) {
        return this.locationTableHandler.getAllLocationIds(name);
    }

    public Integer getNearestCommonAncestorId(List<Integer> locIds, List<SmarterMaps.DisputedTerritories> dTerritories) {
        if (locIds == null || locIds.size() < 1) {
            return null;
        }
        if (locIds.size() == 1) {
            return (Integer)locIds.toArray()[0];
        }
        List<Integer> path = null;
        Integer first = null;
        for (Integer locId : locIds) {
            if (first == null) {
                first = locId;
                path = this.getPathToRoot(locId, dTerritories);
                continue;
            }
            List<Integer> path1 = this.getPathToRoot(locId, dTerritories);
            path = this.getCommonPath(path, path1);
        }
        int size = path.size() - 1;
        return (Integer)path.get(size);
    }

    private Integer getParentIdWithDisputedTerritories(Integer locId, List<SmarterMaps.DisputedTerritories> dTerritories) {
        if (dTerritories == null) {
            return null;
        }
        if (dTerritories.contains((Object)SmarterMaps.DisputedTerritories.IsraelPrecedence) && this.hasAncestor(locId, "West Bank")) {
            return this.getLocationIds("Israel").get(0);
        }
        if (dTerritories.contains((Object)SmarterMaps.DisputedTerritories.PakistanPrecedence) && this.hasAncestor(locId, "Jammu and Kashmir")) {
            return this.getLocationIds("Pakistan").get(0);
        }
        if (!dTerritories.contains((Object)SmarterMaps.DisputedTerritories.TaiwanPrecedence) && this.hasAncestor(locId, "Taiwan")) {
            return this.getLocationIds("China").get(0);
        }
        if (!dTerritories.contains((Object)SmarterMaps.DisputedTerritories.PakistanPrecedence) && this.hasAncestor(locId, "Northern Areas")) {
            return this.getLocationIds("India").get(0);
        }
        return null;
    }

    private boolean hasAncestor(Integer locId, String name) {
        LocationEntry entry = this.getLocation(locId);
        while (!entry.getParents().isEmpty()) {
            if (entry.getName().equals(name)) {
                return true;
            }
            locId = entry.getParents().get(0);
            entry = this.getLocation(locId);
        }
        return false;
    }

    public JSONObject getSmallestGeoJSON(List<Integer> locIds, List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories, boolean boundingRegion) {
        Integer ancestorId = this.getNearestCommonAncestorId(locIds, dTerritories);
        LocationEntry ancestor = this.getLocation(ancestorId);
        if (ancestor == null) {
            return null;
        }
        if (boundingRegion && ancestor.getType() != LocationEntry.Type.WORLD && ancestor.getType() != LocationEntry.Type.SUBREGION && ancestor.getType() != LocationEntry.Type.CONTINENT) {
            ancestorId = ancestor.getParents().get(0);
            ancestor = this.getLocation(ancestorId);
            while (ancestor.getType() != LocationEntry.Type.CONTINENT) {
                ancestorId = ancestor.getParents().get(0);
                ancestor = this.getLocation(ancestorId);
            }
        }
        String geoJSONString = null;
        if (ancestor.getType() == LocationEntry.Type.CITY) {
            Integer parent = ancestor.getParents().get(0);
            ancestor = this.locationTable.get(parent);
        }
        geoJSONString = this.getGeoJSON(ancestor);
        JSONObject geoJSON = null;
        try {
            geoJSON = JSONObject.parse((String)geoJSONString);
            geoJSON = this.resolveContinentsAndRegions(geoJSON, locIds, dTerritories);
            geoJSON = this.resolveHierarchy(geoJSON, ancestor, locIds);
            geoJSON = this.processUS48or50(geoJSON, ancestor, locIds);
            geoJSON = this.addCities(geoJSON, ancestor, locIds, locationNames);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (Integer locId : locIds) {
            LocationEntry entry = this.getLocation(locId);
            List<String> aliases = entry.getAliases();
            for (String locName : locationNames) {
                if (!this.containsNormalized(aliases, locName)) continue;
                this.locationTableHandler.replaceNameInGeoJSON(geoJSON, entry.getName(), locName);
            }
        }
        return geoJSON;
    }

    private JSONObject resolveContinentsAndRegions(JSONObject geoJSON, List<Integer> locIds, List<SmarterMaps.DisputedTerritories> dTerritories) {
        JSONObject result = geoJSON;
        for (Integer locId : locIds) {
            LocationEntry entry = this.getLocation(locId);
            if (entry.getType() == LocationEntry.Type.SUBREGION) {
                result = this.mergePolygons(result, entry.getName(), entry.getChildren(), dTerritories);
                continue;
            }
            if (entry.getType() != LocationEntry.Type.CONTINENT) continue;
            ArrayList<Integer> countryIds = new ArrayList<Integer>();
            List<Integer> subregionIds = entry.getChildren();
            for (int i = 0; i < subregionIds.size(); ++i) {
                LocationEntry countryId = this.getLocation(subregionIds.get(i));
                countryIds.addAll(countryId.getChildren());
            }
            result = this.mergePolygons(result, entry.getName(), countryIds, dTerritories);
        }
        return result;
    }

    public JSONObject mergePolygons(JSONObject geojson, String groupName, List<Integer> childrenIds, List<SmarterMaps.DisputedTerritories> dTerritories) {
        JSONArray features = (JSONArray)geojson.get((Object)"features");
        JSONArray newFeatures = new JSONArray();
        JSONObject groupFeature = new JSONObject();
        JSONObject groupProperties = new JSONObject();
        JSONObject groupGeometry = new JSONObject();
        groupProperties.put((Object)"name", (Object)groupName);
        groupFeature.put((Object)"type", (Object)"Feature");
        groupFeature.put((Object)"properties", (Object)groupProperties);
        groupGeometry.put((Object)"type", (Object)"MultiPolygon");
        JSONArray coordinates = new JSONArray();
        ArrayList<String> namesInGroup = new ArrayList<String>();
        for (Integer locId : childrenIds) {
            namesInGroup.add(this.getLocation(locId).getName());
        }
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject propObj = (JSONObject)feature.get((Object)"properties");
            String name = (String)propObj.get((Object)"name");
            if (!namesInGroup.contains(name)) {
                newFeatures.add((Object)feature);
                continue;
            }
            JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
            String type = (String)geometry.get((Object)"type");
            if (type.equals("Polygon")) {
                coordinates.add(geometry.get((Object)"coordinates"));
                continue;
            }
            if (type.equals("MultiPolygon")) {
                JSONArray multiPolygon = (JSONArray)geometry.get((Object)"coordinates");
                for (int j = 0; j < multiPolygon.size(); ++j) {
                    JSONArray multiPoly = (JSONArray)multiPolygon.get(j);
                    if (name.equals("Russia") && this.isEastOfDayChangeLine(multiPoly)) continue;
                    coordinates.add((Object)multiPoly);
                }
                continue;
            }
            System.out.println("bad geometry");
        }
        groupGeometry.put((Object)"coordinates", (Object)coordinates);
        groupFeature.put((Object)"geometry", (Object)groupGeometry);
        newFeatures.add((Object)groupFeature);
        geojson.put((Object)"features", (Object)newFeatures);
        return geojson;
    }

    private boolean isEastOfDayChangeLine(JSONArray multiPoly) {
        JSONArray mp1 = (JSONArray)multiPoly.get(0);
        for (int i = 0; i < multiPoly.size(); ++i) {
            JSONArray mp = (JSONArray)mp1.get(i);
            Double longitude = (Double)mp.get(0);
            if (!(longitude < 0.0)) continue;
            return true;
        }
        return false;
    }

    private JSONObject processUS48or50(JSONObject geoJSON, LocationEntry ancestor, List<Integer> locIds) {
        if (ancestor.getName().equals("United States of America")) {
            boolean is50statesMap = false;
            for (Integer locId : locIds) {
                String name = this.locationTable.get(locId).getName();
                if (!name.equals(ALASKA) && !name.equals(HAWAII)) continue;
                is50statesMap = true;
                break;
            }
            if (!is50statesMap) {
                geoJSON = this.mapUtilities.removePart(geoJSON, ALASKA);
                geoJSON = this.mapUtilities.removePart(geoJSON, HAWAII);
            } else {
                geoJSON = this.mapUtilities.reducePart(geoJSON, ALASKA, 0.4);
                geoJSON = this.mapUtilities.movePart(geoJSON, ALASKA, 50, -30);
                geoJSON = this.mapUtilities.movePart(geoJSON, HAWAII, 58, 2);
            }
        }
        return geoJSON;
    }

    private JSONObject resolveHierarchy(JSONObject geoJSON, LocationEntry ancestor, List<Integer> locIds) throws IOException {
        if (ancestor.getType() == LocationEntry.Type.SUBREGION || ancestor.getType() == LocationEntry.Type.CONTINENT || ancestor.getType() == LocationEntry.Type.WORLD) {
            LocationEntry element;
            HashSet<Integer> provincesMapIds = new HashSet<Integer>();
            for (Integer locId : locIds) {
                element = this.locationTable.get(locId);
                if (element.getType() != LocationEntry.Type.PROVINCE) continue;
                Integer parent = element.getParents().get(0);
                element = this.locationTable.get(parent);
                while (element.getType() != LocationEntry.Type.COUNTRY) {
                    parent = element.getParents().get(0);
                    element = this.locationTable.get(parent);
                }
                provincesMapIds.add(parent);
            }
            if (provincesMapIds.size() > 0) {
                for (Integer locId : provincesMapIds) {
                    element = this.locationTable.get(locId);
                    JSONArray features = (JSONArray)geoJSON.get((Object)"features");
                    JSONArray newFeatures = new JSONArray();
                    for (int i = 0; i < features.size(); ++i) {
                        JSONObject feature = (JSONObject)features.get(i);
                        JSONObject properties = (JSONObject)feature.get((Object)"properties");
                        if (properties.get((Object)"name").equals(element.getName())) continue;
                        newFeatures.add((Object)feature);
                    }
                    geoJSON.put((Object)"features", (Object)newFeatures);
                    String provinceGeoJSONString = element.getGeoJSON();
                    JSONObject provinceGeoJSON = JSONObject.parse((String)provinceGeoJSONString);
                    geoJSON = this.addGeoJSON(geoJSON, provinceGeoJSON);
                }
            }
        }
        return geoJSON;
    }

    private JSONObject addCities(JSONObject geoJSON, LocationEntry ancestor, List<Integer> locIds, List<String> locationNames) throws IOException {
        if (!this.containsCities(locIds)) {
            return geoJSON;
        }
        List<Integer> cities = this.getCities(ancestor, locIds);
        String cityGeoJSONString = "{\"type\":\"FeatureCollection\",\"features\":[]}";
        JSONObject cityGeoJSON = JSONObject.parse((String)cityGeoJSONString);
        JSONArray features = (JSONArray)cityGeoJSON.get((Object)"features");
        for (int i = 0; i < cities.size(); ++i) {
            int cityId = cities.get(i);
            LocationEntry city = this.locationTable.get(cityId);
            String cityCoordinates = city.getGeoJSON();
            if (cityCoordinates == null) continue;
            int len = cityCoordinates.length();
            int ic = cityCoordinates.indexOf(44);
            Double longitude = Double.valueOf(cityCoordinates.substring(1, ic));
            Double latitude = Double.valueOf(cityCoordinates.substring(ic + 1, len - 1));
            JSONArray array = new JSONArray();
            array.add((Object)longitude);
            array.add((Object)latitude);
            JSONObject feature = new JSONObject();
            feature.put((Object)"type", (Object)"Feature");
            JSONObject point = new JSONObject();
            point.put((Object)"type", (Object)"Point");
            point.put((Object)"coordinates", (Object)array);
            JSONObject properties = new JSONObject();
            String name = null;
            for (String cityName : locationNames) {
                if (cityName.contains(",")) {
                    cityName = this.findNameInComplex(cityName, LocationEntry.Type.CITY, locIds);
                }
                if (!this.equalsNameOrAlias(cityName, city)) continue;
                name = cityName;
            }
            properties.put((Object)"name", name);
            feature.put((Object)"properties", (Object)properties);
            feature.put((Object)"geometry", (Object)point);
            features.add((Object)feature);
        }
        geoJSON.put((Object)"cities", (Object)cityGeoJSON);
        return geoJSON;
    }

    public String findNameInComplex(String cityName, LocationEntry.Type city, List<Integer> locIds2) {
        StringTokenizer st = new StringTokenizer(cityName, ",");
        while (st.hasMoreTokens()) {
            Integer commonId;
            String cityname1 = (String)st.nextElement();
            List<Integer> locIds = this.getLocationIds(cityname1);
            locIds.retainAll(locIds2);
            if (locIds.size() <= 0 || this.getLocation(commonId = locIds.get(0)).getType() != LocationEntry.Type.CITY) continue;
            cityName = cityname1;
            break;
        }
        return cityName;
    }

    public String findNewName(String name, Integer locId) {
        LocationEntry entry = this.getLocation(locId);
        StringTokenizer st = new StringTokenizer(name, ",");
        while (st.hasMoreTokens()) {
            String name1 = (String)st.nextElement();
            if (!this.equalsNameOrAlias(name1, entry)) continue;
            return name1;
        }
        return null;
    }

    public boolean equalsNameOrAlias(String name1, LocationEntry entry) {
        return this.equalsNormalized(name1, entry.getName()) || this.containsNormalized(entry.getAliases(), name1);
    }

    private boolean containsCities(List<Integer> locIds) {
        for (Integer locId : locIds) {
            if (this.locationTable.get(locId).getType() != LocationEntry.Type.CITY) continue;
            return true;
        }
        return false;
    }

    private String getGeoJSON(LocationEntry locationEntry) {
        String geoJSONString = locationEntry.getGeoJSON();
        if (geoJSONString.equals("children")) {
            JSONObject geoJSON = new JSONObject();
            List<Integer> children = locationEntry.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                LocationEntry child = this.locationTable.get(children.get(i));
                try {
                    geoJSON = this.addGeoJSON(geoJSON, JSONObject.parse((String)this.getGeoJSON(child)));
                    continue;
                }
                catch (IOException e) {
                    return null;
                }
            }
            geoJSONString = geoJSON.toString();
        } else {
            if (locationEntry.getType() == LocationEntry.Type.GROUP) {
                Integer parentLoc = locationEntry.getParents().get(0);
                String parentMap = this.getGeoJSON(this.locationTable.get(parentLoc));
                List<Integer> children = locationEntry.getChildren();
                ArrayList<String> mapElem = new ArrayList<String>();
                for (Integer c : children) {
                    mapElem.add(this.locationTable.get(c).getName());
                }
                return this.getReducedMap(parentMap, mapElem);
            }
            if (geoJSONString.equals("parent")) {
                Integer parentLoc = locationEntry.getParents().get(0);
                String parentMap = this.getGeoJSON(this.locationTable.get(parentLoc));
                ArrayList<String> mapElem = new ArrayList<String>();
                mapElem.add(locationEntry.getName());
                return this.getReducedMap(parentMap, mapElem);
            }
        }
        return geoJSONString;
    }

    private String getReducedMap(String parentMap, List<String> mapElem) {
        JSONObject geoJSON = null;
        try {
            geoJSON = JSONObject.parse((String)parentMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        JSONArray features = (JSONArray)geoJSON.get((Object)"features");
        JSONArray newFeatures = new JSONArray();
        geoJSON.put((Object)"features", (Object)newFeatures);
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject prop = (JSONObject)feature.get((Object)"properties");
            String sName = (String)prop.get((Object)"region");
            if (sName == null || !this.containsNormalized(mapElem, sName)) continue;
            newFeatures.add((Object)feature);
            geoJSON.put((Object)"features", (Object)newFeatures);
        }
        return geoJSON.toString();
    }

    private List<Integer> getCities(LocationEntry locationEntry, List<Integer> locIds) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<Integer> children = locationEntry.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Integer child = children.get(i);
            LocationEntry childEntry = this.locationTable.get(child);
            if (childEntry.getType() == LocationEntry.Type.CITY) {
                if (!locIds.contains(child)) continue;
                result.add(child);
                continue;
            }
            result.addAll(this.getCities(childEntry, locIds));
        }
        return result;
    }

    private JSONObject addGeoJSON(JSONObject geoJson1, JSONObject geoJson2) {
        if (geoJson1.isEmpty()) {
            return geoJson2;
        }
        JSONArray featuresObjArr = (JSONArray)geoJson1.get((Object)"features");
        JSONArray featuresObjArr1 = (JSONArray)geoJson2.get((Object)"features");
        if (featuresObjArr1 == null) {
            System.out.println();
        }
        featuresObjArr.addAll((Collection)featuresObjArr1);
        return geoJson1;
    }

    private List<Integer> getCommonPath(List<Integer> path1, List<Integer> path2) {
        Integer p2;
        Integer p1;
        int count = path1.size();
        if (path2.size() < count) {
            count = path2.size();
        }
        ArrayList<Integer> commonPath = new ArrayList<Integer>();
        commonPath.add(path1.get(0));
        for (int i = 1; i < count && (p1 = path1.get(i)).equals(p2 = path2.get(i)); ++i) {
            commonPath.add(path1.get(i));
        }
        return commonPath;
    }

    public List<Integer> getPathToRoot(Integer locationId, List<SmarterMaps.DisputedTerritories> dTerritories) {
        Integer parentId = this.getParentIdWithDisputedTerritories(locationId, dTerritories);
        LocationEntry node = null;
        if (parentId == null) {
            parentId = this.getLocation(locationId).getParents().get(0);
        }
        node = this.locationTable.get(parentId);
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(parentId);
        while (node.getParents().size() > 0) {
            Integer parent = node.getParents().get(0);
            stack.push(parent);
            node = this.locationTable.get(parent);
        }
        ArrayList<Integer> path = new ArrayList<Integer>();
        while (!stack.isEmpty()) {
            path.add((Integer)stack.pop());
        }
        path.add(locationId);
        return path;
    }

    public Integer disambiguate(String name, String title, List<String> locationNames, List<SmarterMaps.DisputedTerritories> dTerritories) {
        return this.ambiguityHandler.disambiguate(name, title, locationNames, dTerritories);
    }

    public void clearAmbiguityMessage() {
        this.ambiguityHandler.clearAmbiguityMessage();
    }

    public List<String> getUnmatchedNames() {
        return this.unmatchedNames;
    }

    public void clearUnmatchedNames() {
        this.unmatchedNames.clear();
    }

    public JSONObject addAlias(String inputLocation, String alias) {
        JSONObject result = new JSONObject();
        List<Integer> locIds = this.getLocationIds(inputLocation);
        if (locIds == null || locIds.size() == 0) {
            result.put((Object)"not found", (Object)inputLocation);
            return result;
        }
        if (locIds.size() > 1) {
            result.put((Object)"ambiguous name", (Object)inputLocation);
        } else {
            LocationEntry entry = this.locationTable.get(locIds.get(0));
            List<Integer> locIds1 = this.getLocationIds(alias);
            if (locIds1 != null && locIds1.size() > 0) {
                result.put((Object)"alias exists", (Object)alias);
            } else {
                entry.getAliases().add(alias);
            }
        }
        return result;
    }

    public boolean equalsNormalized(String name, String name2) {
        return this.locationTableHandler.equalsNormalized(name, name2);
    }

    public String normalize(String name) {
        return this.locationTableHandler.normalize(name);
    }

    public boolean containsNormalized(List<String> iLocations, String name) {
        String normalizedName = this.normalize(name);
        for (String nameInList : iLocations) {
            String normalizedNameInList = this.normalize(nameInList);
            if (!normalizedNameInList.equals(normalizedName)) continue;
            return true;
        }
        return false;
    }

    public JSONObject getSmallestGeoJSON(List<Integer> locationIds, List<String> locationNames, boolean boundingRegion) {
        return this.getSmallestGeoJSON(locationIds, locationNames, null, boundingRegion);
    }

    public Integer getNearestCommonAncestorId(List<Integer> locationIds) {
        return this.getNearestCommonAncestorId(locationIds, null);
    }

    public LocationEntry getParentOfType(LocationEntry entry, LocationEntry.Type country) {
        LocationEntry parent = null;
        Integer parentId = -1;
        LocationEntry.Type type = null;
        do {
            if ((type = (parent = this.getLocation(parentId = entry.getParents().get(0))).getType()) == LocationEntry.Type.WORLD) {
                return null;
            }
            entry = parent;
        } while (type != LocationEntry.Type.COUNTRY);
        return parent;
    }
}

