/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocationTableHandler {
    private static final String GEOJSON_RESOURCE = "/mapFiles/geoJSON.txt";
    private static final String LOCATION_TABLE_RESOURCE = "/mapFiles/LocationTable.xml";
    private Map<Integer, LocationEntry> locationTable = new HashMap<Integer, LocationEntry>();
    private Map<String, List<Integer>> namesTable = new HashMap<String, List<Integer>>();

    public LocationTableHandler() {
        try {
            this.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void create() throws Exception {
        HashMap<String, String> geoJSONMap = new HashMap<String, String>();
        InputStream inputStream = LocationTableHandler.class.getResourceAsStream(GEOJSON_RESOURCE);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = bufferedReader.readLine();
        while (line != null && line.length() > 0) {
            StringTokenizer st = new StringTokenizer(line, "%");
            String geoJSONLabel = (String)st.nextElement();
            String geoJSON = (String)st.nextElement();
            geoJSONMap.put(geoJSONLabel, geoJSON);
            if (st.hasMoreElements()) {
                String pop = (String)st.nextElement();
                geoJSONMap.put(geoJSONLabel + ".pop", pop);
            }
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        inputStream.close();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        inputStream = LocationTableHandler.class.getResourceAsStream(LOCATION_TABLE_RESOURCE);
        Document doc = docBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList listOfLocations = doc.getElementsByTagName("location");
        Integer locationId = 1;
        for (int i = 0; i < listOfLocations.getLength(); ++i) {
            Element location = (Element)listOfLocations.item(i);
            NodeList textList = null;
            NodeList nameItem = location.getElementsByTagName("name");
            Element nameElement = (Element)nameItem.item(0);
            textList = nameElement.getChildNodes();
            String name = textList.item(0).getNodeValue().trim();
            NodeList typeItem = location.getElementsByTagName("type");
            Element typeElement = (Element)typeItem.item(0);
            textList = typeElement.getChildNodes();
            String typeString = textList.item(0).getNodeValue().trim();
            LocationEntry.Type type = null;
            LocationEntry.Type[] typeArr = LocationEntry.Type.values();
            for (int j = 0; j < typeArr.length; ++j) {
                if (!typeArr[j].name().equals(typeString)) continue;
                type = typeArr[j];
                break;
            }
            ArrayList<Integer> parentsArray = new ArrayList<Integer>();
            NodeList parentsItem = location.getElementsByTagName("parents");
            Element parentsElement = (Element)parentsItem.item(0);
            if (parentsElement != null) {
                NodeList parentsList = parentsElement.getElementsByTagName("p");
                for (int j = 0; j < parentsList.getLength(); ++j) {
                    String parentName = parentsList.item(j).getFirstChild().getNodeValue();
                    Integer parentId = this.getParentLocationId(parentName, name, type);
                    if (parentId == -1) continue;
                    this.locationTable.get(parentId).getChildren().add(locationId);
                    parentsArray.add(parentId);
                }
            }
            ArrayList<String> aliasArray = new ArrayList<String>();
            NodeList aliasItem = location.getElementsByTagName("alias");
            Element aliasElement = (Element)aliasItem.item(0);
            if (aliasElement != null) {
                NodeList aliasList = aliasElement.getElementsByTagName("a");
                for (int j = 0; j < aliasList.getLength(); ++j) {
                    String aliasName = aliasList.item(j).getFirstChild().getNodeValue();
                    aliasArray.add(aliasName);
                }
            }
            ArrayList<Integer> childrenArray = new ArrayList<Integer>();
            LocationEntry locationEntry = new LocationEntry(name, aliasArray, type, parentsArray, childrenArray, null);
            String geoJSON = null;
            if (type == LocationEntry.Type.CONTINENT) {
                geoJSON = "children";
            } else if (type == LocationEntry.Type.REGION || type == LocationEntry.Type.PROVINCE || type == LocationEntry.Type.GROUP) {
                geoJSON = "parent";
            } else {
                String pop;
                String geoJSONLabel = this.createLabel(locationEntry);
                geoJSON = (String)geoJSONMap.get(geoJSONLabel);
                if (type == LocationEntry.Type.CITY && (pop = (String)geoJSONMap.get(geoJSONLabel + ".pop")) != null) {
                    locationEntry.setPop(Integer.parseInt(pop));
                }
            }
            locationEntry.setGeoJSON(geoJSON);
            this.addToLocationTable(locationId, locationEntry);
            Integer n = locationId;
            Integer n2 = locationId = Integer.valueOf(locationId + 1);
        }
    }

    void addToLocationTable(Integer locationId, LocationEntry locationEntry) {
        this.locationTable.put(locationId, locationEntry);
        ArrayList<String> newNames = new ArrayList<String>();
        newNames.add(locationEntry.getName());
        newNames.addAll(locationEntry.getAliases());
        for (String newName : newNames) {
            List<Integer> indList = this.namesTable.get(newName = this.normalize(newName));
            if (indList == null) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(locationId);
                this.namesTable.put(newName, list);
                continue;
            }
            if (indList.contains(locationId)) continue;
            indList.add(locationId);
        }
    }

    public String normalize(String inputName) {
        String newName = inputName.trim();
        newName = Normalizer.normalize(newName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        return newName.toLowerCase();
    }

    public List<Integer> getAllLocationIds(String name) {
        String newName = this.normalize(name);
        return this.namesTable.get(newName);
    }

    void replaceNameInGeoJSON(JSONObject geoJSON, String name1, String name2) {
        JSONObject gj;
        JSONObject featureObj = this.getFeatureForName(geoJSON, name1);
        if (featureObj != null) {
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            propObj.put((Object)"name", (Object)name2);
        }
        if ((gj = (JSONObject)geoJSON.get((Object)"cities")) != null && (featureObj = this.getFeatureForName(geoJSON, name1)) != null) {
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            propObj.put((Object)"name", (Object)name2);
        }
    }

    JSONObject getFeatureForName(JSONObject geoJSON, String name) {
        JSONArray featuresObjArr = (JSONArray)geoJSON.get((Object)"features");
        for (int i = 0; i < featuresObjArr.size(); ++i) {
            JSONObject featureObj = (JSONObject)featuresObjArr.get(i);
            JSONObject propObj = (JSONObject)featureObj.get((Object)"properties");
            String name1 = propObj.get((Object)"name").toString();
            if (!name.equals(name1)) continue;
            return featureObj;
        }
        return null;
    }

    private Integer getParentLocationId(String pName, String name, LocationEntry.Type type) {
        if (!pName.contains(":")) {
            List<Integer> locIds = this.getAllLocationIds(pName);
            if (locIds == null || locIds.size() == 0) {
                System.out.println("parent not found for " + pName);
                return -1;
            }
            if (locIds.size() > 1) {
                return locIds.get(0);
            }
            return locIds.get(0);
        }
        StringTokenizer st = new StringTokenizer(pName, ":");
        String name1 = (String)st.nextElement();
        List<Integer> parentIds = this.getAllLocationIds(name1);
        Integer parentId = parentIds.get(0);
        block0: while (st.hasMoreElements()) {
            name1 = (String)st.nextElement();
            List<Integer> childrenIds = this.locationTable.get(parentId).getChildren();
            for (Integer childId : childrenIds) {
                if (!this.locationTable.get(childId).getName().equals(name1)) continue;
                parentId = childId;
                continue block0;
            }
        }
        return parentId;
    }

    String createLabel(LocationEntry locationEntry) {
        String label = locationEntry.getName();
        LocationEntry entry1 = locationEntry;
        LocationEntry.Type type = entry1.getType();
        while (type == LocationEntry.Type.PROVINCE || type == LocationEntry.Type.REGION || type == LocationEntry.Type.CITY || type == LocationEntry.Type.GROUP) {
            Integer parentId = entry1.getParents().get(0);
            LocationEntry parentEntry = this.locationTable.get(parentId);
            type = parentEntry.getType();
            if (type != LocationEntry.Type.GROUP) {
                label = parentEntry.getName() + "." + label;
            }
            entry1 = parentEntry;
        }
        return label;
    }

    public Map<Integer, LocationEntry> getLocationTable() {
        return this.locationTable;
    }

    public boolean equalsNormalized(String name, String name2) {
        return this.normalize(name).equals(this.normalize(name2));
    }
}

