/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapIndexer {
    private static List<MapIndexer> mapList = null;
    private JSONObject geoJson = null;
    private Map<Integer, String> locations = null;

    private MapIndexer(String jsonFileName, String locationsFileName) {
        try {
            this.loadLocations(locationsFileName);
            this.loadJson(jsonFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<MapIndexer> getNonMapIndexers() {
        if (mapList == null) {
            mapList = new ArrayList<MapIndexer>();
            String mapsDir = "/mapFiles/";
            mapList.add(new MapIndexer(mapsDir + "stadium_json.txt", mapsDir + "stadium_locations.txt"));
        }
        return mapList;
    }

    public void loadJson(String jsonFileName) throws IOException {
        InputStream inputStream = MapIndexer.class.getResourceAsStream(jsonFileName);
        this.geoJson = JSONObject.parse((InputStream)inputStream);
    }

    public void loadLocations(String locationsFileName) throws IOException {
        String line;
        this.locations = new HashMap<Integer, String>();
        InputStream inputStream = MapIndexer.class.getResourceAsStream(locationsFileName);
        BufferedReader locationsReader = new BufferedReader(new InputStreamReader(inputStream));
        int locPos = 0;
        while ((line = locationsReader.readLine()) != null) {
            this.locations.put(locPos++, line.trim());
        }
        locationsReader.close();
        inputStream.close();
    }

    public Map<Integer, String> getLocations() {
        return this.locations;
    }

    public JSONObject getGeoJSON() {
        return this.geoJson;
    }
}

