/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import com.ibm.athena.smartermaps.model.AddressIndex;
import com.ibm.athena.smartermaps.model.PrefixTreeNode;
import java.util.Set;

public class PrefixTree {
    public PrefixTreeNode root = new PrefixTreeNode('!', -1);

    PrefixTree() {
    }

    protected void insert(AddressIndex address) {
        if (address == null || address.getName().isEmpty()) {
            return;
        }
        PrefixTreeNode current = this.root;
        String name = address.getName();
        for (int i = 0; i < name.length(); ++i) {
            PrefixTreeNode next = current.findNext(name.charAt(i));
            if (next != null) {
                current = next;
            } else {
                PrefixTreeNode node = new PrefixTreeNode(name.charAt(i), current.prefixCount + 1);
                current.addChild(node);
                current = node;
            }
            if (i != name.length() - 1) continue;
            current.setEOW(true);
            current.addLocationID(address.getLocationID());
        }
    }

    public Set<Integer> getLocationIDs(String name) {
        PrefixTreeNode current = this.root;
        if (current != null) {
            for (int i = 0; i < name.length(); ++i) {
                PrefixTreeNode next = current.findNext(name.charAt(i));
                if (next == null) {
                    return null;
                }
                current = next;
            }
            if (current.isEOW()) {
                return current.getLocationIDs();
            }
            return null;
        }
        return null;
    }

    public String display() {
        StringBuilder sb = new StringBuilder();
        if (this.root.children != null) {
            int size = this.root.children.size();
            for (int i = 0; i < size; ++i) {
                sb.append(this.root.children.get(i).display()).append("\n");
            }
        }
        return sb.toString();
    }

    public PrefixTreeNode getRoot() {
        return this.root;
    }
}

