/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.model;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class PrefixTreeNode {
    char letter;
    int prefixCount = -1;
    boolean eow;
    Set<Integer> locationIDs = new HashSet<Integer>();
    LinkedList<PrefixTreeNode> children = null;

    PrefixTreeNode(char c, int count) {
        this.setLetter(c);
        this.setPrefixCount(count);
        this.children = new LinkedList();
    }

    PrefixTreeNode findNext(char c) {
        if (this.children != null) {
            for (PrefixTreeNode child : this.children) {
                if (!this.equalsIgnorecase(child.getLetter(), c)) continue;
                return child;
            }
        }
        return null;
    }

    boolean equalsIgnorecase(char c1, char c2) {
        if (c1 == c2) {
            return true;
        }
        return Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    void setLetter(char letter) {
        this.letter = letter;
    }

    void setPrefixCount(int prefixCount) {
        this.prefixCount = prefixCount;
    }

    void addChild(PrefixTreeNode node) {
        this.children.add(node);
    }

    void setEOW(boolean flag) {
        this.eow = flag;
    }

    void addLocationID(Integer id) {
        this.locationIDs.add(id);
    }

    public Set<Integer> getLocationIDs() {
        return this.locationIDs;
    }

    public int getPrefixCount() {
        return this.prefixCount;
    }

    public boolean isEOW() {
        return this.eow;
    }

    public char getLetter() {
        return this.letter;
    }

    public LinkedList<PrefixTreeNode> getChildren() {
        return this.children;
    }

    public String display() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.letter).append("(").append(this.getPrefixCount()).append(")");
        if (this.eow) {
            sb.append("\n ");
        }
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                sb.append("->").append(this.children.get(i).display());
            }
        }
        return sb.toString();
    }
}

