/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.util;

import com.ibm.athena.smartermaps.util.Coordinate;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;

public class GeoJSONCompressor {
    private static double maxRemovableArea = 0.0;
    private static final double removableAreaLimit = 0.1;
    private static final Comparator<Coordinate> comparator = new Comparator<Coordinate>(){

        @Override
        public int compare(Coordinate c1, Coordinate c2) {
            if (c1.getArea() < c2.getArea()) {
                return -1;
            }
            if (c1.getArea() > c2.getArea()) {
                return 1;
            }
            return 0;
        }
    };

    public static JSONObject compress(JSONObject geometryObj, double removableArea, double limit) {
        if ("MultiPolygon".equalsIgnoreCase((String)geometryObj.get((Object)"type")) || "Polygon".equalsIgnoreCase((String)geometryObj.get((Object)"type"))) {
            int size = 0;
            if (limit > 0.1) {
                limit = 0.1;
            }
            while (removableArea <= limit) {
                GeoJSONCompressor.setMaxRemovableArea(removableArea);
                GeoJSONCompressor.compress((JSONArray)geometryObj.get((Object)"coordinates"));
                removableArea *= 10.0;
                size = GeoJSONCompressor.checkQuantityOfCoorArray((JSONArray)geometryObj.get((Object)"coordinates"));
                if (size > 500) continue;
            }
        }
        GeoJSONCompressor.setMaxRemovableArea(0.0);
        return geometryObj;
    }

    private static int checkQuantityOfCoorArray(JSONArray coorArray) {
        int size = 0;
        for (int i = 0; i < coorArray.size(); ++i) {
            if (GeoJSONCompressor.isSmoothable((JSONArray)coorArray.get(i))) {
                size += ((JSONArray)coorArray.get(i)).size();
                continue;
            }
            size += GeoJSONCompressor.checkQuantityOfCoorArray((JSONArray)coorArray.get(i));
        }
        return size;
    }

    public static JSONObject compress(JSONObject geometryObj) {
        return GeoJSONCompressor.compress(geometryObj, 0.0, 0.0);
    }

    private static JSONArray compress(JSONArray coorArray) {
        if (GeoJSONCompressor.isSmoothable(coorArray)) {
            return GeoJSONCompressor.smooth(coorArray);
        }
        for (int i = 0; i < coorArray.size(); ++i) {
            coorArray.set(i, (Object)GeoJSONCompressor.compress((JSONArray)coorArray.get(i)));
        }
        return coorArray;
    }

    private static boolean isSmoothable(JSONArray coorArray) {
        if (coorArray == null || coorArray.size() == 0) {
            throw new RuntimeException("Invalid geojson!");
        }
        Object coordinates = coorArray.get(0);
        if (coordinates == null || !(coordinates instanceof JSONArray)) {
            throw new RuntimeException("Incorrect geojson input!");
        }
        JSONArray tmp = (JSONArray)coordinates;
        return tmp.size() == 2 && tmp.get(0) instanceof Double && tmp.get(1) instanceof Double;
    }

    private static JSONArray smooth(JSONArray coorArray) {
        int i;
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        PriorityQueue<Coordinate> queue = new PriorityQueue<Coordinate>(coorArray.size(), comparator);
        ArrayList<Coordinate> originalCoorList = new ArrayList<Coordinate>(coorArray.size());
        for (i = 0; i < coorArray.size(); ++i) {
            JSONArray tmp = (JSONArray)coorArray.get(i);
            originalCoorList.add(new Coordinate((Double)tmp.get(0), (Double)tmp.get(1), i));
        }
        ((Coordinate)originalCoorList.get(0)).setNext((Coordinate)originalCoorList.get(1));
        int n = originalCoorList.size() - 1;
        for (i = 1; i < n; ++i) {
            ((Coordinate)originalCoorList.get(i)).setPrevious((Coordinate)originalCoorList.get(i - 1));
            ((Coordinate)originalCoorList.get(i)).setNext((Coordinate)originalCoorList.get(i + 1));
            ((Coordinate)originalCoorList.get(i)).setArea(((Coordinate)originalCoorList.get(i)).computeArea());
            queue.add((Coordinate)originalCoorList.get(i));
        }
        ((Coordinate)originalCoorList.get(originalCoorList.size() - 1)).setPrevious((Coordinate)originalCoorList.get(originalCoorList.size() - 2));
        while (!queue.isEmpty() && GeoJSONCompressor.isRemovable(queue.peek())) {
            Coordinate removeIt = queue.poll();
            toDelete.add(removeIt.getIndex());
            removeIt.getPrevious().setNext(removeIt.getNext());
            removeIt.getNext().setPrevious(removeIt.getPrevious());
            GeoJSONCompressor.update(removeIt.getPrevious(), queue);
            GeoJSONCompressor.update(removeIt.getNext(), queue);
        }
        JSONArray tmpArray = new JSONArray();
        tmpArray.addAll((Collection)coorArray);
        int n2 = toDelete.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            tmpArray.set(((Integer)toDelete.get(i2)).intValue(), null);
        }
        JSONArray compressed = new JSONArray();
        int n3 = tmpArray.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            if (tmpArray.get(i3) == null) continue;
            compressed.add(tmpArray.get(i3));
        }
        return compressed;
    }

    private static void update(Coordinate coor, PriorityQueue<Coordinate> queue) {
        if (coor.getPrevious() != null && coor.getNext() != null) {
            queue.remove(coor);
            coor.setArea(coor.computeArea());
            queue.add(coor);
        }
    }

    private static boolean isRemovable(Coordinate coor) {
        return coor.getArea() <= GeoJSONCompressor.getMaxRemovableArea();
    }

    public static double getMaxRemovableArea() {
        return maxRemovableArea;
    }

    public static void setMaxRemovableArea(double maxRemovableArea) {
        GeoJSONCompressor.maxRemovableArea = maxRemovableArea;
    }
}

