/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.util;

import com.ibm.athena.smartermaps.util.LocationTree;
import com.ibm.athena.smartermaps.util.SimpleErrorHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LocationParser {
    private static final String ENCODE_TYPE = "UTF8";
    private static final String INPUT_DELIMITER = ",";
    public static final int PARSE_FAIL = -1;
    private FileInputStream locationInputStream = null;
    private String delim = ",";
    private File workingDirectory;
    private List<String> invalidLines = null;
    private LocationTree.Region maxRegion = LocationTree.Region.COUNTRY;
    private LocationTree locationTree = new LocationTree();

    public LocationParser(String directoryPath) throws FileNotFoundException {
        this.workingDirectory = new File(directoryPath);
        if (!this.workingDirectory.isDirectory()) {
            throw new FileNotFoundException();
        }
    }

    public void setMaxRegion(LocationTree.Region region) {
        this.maxRegion = region;
    }

    public void setXMLStoreAlternateNames(boolean store) {
        this.locationTree.setStoreAlternateNames(store);
    }

    public void setNormalizeAlternateNames(boolean store) {
        this.locationTree.setNormalizeAlternateNames(store);
    }

    public void setStoreOriginalLocation(boolean store) {
        this.locationTree.setStoreOriginalLocation(store);
    }

    public void setStoreOriginalAncestry(boolean store) {
        this.locationTree.setStoreOriginalAncestry(store);
    }

    public void clear() {
        this.locationTree.clear();
        this.invalidLines.clear();
    }

    public void setInputDelimiter(String delim) {
        this.delim = delim;
    }

    public void setOutputDelimiter(String delim) {
        this.locationTree.setOutputDelimiter(delim);
    }

    public List<String> getInvalidLines() {
        return this.invalidLines;
    }

    private boolean openFiles(String locationFileName) {
        try {
            if (this.locationInputStream == null) {
                this.locationInputStream = new FileInputStream(new File(locationFileName));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not Found: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void closeFiles() {
        try {
            if (this.locationInputStream != null) {
                this.locationInputStream.close();
                this.locationInputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int xmlParse(String xmlFileName, String diffFileName) {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        BufferedReader diffReader = null;
        int linesParsed = 0;
        try {
            diffReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.workingDirectory.getAbsolutePath() + "/" + diffFileName), ENCODE_TYPE));
            if (!this.loadDiff(diffReader)) {
                return -1;
            }
            diffReader.close();
        }
        catch (IOException e) {
            return -1;
        }
        try {
            builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(new File(this.workingDirectory.getAbsolutePath() + "/" + xmlFileName));
            doc.getDocumentElement().normalize();
            Element rootElement = doc.getDocumentElement();
            Element componentElement = (Element)rootElement.getElementsByTagName("component").item(0);
            Element sectionElement = (Element)componentElement.getElementsByTagName("section").item(0);
            if (this.invalidLines == null) {
                this.invalidLines = new ArrayList<String>();
            }
            NodeList stringNodeList = sectionElement.getElementsByTagName("string");
            int lowest = LocationTree.Region.CITY.getLevel();
            for (int pos = 0; pos < stringNodeList.getLength(); ++pos) {
                Node curNode = stringNodeList.item(pos);
                Element curElement = (Element)curNode;
                String line = curElement.getAttribute("name");
                String location = curElement.getTextContent();
                LocationTree.Region region = this.storeLine(line = line + "|" + location);
                if (region == null) {
                    // empty if block
                }
                if (region == null) continue;
                if (region.getLevel() < lowest) {
                    lowest = region.getLevel();
                }
                ++linesParsed;
            }
        }
        catch (ParserConfigurationException e1) {
            System.err.println("Unable to construct document builder");
            return -1;
        }
        catch (SAXException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
        return linesParsed;
    }

    public int parse(String locationFileName) {
        int linesParsed = 0;
        if (!this.openFiles(this.workingDirectory.getAbsolutePath() + "/" + locationFileName)) {
            return -1;
        }
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(new InputStreamReader((InputStream)this.locationInputStream, ENCODE_TYPE));
            if (this.invalidLines == null) {
                this.invalidLines = new ArrayList<String>();
            }
            int lowest = LocationTree.Region.CITY.getLevel();
            while ((line = lineReader.readLine()) != null) {
                LocationTree.Region region = this.storeLine(line);
                if (region == null) continue;
                if (region.getLevel() < lowest) {
                    lowest = region.getLevel();
                }
                ++linesParsed;
            }
        }
        catch (IOException e) {
            System.err.println("Error: Failed to read input file");
            return -1;
        }
        return linesParsed;
    }

    private boolean loadDiff(BufferedReader lineReader) throws IOException {
        String line;
        while ((line = lineReader.readLine()) != null) {
            String[] regions = line.split(this.delim);
            if (this.locationTree.addDiffNode(regions, this.maxRegion) != null) continue;
            return false;
        }
        return true;
    }

    private LocationTree.Region storeLine(String line) {
        String[] regions = line.split(this.delim);
        LocationTree.Region region = this.locationTree.addLocationNode(regions, this.maxRegion);
        if (region == null) {
            this.invalidLines.add(line);
        }
        return region;
    }

    public boolean writeLocations(String writeFileName) {
        BufferedWriter outputWriter = null;
        try {
            outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.workingDirectory + "/" + writeFileName), ENCODE_TYPE));
            this.locationTree.writeLocations(outputWriter);
            outputWriter.flush();
            outputWriter.close();
        }
        catch (IOException e) {
            return false;
        }
        this.closeFiles();
        return true;
    }

    public boolean writeXMLLocations(String writeFileName, String diffFileName) {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        BufferedWriter diffWriter = null;
        try {
            builder = builderFactory.newDocumentBuilder();
            diffWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.workingDirectory + "/" + diffFileName), ENCODE_TYPE));
        }
        catch (ParserConfigurationException e1) {
            System.err.println("Unable to construct document builder");
            return false;
        }
        catch (IOException e) {
            return false;
        }
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("stringTable");
        rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttribute("localization", "Content Locale");
        rootElement.setAttribute("usage", "CCLMessageFile.xsd");
        doc.appendChild(rootElement);
        Element componentElement = doc.createElement("component");
        componentElement.setAttribute("name", "MAP");
        componentElement.setAttribute("usage", "MapData strings");
        rootElement.appendChild(componentElement);
        Element sectionElement = doc.createElement("section");
        sectionElement.setAttribute("name", "FEA");
        sectionElement.setAttribute("usage", "Feature names");
        sectionElement.setAttribute("type", "UI");
        componentElement.appendChild(sectionElement);
        try {
            this.locationTree.writeLocations(sectionElement, doc, diffWriter);
            diffWriter.flush();
            diffWriter.close();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(this.workingDirectory + "/" + writeFileName));
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean validateXML(String inputFileName, String xmlSchemaFileName, String schemaOutputFileName) {
        String jaxpSchemaLanguage = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        String w3cXmlSchema = "http://www.w3.org/2001/XMLSchema";
        String jaxpSchemaSource = "http://java.sun.com/xml/jaxp/properties/schemaSource";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        boolean xsdValidate = true;
        dbf.setValidating(xsdValidate);
        if (xsdValidate) {
            try {
                dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new File(xmlSchemaFileName));
                DocumentBuilder builder = dbf.newDocumentBuilder();
                SimpleErrorHandler handler = new SimpleErrorHandler(schemaOutputFileName);
                builder.setErrorHandler(handler);
                builder.parse(inputFileName);
                if (handler.hasErrors()) {
                    return false;
                }
            }
            catch (ParserConfigurationException e) {
                return false;
            }
            catch (SAXException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }
}

