/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.util;

import java.io.IOException;
import java.io.Writer;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocationTree {
    private static Map<String, String> characterMap = new HashMap<String, String>();
    private static HashSet<Character.UnicodeBlock> blockList;
    public static final String XML_DELIMITER = "__";
    public static final String ALT_DELIMITER = ";;";
    private String outDelim = "__";
    private boolean storeOriginalLocation = false;
    private boolean normalizeAlternateNames = true;
    private boolean storeOriginalAncestry = false;
    private boolean storeAlternateNames = false;
    private LocationNode worldNode;
    private LocationNode diffNode;

    public LocationTree() {
        try {
            this.worldNode = new LocationNode("World", Region.WORLD);
        }
        catch (InvalidLocationException invalidLocationException) {
            // empty catch block
        }
    }

    public static String normalize(String inputName) {
        String name = Normalizer.normalize(inputName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        for (String key : characterMap.keySet()) {
            name = name.replaceAll(key, characterMap.get(key));
        }
        return name;
    }

    public static String denormalize(String inLine) {
        String line = inLine;
        for (String key : characterMap.keySet()) {
            line = line.replaceAll(characterMap.get(key), key);
        }
        return line;
    }

    private static boolean isSupportedUnicode(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (blockList.contains(Character.UnicodeBlock.of(name.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public void setOutputDelimiter(String delim) {
        this.outDelim = delim;
    }

    public String getOutputDelimiter() {
        return this.outDelim;
    }

    public void setStoreOriginalAncestry(boolean store) {
        this.storeOriginalAncestry = store;
    }

    public void setNormalizeAlternateNames(boolean store) {
        this.normalizeAlternateNames = store;
    }

    public void setStoreOriginalLocation(boolean store) {
        this.storeOriginalLocation = store;
    }

    public void setStoreAlternateNames(boolean store) {
        this.storeAlternateNames = store;
    }

    public static Set<Character.UnicodeBlock> getBlockList() {
        return (HashSet)blockList.clone();
    }

    public void writeLocations(Writer writer) throws IOException {
        this.worldNode.writeLocations(writer);
    }

    public void writeLocations(Element curElement, Document doc, Writer diffWriter) throws IOException {
        this.worldNode.writeLocations(curElement, doc, diffWriter);
    }

    public Region addDiffNode(String[] regions, Region maxRegion) {
        if (this.diffNode == null) {
            try {
                this.diffNode = new LocationNode("World", Region.WORLD);
            }
            catch (InvalidLocationException invalidLocationException) {
                // empty catch block
            }
        }
        return this.addLocationNode(regions, maxRegion, this.diffNode, null);
    }

    public Region addLocationNode(String[] regions, Region maxRegion) {
        return this.addLocationNode(regions, maxRegion, this.worldNode, this.diffNode);
    }

    private Region addLocationNode(String[] regions, Region maxLevel, LocationNode node, LocationNode diffNode) {
        int max = regions.length < maxLevel.getLevel() ? regions.length : maxLevel.getLevel();
        LinkedList<LocationNode> nodeList = new LinkedList<LocationNode>();
        Region level = Region.CONTINENT;
        for (int i = 0; i < max; ++i) {
            String region = regions[i];
            if (level == null) {
                System.out.println("Input line iterates past CITY region");
                return null;
            }
            try {
                if (diffNode != null && diffNode.hasChildren() && level == Region.SUBREGION) {
                    LocationNode country = new LocationNode(LocationTree.denormalize(region), level);
                    LocationNode cont = diffNode.getNext((LocationNode)nodeList.get(Region.CONTINENT.getLevel() - 1));
                    boolean matched = false;
                    if (cont == null) {
                        return null;
                    }
                    for (LocationNode subreg : cont.children) {
                        if (subreg.getNext(country) == null) continue;
                        nodeList.add(new LocationNode(LocationTree.denormalize(subreg.getLocation()), subreg.getLevel()));
                        level = level.getNext();
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return null;
                    }
                }
                nodeList.add(new LocationNode(LocationTree.denormalize(region), level));
            }
            catch (InvalidLocationException e) {
                System.out.println("SMLocation contains unsupported characters: " + LocationTree.denormalize(region));
                return null;
            }
            level = level.getNext();
        }
        if (!this.addLocationNode(node, nodeList.iterator())) {
            return null;
        }
        return ((LocationNode)nodeList.get(nodeList.size() - 1)).getLevel();
    }

    private boolean addLocationNode(LocationNode curNode, Iterator<LocationNode> nodeItr) {
        boolean result = false;
        if (!nodeItr.hasNext()) {
            return result;
        }
        LocationNode node = nodeItr.next();
        LocationNode temp = curNode.getNext(node);
        if (temp != null) {
            result = this.addLocationNode(temp, nodeItr);
        } else {
            curNode.addChildNode(node);
            result = true;
            if (nodeItr.hasNext()) {
                result = this.addLocationNode(node, nodeItr);
            }
        }
        return result;
    }

    public void clear() {
        if (this.worldNode.hasChildren()) {
            this.worldNode.clearLocationNodes(this.worldNode);
        }
        if (this.diffNode != null && this.diffNode.hasChildren()) {
            this.diffNode.clearLocationNodes(this.diffNode);
        }
    }

    static {
        characterMap.put("\u00c5\u201c", "0xoe");
        characterMap.put("\u00c3\ufffd", "\u00c4\ufffd");
        characterMap.put("\u00c4\ufffd", "0xD");
        characterMap.put("\u00c3\u00b0", "0x0o");
        characterMap.put("\u00c3\u00b8", "0x1o");
        characterMap.put("\u00c3\u02dc", "0xO");
        characterMap.put("\u00c3\u00a6", "0xae");
        characterMap.put("\u00c3\u00be", "0xP");
        characterMap.put("\u00c9\u2122", "0xe");
        characterMap.put("\u00c9\u2122", "0xe");
        characterMap.put("\u00c5\u0178", "0xs");
        characterMap.put("\u00c5\u017e", "0xS");
        characterMap.put("\u00c3\u00a7", "0xc");
        characterMap.put("\u00c4\u00a6", "0xH");
        characterMap.put("\u00c4\u00a7", "0xh");
        characterMap.put("\u00c5\ufffd", "0xL");
        characterMap.put("\u00c4\u00b1", "0xi");
        characterMap.put("`", "0x01");
        characterMap.put("'", "0x02");
        characterMap.put("\\.", "0x03");
        characterMap.put("-", "0x04");
        characterMap.put("/", "0x05");
        characterMap.put("\u00e2\u20ac\u201c", "0x06");
        characterMap.put("\\?", "0x07");
        characterMap.put(" ", "_");
        blockList = new HashSet();
        blockList.add(Character.UnicodeBlock.GENERAL_PUNCTUATION);
        blockList.add(Character.UnicodeBlock.BASIC_LATIN);
        blockList.add(Character.UnicodeBlock.LATIN_1_SUPPLEMENT);
        blockList.add(Character.UnicodeBlock.LATIN_EXTENDED_A);
    }

    public static class InvalidLocationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidLocationException(String msg) {
            super(msg);
        }
    }

    private class LocationNode
    implements Comparable<LocationNode> {
        private Set<LocationNode> children = null;
        private String location = null;
        private String originalLocation = null;
        private String[] alternateNames = null;
        private LocationNode parent = null;
        private Region level = Region.WORLD;

        public LocationNode(String location, Region level) throws InvalidLocationException {
            if (location == null || location.isEmpty()) {
                throw new InvalidLocationException("Empty SMLocation");
            }
            this.children = new TreeSet<LocationNode>();
            this.level = level;
            String name = location;
            ArrayList<String> altNamesList = new ArrayList<String>();
            int originalPos = name.indexOf(124);
            if (originalPos != -1) {
                String originalName = name.substring(originalPos + 1);
                if (!originalName.isEmpty()) {
                    if (originalName.contains(LocationTree.ALT_DELIMITER)) {
                        String[] xmlAltNames;
                        for (String altName : xmlAltNames = originalName.substring(originalName.indexOf(LocationTree.ALT_DELIMITER) + LocationTree.ALT_DELIMITER.length()).split(LocationTree.ALT_DELIMITER)) {
                            altNamesList.add(altName);
                        }
                        originalName = originalName.substring(0, originalName.indexOf(LocationTree.ALT_DELIMITER));
                    }
                    this.originalLocation = originalName;
                }
                if (originalPos == 0) {
                    throw new InvalidLocationException("Empty SMLocation");
                }
                name = name.substring(0, originalPos);
            }
            if (name.contains("[") && name.contains("]") || name.contains("{") && name.contains("}")) {
                name = name.replaceAll("[{\\[]", "(");
                name = name.replaceAll("[\\]}]", ")");
            }
            if (name.contains("(") && name.contains(")")) {
                String altSpace = name.substring(name.indexOf(40) + 1, name.indexOf(41));
                if (!altSpace.contains("alternate name")) {
                    name = name.substring(0, name.indexOf(40)) + name.substring(name.indexOf(41) + 1);
                    name = name.replaceAll("  ", " ");
                    name = name.trim();
                    if (LocationTree.isSupportedUnicode(altSpace)) {
                        altNamesList.add(LocationTree.this.normalizeAlternateNames ? LocationTree.normalize(altSpace) : altSpace);
                    }
                }
                if (name.contains("alternate name")) {
                    String altNamesLine = name.substring(name.indexOf(58) + 1, name.lastIndexOf(41) - 1);
                    name = name.substring(0, name.indexOf(40) - 1).trim();
                    String[] altNamesSplit = altNamesLine.split(";");
                    for (int i = 0; i < altNamesSplit.length; ++i) {
                        altNamesLine = altNamesSplit[i].trim();
                        if (altNamesList.contains(altNamesLine) || !LocationTree.isSupportedUnicode(altNamesLine)) continue;
                        altNamesList.add(LocationTree.this.normalizeAlternateNames ? LocationTree.normalize(altNamesLine) : altNamesLine);
                    }
                }
                this.alternateNames = altNamesList.toArray(new String[altNamesList.size()]);
            } else if (name.contains("(") || name.contains(")")) {
                System.out.println("Error: Invalid opening/closing brackets for location: " + location);
            }
            if (this.originalLocation == null || this.originalLocation.isEmpty()) {
                this.originalLocation = name;
            }
            if (!LocationTree.isSupportedUnicode(name = LocationTree.normalize(name))) {
                throw new InvalidLocationException("SMLocation contains invalid characters");
            }
            this.location = name;
        }

        public Region getLevel() {
            return this.level;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOriginalLocation() {
            return this.originalLocation;
        }

        public String[] getAlternateNames() {
            return this.alternateNames;
        }

        public LocationNode getNext(LocationNode newNode) {
            for (LocationNode child : this.children) {
                if (child.compareTo(newNode) != 0) continue;
                return child;
            }
            return null;
        }

        public void setParent(LocationNode parent) {
            this.parent = parent;
        }

        public void addChildNode(LocationNode newNode) {
            this.children.add(newNode);
            newNode.setParent(this);
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public String getAncestry() {
            return this.getAncestry(Region.CONTINENT, LocationTree.this.outDelim, false);
        }

        public String getAncestry(boolean isXmlOutput) {
            return this.getAncestry(Region.CONTINENT, LocationTree.this.outDelim, isXmlOutput);
        }

        public String getAncestry(Region level, String delim, boolean isXmlOutput) {
            if (level.getLevel() > Region.CITY.getLevel() || level.getLevel() < Region.WORLD.getLevel()) {
                System.out.println("Error: Invalid ancestry level");
                return "";
            }
            LocationNode nextParent = this.parent;
            Stack<String> nameStack = new Stack<String>();
            while (nextParent != null) {
                if (!(nextParent.level.getLevel() < level.getLevel() || isXmlOutput && nextParent.getLevel() == Region.SUBREGION)) {
                    nameStack.push(LocationTree.this.storeOriginalAncestry ? nextParent.originalLocation : nextParent.location);
                }
                nextParent = nextParent.parent;
            }
            StringBuilder out = new StringBuilder();
            while (!nameStack.isEmpty()) {
                out.append((String)nameStack.pop());
                if (nameStack.isEmpty()) continue;
                out.append(delim);
            }
            return out.toString();
        }

        @Override
        public int compareTo(LocationNode o) {
            return this.location.compareToIgnoreCase(o.location);
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocationNode)) {
                return false;
            }
            LocationNode loc = (LocationNode)o;
            return this.location.equalsIgnoreCase(loc.location);
        }

        public String toString() {
            String ancestry = this.getAncestry();
            if (!ancestry.isEmpty()) {
                ancestry = ancestry + LocationTree.this.outDelim;
            }
            return ancestry + (LocationTree.this.storeOriginalLocation ? this.originalLocation : this.location);
        }

        public void writeLocations(Writer writer) throws IOException {
            for (LocationNode child : this.children) {
                writer.write(child.toString() + "\n");
            }
            for (LocationNode child : this.children) {
                child.writeLocations(writer);
            }
        }

        public void writeLocations(Element curElement, Document doc, Writer diffWriter) throws IOException {
            for (LocationNode child : this.children) {
                String outLocation = LocationTree.this.storeOriginalLocation ? child.getOriginalLocation() : child.getLocation();
                Element locationElement = doc.createElement("string");
                String ancestry = child.getAncestry(true);
                locationElement.setAttribute("name", ancestry + (ancestry.isEmpty() ? "" : LocationTree.this.outDelim) + child.getLocation());
                curElement.appendChild(locationElement);
                String[] names = child.getAlternateNames();
                StringBuilder nameAppend = new StringBuilder(outLocation);
                if (LocationTree.this.storeAlternateNames && names != null) {
                    for (String name : child.getAlternateNames()) {
                        nameAppend.append(LocationTree.ALT_DELIMITER).append(name);
                    }
                }
                locationElement.appendChild(doc.createTextNode(nameAppend.toString()));
                if (child.getLevel() != Region.COUNTRY) continue;
                diffWriter.write(child.toString() + "\n");
            }
            for (LocationNode child : this.children) {
                child.writeLocations(curElement, doc, diffWriter);
            }
        }

        public void clearLocationNodes(LocationNode curNode) {
            for (LocationNode child : curNode.children) {
                this.clearLocationNodes(child);
                child.children.clear();
            }
            curNode.children.clear();
        }
    }

    public static enum Region {
        WORLD(0),
        CONTINENT(1),
        SUBREGION(2),
        COUNTRY(3),
        PROVINCE(4),
        CITY(5);

        private int level;
        private static final Map<Integer, Region> REGIONMAP;

        private Region(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public Region getNext() {
            if (this.level == CITY.getLevel()) {
                return null;
            }
            return REGIONMAP.get(this.level + 1);
        }

        static {
            REGIONMAP = new HashMap<Integer, Region>();
            for (Region region : EnumSet.allOf(Region.class)) {
                REGIONMAP.put(region.getLevel(), region);
            }
        }
    }
}

