/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps.util;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleErrorHandler
implements ErrorHandler {
    private BufferedWriter outputWriter;
    private boolean hasErrors = false;

    public SimpleErrorHandler(String outputFileName) throws FileNotFoundException, UnsupportedEncodingException {
        this.outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), "UTF8"));
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.hasErrors = true;
        try {
            this.outputWriter.write(e.getLineNumber() + " error: " + e.getMessage() + "\n");
            this.outputWriter.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.hasErrors = true;
        try {
            this.outputWriter.write(e.getLineNumber() + " fatal error: " + e.getMessage() + "\n");
            this.outputWriter.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.hasErrors = true;
        try {
            this.outputWriter.write(e.getLineNumber() + " warning: " + e.getMessage() + "\n");
            this.outputWriter.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

