/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.upgrade.analytics;

import com.ibm.bi.platform.moser.common.generated.analytics.Analytics;
import com.ibm.bi.platform.moser.common.generated.analytics.AnalyticsContent;
import com.ibm.bi.platform.moser.common.generated.analytics.AnalyticsFeature;
import com.ibm.bi.platform.moser.common.generated.analytics.FeatureProperty;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.ca.upgrade.analytics.ModuleAnalyticsMigrationException;
import com.ibm.smarts.ca.upgrade.analytics.migrator.ConceptMigrator;
import com.ibm.smarts.ca.upgrade.analytics.migrator.CoveredTextMigrator;
import com.ibm.smarts.ca.upgrade.analytics.migrator.DefaultAggregateTypeMigrator;
import com.ibm.smarts.ca.upgrade.analytics.migrator.LemmaMigrator;
import com.ibm.smarts.ca.upgrade.analytics.migrator.StatisticsMigrator;
import com.ibm.smarts.ca.upgrade.analytics.migrator.UsageMigrator;
import com.ibm.smarts.model.common.content.ModuleCodec;
import com.ibm.smarts.model.common.util.ModuleDataTypeUtil;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.schema.AnalysisModeType;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.DatasetType;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.AnalysisPhaseUtil;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.schema.util.SmartsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleAnalyticsMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleAnalyticsMigrator.class);
    private static final String DEFAULT_NAME = "defaultName";
    private static final String TAGS = "tags";
    private static final String SMARTS_DATA = "smartsData";
    private static final String SEMANTIC_INFO = "-SemanticInfo";
    public static final int MAX_TAG_LENGTH = 256;
    public static final int MAX_UNICODE_TAG_LENGTH = 85;

    private ModuleAnalyticsMigrator() {
    }

    public static List<Map<String, Object>> migrate(String moduleStoreId, String moduleDefinition, String analyticsDefinition) throws ModuleAnalyticsMigrationException {
        long start_time = System.nanoTime();
        LOGGER.debug("ModuleAnalyticsMigrator.migrate called.");
        if (ModuleAnalyticsMigrator.migrationEnabled() && moduleStoreId != null && moduleDefinition != null && analyticsDefinition != null && moduleStoreId.trim().length() > 0 && moduleDefinition.trim().length() > 0 && analyticsDefinition.trim().length() > 0) {
            try {
                LOGGER.info("Upgrading a module with id " + moduleStoreId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Module String:" + moduleDefinition);
                    LOGGER.debug("Analytics String:" + analyticsDefinition);
                }
                Module module = (Module)JAXBHelper.unmarshalFromXML(Module.class, (InputStream)ModuleCodec.getDecodedInputStream((String)moduleDefinition));
                if (LOGGER.isTraceEnabled()) {
                    try {
                        LOGGER.trace("Module JSON: " + JAXBHelper.marshalToJSON((Object)module, (boolean)false));
                    }
                    catch (Exception e) {
                        LOGGER.trace("Failed to get JSON for Module");
                    }
                }
                Analytics analyticsModule = (Analytics)JAXBHelper.unmarshalFromXML(Analytics.class, (InputStream)ModuleCodec.getDecodedInputStream((String)analyticsDefinition));
                if (LOGGER.isTraceEnabled()) {
                    try {
                        LOGGER.trace("Analytics JSON: " + JAXBHelper.marshalToJSON((Object)analyticsModule, (boolean)false));
                    }
                    catch (Exception e) {
                        LOGGER.trace("Failed to get JSON for Analytics");
                    }
                }
                List<Map<String, Object>> parts = ModuleAnalyticsMigrator.createParts(moduleStoreId, module, analyticsModule);
                LOGGER.info("Successfully upgraded module " + moduleStoreId);
                long end_time = System.nanoTime();
                LOGGER.debug("Migration time for " + moduleStoreId + " was " + (double)(end_time - start_time) / 1000000.0 + " ms");
                return parts;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Unsupported encoding in modules connected to id: " + moduleStoreId + ". No smarts module will be created.");
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("No smarts module will be created.", (Throwable)e);
                }
            }
            catch (JAXBException e) {
                LOGGER.error("Unable to unmarshal modules connected to id: " + moduleStoreId + ". No smarts module will be created.");
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("No smarts module will be created.", (Throwable)e);
                }
            }
            catch (IOException e) {
                LOGGER.error("IOException: Possibly the smarts module part could not be marshalled to JSON", (Throwable)e);
                throw new ModuleAnalyticsMigrationException("IOException: Possibly the smarts module part could not be marshalled to JSON", e);
            }
            catch (Exception e) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw new ModuleAnalyticsMigrationException("Exception : ", e);
            }
        }
        LOGGER.warn("Returning empty collection during upgrade.  Either migration disabled or CM called us with a null parameter.");
        return Collections.emptyList();
    }

    static List<Map<String, Object>> createParts(String moduleStoreId, Module module, Analytics analyticsModule) throws ModuleAnalyticsMigrationException, IOException {
        ArrayList<Map<String, Object>> parts = new ArrayList<Map<String, Object>>();
        SmartsModule sm = ModuleAnalyticsMigrator.createBasicSmartsModule(moduleStoreId, analyticsModule);
        for (AnalyticsContent ac : analyticsModule.getAnalyticsContents()) {
            DatasetInfo ds = ModuleAnalyticsMigrator.createDataSet(ac, module);
            String[] tags = ModuleAnalyticsMigrator.generateDataSetTags(ds).toArray(new String[0]);
            sm.getDatasets().add(ds);
            HashMap<String, Object> part = new HashMap<String, Object>();
            parts.add(part);
            part.put(DEFAULT_NAME, ac.getIdentifier() + SEMANTIC_INFO);
            part.put(TAGS, tags);
            part.put(SMARTS_DATA, JAXBHelper.marshalToJSON((Object)SmartsUtil.smartsModulePartFrom((SmartsModule)sm, (DatasetInfo)ds)));
        }
        return parts;
    }

    private static List<String> generateDataSetTags(DatasetInfo info) {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(ModuleAnalyticsMigrator.truncateTag(info.getId()));
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)info).forEach(columnInfo -> tags.add(ModuleAnalyticsMigrator.truncateTag(columnInfo.getIdForExpression())));
        return tags;
    }

    public static String truncateTag(String tag) {
        return Charset.forName("US-ASCII").newEncoder().canEncode(tag) ? StringUtils.left((String)tag, (int)256).trim() : StringUtils.left((String)tag, (int)85).trim();
    }

    private static SmartsModule createBasicSmartsModule(String id, Analytics analyticsModule) {
        SmartsModule sm = SmartsModuleFactory.createSmartsModule();
        sm.setId(id);
        if (analyticsModule.getLabel() != null) {
            sm.setName(analyticsModule.getLabel());
        } else if (analyticsModule.getIdentifier() != null) {
            sm.setName(analyticsModule.getIdentifier());
        } else {
            sm.setName(id);
        }
        if (analyticsModule.getDescription() != null) {
            sm.setDescription(analyticsModule.getDescription());
        }
        if (analyticsModule.getComment() != null) {
            sm.setComment(analyticsModule.getComment());
        }
        sm.setAnalysisMode(AnalysisModeType.SHALLOW);
        XMLGregorianCalendar cal = null;
        try {
            cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (Exception e) {
            LOGGER.error("Exception while setting smarts module creation time: " + e);
        }
        sm.setModuleCreationTime(cal);
        sm.setModuleLastModifiedTime(cal);
        sm.setType("unknown");
        sm.setLocale("en");
        return sm;
    }

    private static DatasetInfo createDataSet(AnalyticsContent ac, Module module) throws ModuleAnalyticsMigrationException {
        DatasetInfo ds = new DatasetInfo();
        TextInfo label = ModuleAnalyticsMigrator.createTextInfo(ac.getLabel(), ac.getProperties());
        ds.setLabel(label);
        ds.getAnalysisPhases().add(AnalysisPhaseUtil.createAnalyticsMigrationAnalysisPhase((AnalysisStateType)AnalysisStateType.DONE));
        ds.setId(ac.getIdentifier());
        ds.setName(ac.getLabel());
        ds.setType(DatasetType.DATASETS);
        QuerySubject qs = null;
        for (QuerySubject q : module.getQuerySubject()) {
            if (!ac.getIdentifier().equals(q.getIdentifier())) continue;
            qs = q;
            break;
        }
        HashMap<String, QueryItem> queryItems = new HashMap<String, QueryItem>();
        if (qs != null) {
            for (QueryItem qi : QuerySubjectUtil.getVisiableQueryItems(qs)) {
                queryItems.put(qi.getIdentifier(), qi);
            }
        }
        for (AnalyticsFeature af : ac.getAnalyticsFeatures()) {
            String id = af.getIdentifier();
            if (id == null) {
                String name = af.getLabel();
                for (Map.Entry entry : queryItems.entrySet()) {
                    String curLabel = ((QueryItem)entry.getValue()).getLabel();
                    if (curLabel == null) {
                        LOGGER.warn("Label not set for feature inside: " + ds.getName());
                        continue;
                    }
                    if (!curLabel.equals(name)) continue;
                    id = ((QueryItem)entry.getValue()).getIdentifier();
                    break;
                }
            }
            if (id == null) {
                LOGGER.warn("Id not set for feature inside: " + ds.getName());
                continue;
            }
            QueryItem qi = (QueryItem)queryItems.get(id);
            ColumnInfo columnInfo = ModuleAnalyticsMigrator.createColumn(af, qi, ac.getIdentifier() + "." + id);
            SmartsModuleUtil.addColumn((DatasetInfo)ds, (ColumnInfo)columnInfo);
        }
        return ds;
    }

    private static ColumnInfo createColumn(AnalyticsFeature af, QueryItem qi, String expression) throws ModuleAnalyticsMigrationException {
        ColumnInfo c = new ColumnInfo();
        List fp = af.getFeatureProperties();
        DataType dataType = null;
        for (FeatureProperty p : fp) {
            String name = p.getName();
            if (name == null || name.compareTo("DataType") != 0) continue;
            dataType = ModuleDataTypeUtil.createDataType((String)p.getValue());
        }
        if (dataType == null && qi != null) {
            dataType = ModuleDataTypeUtil.createDataType((String)qi.getDatatype());
        }
        if (dataType != null) {
            c.setDataType(dataType);
        }
        c.setIdForExpression(expression);
        c.setExpression(expression);
        c.setDescription(af.getDescription());
        c.setComment(af.getComment());
        String id = af.getIdentifier();
        if (id == null) {
            LOGGER.warn("Column has null identifier in the AnalyticsModule, trying the query item identifier.");
            if (qi != null) {
                id = qi.getIdentifier();
            } else {
                LOGGER.warn("Cannot find id for column either in the analytics module or the module, trying the label");
                id = af.getLabel();
                if (id == null) {
                    throw new ModuleAnalyticsMigrationException("Cannot find an id for a column.");
                }
            }
        }
        c.setId(id);
        String label = qi != null ? qi.getLabel() : af.getLabel();
        TextInfo columnInfoLabel = ModuleAnalyticsMigrator.createTextInfo(label, fp);
        c.setLabel(columnInfoLabel);
        if (label == null) {
            LOGGER.warn("Label is null for the column: " + id);
            label = id;
        }
        c.setName(label);
        SemanticInfo semanticInfo = ModuleAnalyticsMigrator.createSemanticInfo(fp, c);
        c.setSemanticInfo(semanticInfo);
        ModuleAnalyticsMigrator.addStatistics(c, fp);
        return c;
    }

    private static TextInfo createTextInfo(String phraseText, List<FeatureProperty> properties) {
        TextInfo textInfo = new TextInfo();
        PhraseInfo phrase = new PhraseInfo();
        phrase.setText(phraseText);
        textInfo.getPhrases().add(phrase);
        List tokens = phrase.getTokens();
        properties.forEach(p -> {
            String propertyName = p.getName();
            if ("CoveredText".equals(propertyName)) {
                CoveredTextMigrator migrator = new CoveredTextMigrator();
                migrator.migrate((FeatureProperty)p, tokens);
            } else if ("Lemma".equals(propertyName)) {
                LemmaMigrator migrator = new LemmaMigrator();
                migrator.migrate((FeatureProperty)p, tokens);
            }
        });
        textInfo.getPhrases().forEach(p -> p.getTokens().forEach(token -> {
            if (token.getLemma() == null) {
                String l = token.getText();
                LOGGER.warn("Lemma for token not provided setting to " + l);
                token.setLemma(l);
            }
        }));
        return textInfo;
    }

    static SemanticInfo createSemanticInfo(List<FeatureProperty> properties, ColumnInfo c) {
        SemanticInfo semanticInfo = new SemanticInfo();
        properties.forEach(p -> {
            String propertyName = p.getName();
            if ("Concept".equals(propertyName)) {
                ConceptMigrator migrator = new ConceptMigrator();
                migrator.migrate((FeatureProperty)p, semanticInfo);
            } else if ("Usage".equals(propertyName)) {
                UsageMigrator migrator = new UsageMigrator();
                migrator.migrate((FeatureProperty)p, semanticInfo.getConcepts());
                String usage = p.getValue();
                if (usage == null) {
                    if (c != null) {
                        LOGGER.error("Usage value is null for " + c.getExpression());
                    } else {
                        LOGGER.error("Usage value is null");
                    }
                } else {
                    UsageType u = UsageType.AUTOMATIC;
                    if (usage.compareTo("attribute") == 0) {
                        u = UsageType.ATTRIBUTE;
                    } else if (usage.compareTo("fact") == 0) {
                        u = UsageType.FACT;
                    } else if (usage.compareTo("identifier") == 0) {
                        u = UsageType.IDENTIFIER;
                    }
                    semanticInfo.setUsage(u);
                    c.setUsage(u);
                }
            } else if ("DefaultAggregateType".equals(propertyName)) {
                DefaultAggregateTypeMigrator migrator = new DefaultAggregateTypeMigrator();
                migrator.migrate((FeatureProperty)p, semanticInfo);
                c.setDefaultAggregation(semanticInfo.getDefaultAggregation());
            }
        });
        return semanticInfo;
    }

    private static void addStatistics(ColumnInfo columnInfo, List<FeatureProperty> properties) {
        properties.forEach(p -> {
            String propertyName = p.getName();
            if ("Statistics".equals(propertyName)) {
                StatisticsMigrator migrator = new StatisticsMigrator();
                migrator.migrate((FeatureProperty)p, columnInfo);
            }
        });
    }

    private static boolean migrationEnabled() {
        Properties prop = new Properties();
        try {
            prop.load(ModuleAnalyticsMigrator.class.getClassLoader().getResourceAsStream("smartsModuleMigration.properties"));
            LOGGER.debug("Migration enabled via properties file: " + prop.getProperty("migrationEnabled"));
            return prop.getProperty("migrationEnabled").compareTo("false") != 0;
        }
        catch (IOException e) {
            LOGGER.error("Exception while trying to read properties file: " + e);
            return false;
        }
    }
}

