/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.upgrade.analytics.migrator;

import com.ibm.bi.platform.moser.common.generated.analytics.FeatureProperty;
import com.ibm.smarts.ca.upgrade.analytics.migrator.FeaturePropertyMigrator;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.SemanticInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ConceptMigrator
implements FeaturePropertyMigrator<SemanticInfo> {
    public static final float HIGH_CONFIDENCE = 1.0f;
    public static final float LOW_CONFIDENCE = 0.5f;
    private static final float[] CONFIDENCE = new float[]{1.0f, 0.5f};
    Map<String, String> byNameMap = this.populateNameMap();
    Map<String, String> SmdConceptMap = this.populateSmdConceptMap();

    private Map<String, String> populateSmdConceptMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Attribute", "Entity");
        map.put("Category", "Categorical");
        map.put("Metric", "Measure");
        map.put("Target", "Planned");
        map.put("PeriodOfTime", "Period");
        map.put("ChurnRate", "Measure");
        map.put("PaymentTerm", "Term");
        map.put("Person", "People");
        map.put("SalesOrg", "Organization");
        map.put("ProductGender", "Gender");
        map.put("MergeQuestion", "Categorical");
        map.put("RowCategory", "RowIdentifierType");
        map.put("TemperatureUnit", "UnitOfMeasure");
        return map;
    }

    Map<String, String> populateNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator entryIterator = ConceptsRegistry.instance().getEntryIterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            map.put(((Concept)entry.getValue()).getName(), (String)entry.getKey());
        }
        return map;
    }

    @Override
    public void migrate(FeatureProperty property, SemanticInfo target) {
        if (!"Concept".equals(property.getName())) {
            throw new IllegalArgumentException("unexpected property " + property.getName());
        }
        String[] curConcepts = null;
        if (property.getValue() != null) {
            curConcepts = property.getValue().split(",");
        }
        if (curConcepts != null) {
            List concepts = target.getConcepts();
            ArrayList<String> curConceptNameList = new ArrayList<String>(Arrays.asList(curConcepts));
            for (ConceptInfo conceptInfo : concepts) {
                curConceptNameList.add(ConceptsUtil.getConceptName((ConceptInfo)conceptInfo));
            }
            target.getConcepts().clear();
            List<String> newConceptIds = this.removeDirectRelations(curConceptNameList);
            for (int i = 0; i < newConceptIds.size(); ++i) {
                ConceptInfo conceptInfo = this.getConceptInfo(CONFIDENCE[Math.min(1, i)], newConceptIds.get(i));
                if (concepts.size() < i) {
                    concepts.add(conceptInfo);
                    continue;
                }
                concepts.add(i, conceptInfo);
            }
        }
    }

    String getConceptId(String conceptName) {
        if (this.SmdConceptMap.containsKey(conceptName)) {
            conceptName = this.SmdConceptMap.get(conceptName);
        }
        return this.byNameMap.get(conceptName);
    }

    ConceptInfo getConceptInfo(float confidence, String conceptId) {
        Concept concept = ConceptsRegistry.instance().getConcept(conceptId);
        return concept.toConceptInfo(confidence);
    }

    static boolean isAncestor(String candidateAncestralConceptId, String conceptId) {
        Concept curConcept = ConceptsRegistry.instance().getConcept(conceptId);
        Concept candidateAncestralConcept = ConceptsRegistry.instance().getConcept(candidateAncestralConceptId);
        Set ancestors = curConcept.getAncestors();
        return ancestors.contains(candidateAncestralConcept);
    }

    static boolean isDescendant(String candidateDescendantConceptId, String conceptId) {
        return ConceptMigrator.isAncestor(conceptId, candidateDescendantConceptId);
    }

    List<String> removeDirectRelations(List<String> concepts) {
        List distinctConcepts = concepts.stream().distinct().collect(Collectors.toList());
        ArrayList workingCopy = new ArrayList(distinctConcepts);
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < distinctConcepts.size(); ++i) {
            String curConceptName = (String)distinctConcepts.get(i);
            if (!workingCopy.contains(curConceptName)) continue;
            String conceptId = this.getConceptId(curConceptName);
            if (conceptId == null) {
                workingCopy.remove(curConceptName);
                break;
            }
            for (int j = i + 1; j < distinctConcepts.size(); ++j) {
                String curCompareConceptName = (String)distinctConcepts.get(j);
                if (!workingCopy.contains(curCompareConceptName)) continue;
                String conceptId2 = this.getConceptId(curCompareConceptName);
                if (conceptId2 == null || ConceptMigrator.isDescendant(conceptId, conceptId2) || conceptId.equals(conceptId2)) {
                    workingCopy.remove(curCompareConceptName);
                    continue;
                }
                if (!ConceptMigrator.isAncestor(conceptId, conceptId2)) continue;
                workingCopy.remove(curConceptName);
                break;
            }
            if (!workingCopy.contains(curConceptName)) continue;
            retList.add(conceptId);
        }
        return retList;
    }
}

