/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.upgrade.analytics.migrator;

import com.ibm.bi.platform.moser.common.generated.analytics.FeatureProperty;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.smarts.ca.upgrade.analytics.migrator.FeaturePropertyMigrator;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.SemanticInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregateTypeMigrator
implements FeaturePropertyMigrator<SemanticInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAggregateTypeMigrator.class);

    @Override
    public void migrate(FeatureProperty property, SemanticInfo target) {
        if (!"DefaultAggregateType".equals(property.getName())) {
            throw new IllegalArgumentException("unexpected property " + property.getName());
        }
        String defaultAggregateType = property.getValue();
        if (defaultAggregateType != null) {
            AggregationType aggregationType;
            RegularAggregateType regularType = RegularAggregateType.fromValue((String)defaultAggregateType);
            switch (regularType) {
                case AVERAGE: {
                    aggregationType = AggregationType.AVERAGE;
                    break;
                }
                case TOTAL: {
                    aggregationType = AggregationType.SUM;
                    break;
                }
                case COUNT: {
                    aggregationType = AggregationType.COUNT;
                    break;
                }
                case COUNT_DISTINCT: {
                    aggregationType = AggregationType.COUNT_DISTINCT;
                    break;
                }
                case NONE: {
                    aggregationType = AggregationType.NONE;
                    break;
                }
                default: {
                    try {
                        aggregationType = AggregationType.fromValue((String)defaultAggregateType);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("unrecognized DefaultAggregateType value " + defaultAggregateType, (Throwable)e);
                        aggregationType = AggregationType.NONE;
                    }
                }
            }
            target.setDefaultAggregation(aggregationType);
        }
    }
}

