/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.upgrade.analytics.migrator;

import com.ibm.bi.platform.moser.common.generated.analytics.FeatureProperty;
import com.ibm.smarts.ca.upgrade.analytics.migrator.FeaturePropertyMigrator;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.stats.StatisticsFactory;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.Statistic;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsMigrator
implements FeaturePropertyMigrator<ColumnInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsMigrator.class);
    public static final int COUNT_POSITION = 0;
    public static final int COUNT_DISTINCT_POSITION = 1;
    public static final int MAX_POSITION = 2;
    public static final int MIN_POSITION = 3;
    public static final String MISSING = "NA";

    @Override
    public void migrate(FeatureProperty property, ColumnInfo target) {
        if (!"Statistics".equals(property.getName())) {
            throw new IllegalArgumentException("unexpected property " + property.getName());
        }
        String[] statsValues = null;
        if (property.getValue() != null) {
            statsValues = property.getValue().split(",");
        }
        if (statsValues != null) {
            List targetStatistics = target.getStatistics();
            DataType dataType = target.getDataType();
            if (dataType == null) {
                dataType = DataTypes.getStringType((int)Integer.MAX_VALUE);
            }
            if (targetStatistics.isEmpty()) {
                this.migrateCount(statsValues, targetStatistics);
                this.migrateCountDistinct(statsValues, targetStatistics);
                this.migrateMax(dataType, statsValues, targetStatistics);
                this.migrateMin(dataType, statsValues, targetStatistics);
            }
        }
    }

    private void migrateCount(String[] statsValues, List<Statistic> targetStatistics) {
        String countValue;
        if (statsValues.length > 0 && !this.isMissing(countValue = statsValues[0])) {
            try {
                long count = Long.parseLong(countValue);
                targetStatistics.add(StatisticsFactory.createCount((long)count));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("value for count statistic is not a long: " + countValue, (Throwable)e);
            }
        }
    }

    private void migrateCountDistinct(String[] statsValues, List<Statistic> targetStatistics) {
        String countDistinctValue;
        if (statsValues.length > 1 && !this.isMissing(countDistinctValue = statsValues[1])) {
            try {
                long countDistinct = Long.parseLong(countDistinctValue);
                targetStatistics.add(StatisticsFactory.createDistinctCount((long)countDistinct));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("value for count distinct statistic is not a long: " + countDistinctValue, (Throwable)e);
            }
        }
    }

    private void migrateMax(DataType dataType, String[] statsValues, List<Statistic> targetStatistics) {
        String maxValue;
        if (statsValues.length > 2 && !this.isMissing(maxValue = statsValues[2])) {
            Value max = dataType.newValue();
            max.assignFrom(maxValue);
            targetStatistics.add(StatisticsFactory.createMaxValue((Value)max));
        }
    }

    private void migrateMin(DataType dataType, String[] statsValues, List<Statistic> targetStatistics) {
        String minValue;
        if (statsValues.length > 3 && !this.isMissing(minValue = statsValues[3])) {
            Value min = dataType.newValue();
            min.assignFrom(minValue);
            targetStatistics.add(StatisticsFactory.createMinValue((Value)min));
        }
    }

    private boolean isMissing(String value) {
        return value == null || value.isEmpty() || MISSING.equals(value);
    }
}

