/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.upgrade.analytics.migrator;

import com.ibm.bi.platform.moser.common.generated.analytics.FeatureProperty;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.smarts.ca.upgrade.analytics.migrator.FeaturePropertyMigrator;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class UsageMigrator
implements FeaturePropertyMigrator<List<ConceptInfo>> {
    public static final String MEASURE = "Measure";
    public static final String IDENTIFIER = "Identifier";

    @Override
    public void migrate(FeatureProperty property, List<ConceptInfo> target) {
        if (!"Usage".equals(property.getName())) {
            throw new IllegalArgumentException("unexpected property " + property.getName());
        }
        String usage = property.getValue();
        if (usage != null) {
            boolean hasExpectedConcept;
            AtomicReference<String> expectedConceptName = new AtomicReference<String>();
            UsageType usageType = UsageType.fromValue((String)usage);
            switch (usageType) {
                case FACT: {
                    expectedConceptName.set(MEASURE);
                    break;
                }
                case IDENTIFIER: {
                    expectedConceptName.set(IDENTIFIER);
                    break;
                }
            }
            if (expectedConceptName.get() != null && !(hasExpectedConcept = target.stream().anyMatch(c -> ConceptsUtil.getConceptName((ConceptInfo)c).equals(expectedConceptName.get())))) {
                Concept c2 = ConceptsRegistry.instance().getConceptFromName((String)expectedConceptName.get());
                ConceptInfo conceptInfo = c2.toConceptInfo(0.5f);
                target.add(conceptInfo);
            }
        }
    }
}

