/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.smd.analyzer.AnalyzerBase;
import com.ibm.cognos.smd.kb.BusinessAreaApplicability;
import com.ibm.cognos.smd.kb.ExtensionManager;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.model.graph.HeapAssociativeModel;
import com.ibm.cognos.smd.question.QuestionAnalyzer;
import com.ibm.cognos.smd.question.QuestionExposition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;

public class SmartMetadataImpl
implements ISmartMetadata {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)"ATHENA.core.smd");
    private Properties mConfig;
    private IConceptInventory mConceptInventory;
    private ExtensionSource mExtensionSource;

    public void initialize(Properties cfg) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "initialize", "Starting initialization of SMD");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing SMD with configuration: " + cfg.toString(), this.getClass().getName() + "::initialize()");
        }
        this.mConfig = cfg;
        this.handleExtensions(cfg);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("SMD was initialized", this.getClass().getName() + "::initialize()");
        }
        LOGGER.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.SMDSERVICE, (Status)Status.SUCCESS));
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished initialization of SMD");
        }
    }

    public void terminate() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Terminating SMD", this.getClass().getName() + "::terminate()");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("SMD was terminated", this.getClass().getName() + "::terminate()");
        }
        LOGGER.auditSystemEvent(LogEventHelper.createStopServiceEvent((ObjectType)ObjectType.SMDSERVICE, (Status)Status.SUCCESS));
    }

    public Properties getConfigurationProperties() {
        return this.mConfig;
    }

    public IConceptInventory getConceptInventory() {
        return this.mConceptInventory;
    }

    public ExtensionSource getExtensionSource() {
        return this.mExtensionSource;
    }

    public IAssociativeModel createModel() {
        return new HeapAssociativeModel(this.mConceptInventory);
    }

    public Document analyze(IAssociativeModel model) {
        return this.analyze(model, this.buildContextFromParam(false, null));
    }

    public Document analyze(IAssociativeModel model, Map<String, Object> params) {
        return this.analyze(model, this.buildContextFromParam(false, params));
    }

    public Document analyze(IAssociativeModel model, SmdReqContext context) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "analyze", "Starting data analysis");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Analyzing data", this.getClass().getName() + "::analyze()");
        }
        AnalyzerBase analyzer = AnalyzerBase.create(this, model, context);
        Document doc = analyzer.analyze();
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished data analysis");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result of analysis:\n" + doc.asXML(), this.getClass().getName() + "::analyze()");
        }
        return doc;
    }

    public Document decorate(IAssociativeModel model) {
        return this.decorate(model, null);
    }

    public Document decorate(IAssociativeModel model, Map<String, Object> params) {
        return this.analyze(model, this.buildContextFromParam(true, params));
    }

    public List<BusinessAreaApplicability> getApplicableAnalysisAreas(IAssociativeModel model) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "getApplicableAnalysisAreas", "Starting detection of relevent analysis areas");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Detecting relevent analysis areas", this.getClass().getName() + "::getApplicableAnalysisAreas()");
        }
        SmdReqContext context = new SmdReqContext(SmdReqContext.EScope.eBuildModel);
        AnalyzerBase analyzer = AnalyzerBase.create(this, model, context);
        List<BusinessAreaApplicability> out = analyzer.determineAnalysisAreas(model.getRootContainer());
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished detection of relevent analysis areas");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result of analysis:\n" + out, this.getClass().getName() + "::getApplicableAnalysisAreas()");
        }
        return out;
    }

    public QuestionExposition analyzeQuestion(IAssociativeModel model, SmdReqContext context, String questionText) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "analyzeQuestion", "Starting question analysis");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Analyzing question text: " + questionText, this.getClass().getName() + "::analyzeQuestion()");
        }
        QuestionAnalyzer qa = new QuestionAnalyzer(this, model, context);
        QuestionExposition out = qa.analyze(questionText);
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished question analysis");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result of analysis:\n" + out, this.getClass().getName() + "::analyzeQuestion()");
        }
        return out;
    }

    public List<String> getQuestionVocabulary(IAssociativeModel model, SmdReqContext context) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "getQuestionVocabulary", "Starting collection of look-ahead vocabulary");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Collecting look-ahead vocabulary", this.getClass().getName() + "::getQuestionVocabulary()");
        }
        QuestionAnalyzer qa = new QuestionAnalyzer(this, model, context);
        List<String> out = qa.collectLookAheadVocabulary();
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished collection of look-ahead vocabulary");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result of analysis:\n" + out, this.getClass().getName() + "::getQuestionVocabulary()");
        }
        return out;
    }

    private SmdReqContext buildContextFromParam(boolean isDecorate, Map<String, Object> params) {
        SmdReqContext context = new SmdReqContext(isDecorate ? SmdReqContext.EScope.eDecorateModel : SmdReqContext.EScope.eBuildModel);
        if (params != null) {
            Boolean cap;
            Boolean dis;
            String locName;
            Locale loc = (Locale)params.get("CONTENT_LOCALE");
            if (loc != null) {
                context.addAnalysisOption(SmdReqContext.EOption.eContentLocale, (Object)loc);
            }
            if ((locName = (String)params.get("CONTENT_LOCALE_NAME")) != null) {
                context.addAnalysisOption(SmdReqContext.EOption.eContentLocaleName, (Object)locName);
            }
            if ((dis = (Boolean)params.get("DISABLE_DATA_DRIVEN_ANALYSES")) != null) {
                context.addAnalysisOption(SmdReqContext.EOption.eDisableDataDrivenAnalyses, (Object)dis);
            }
            if ((cap = (Boolean)params.get("EXAMINE_CAPTION_UNIQUENESS")) != null) {
                context.addAnalysisOption(SmdReqContext.EOption.eExamineCaptionUniqueness, (Object)cap);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Built request context: " + context, this.getClass().getName() + "::buildContextFromParam()");
        }
        return context;
    }

    private void handleExtensions(Properties cfg) {
        this.mExtensionSource = ExtensionManager.getInstance().getExtensionSource(cfg);
        this.mConceptInventory = this.mExtensionSource.getConceptInventory();
    }
}

