/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.SmdConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class AnalysisContext {
    private static final float CONTEXT_ACTIVATION_THRESHOLD = SmdConfig.getInstance().getValue("analysisContext", "activationThreshold", 0.75f);
    private static final int ACTIVATION_CYCLE_MAX = SmdConfig.getInstance().getValue("analysisContext", "activationCycleMax", 2);
    private static final float ACTIVATION_CYCLE_FACTOR = SmdConfig.getInstance().getValue("analysisContext", "activationCycleLossFactor", 0.7f);
    private Map<Concept, Float> mActiavtedConcepts = new HashMap<Concept, Float>(50);
    private ConceptInventory mKB;
    private AnalysisReport mReport = null;

    AnalysisContext(ConceptInventory aKB, AnalysisReport ar) {
        this.mKB = aKB;
        this.mReport = ar;
    }

    public void addActivation(String strID, List<ActivationSpread> asc) {
        Element elmCurr = this.mReport.addEntry(true, "item", "name", strID);
        for (ActivationSpread as : asc) {
            this.addActivation(as, ACTIVATION_CYCLE_MAX, 1.0f);
        }
        this.mReport.resetCurrent(elmCurr);
    }

    private void addActivation(ActivationSpread as, int spreadCycleIndex, float spreadFactor) {
        --spreadCycleIndex;
        Concept[] concepts = as.getConcepts();
        float[] activations = as.getActivations();
        for (int idx = 0; idx < as.getSize(); ++idx) {
            Concept c = concepts[idx];
            Float activationLevel = this.mActiavtedConcepts.get(c);
            if (activationLevel == null) {
                this.mActiavtedConcepts.put(c, Float.valueOf(spreadFactor * Float.valueOf(activations[idx]).floatValue()));
            } else {
                this.mActiavtedConcepts.put(c, Float.valueOf(spreadFactor * Float.valueOf(activationLevel.floatValue() + activations[idx]).floatValue()));
            }
            this.mReport.addEntry(false, "activation", "cycle", Integer.toString(spreadCycleIndex + 1), c.getName(), Float.toString(activations[idx]));
            if (spreadCycleIndex <= 0 || idx <= 0) continue;
            this.addActivation(this.mKB.getActivationSpread(c), spreadCycleIndex, spreadFactor * ACTIVATION_CYCLE_FACTOR);
        }
    }

    public float getActivationLevel(Concept c) {
        Float f = this.mActiavtedConcepts.get(c);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    List<Concept> getContext() {
        ArrayList<Concept> out = new ArrayList<Concept>(20);
        for (Map.Entry<Concept, Float> entry : this.mActiavtedConcepts.entrySet()) {
            if (!(entry.getValue().floatValue() >= CONTEXT_ACTIVATION_THRESHOLD)) continue;
            out.add(entry.getKey());
        }
        return out;
    }

    Concept findConceptWithHighestActivation(List<Concept> diConcepts) {
        if (diConcepts.size() == 0) {
            return null;
        }
        if (diConcepts.size() == 1) {
            return diConcepts.get(0);
        }
        Concept maxConcept = diConcepts.get(0);
        float maxActivation = this.getActivationLevel(maxConcept);
        for (int idx = 1; idx < diConcepts.size(); ++idx) {
            float anActivation = this.getActivationLevel(diConcepts.get(idx));
            if (!(anActivation > maxActivation)) continue;
            maxConcept = diConcepts.get(idx);
            maxActivation = anActivation;
        }
        return maxConcept;
    }

    Concept findConceptWithHighestActivation(Concept cOne, Concept cTwo) {
        if (this.getActivationLevel(cOne) >= this.getActivationLevel(cTwo)) {
            return cOne;
        }
        return cTwo;
    }

    void reportContext() {
        this.mReport.addEntry(true, "context", new String[0]);
        for (Map.Entry<Concept, Float> entry : this.mActiavtedConcepts.entrySet()) {
            this.mReport.addEntry(false, "concept", "name", entry.getKey().getName(), "activationLevel", entry.getValue().toString());
        }
    }

    public String asXML() {
        StringBuilder sb = new StringBuilder("<context>");
        for (Map.Entry<Concept, Float> entry : this.mActiavtedConcepts.entrySet()) {
            sb.append("<concept c=\"");
            sb.append(entry.getKey().getName());
            sb.append("\" activationLevel=\"");
            sb.append(entry.getValue().toString());
            sb.append("\"/>");
        }
        sb.append("</context>");
        return sb.toString();
    }
}

