/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.smd.utilities.SmdConfig;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class AnalysisReport {
    public static final String REPORT_SUFFIX = SmdConfig.getInstance().getValue("analysisReport", "reportFileSuffix", "_out_Report.xml");
    static final String gAFFIRMATIVE = "affirmative";
    static final String gNEGATIVE = "negative";
    static final String gREASON = "reason";
    static final String RULE_DataHintsEvaluation = "dataHintsEvaluation";
    static final String RULE_DataValuesEvaluation = "dataValuesEvaluation";
    static final String RULE_DataNominalEvaluation = "dataNominalEvaluation";
    static final String RULE_bestExplainedAsNominal = "bestExplainedAsNominal";
    static final String RULE_numericDataType = "numericDataType";
    static final String RULE_nonNumericDataType = "nonNumericDataType";
    static final String RULE_tempralDataType = "temporalDataType";
    static final String RULE_MatchingDataValues = "matchingDataValues";
    static final String RULE_labelSignifiesIdentifier = "labelSignifiesIdentifier";
    static final String RULE_categoryID = "categoryID";
    static final String RULE_yearValues = "yearValues";
    static final String RULE_categoryAttribute = "categoryAttribute";
    static final String RULE_metricAttributeIncompatibility = "metricAttributeIncompatibility";
    static final String RULE_metric = "metric";
    static final String RULE_identifierUniformValues = "identifierUniformValues";
    static final String RULE_definedAttribute = "definedAttribute";
    static final String RULE_duplicateAttribute = "duplicateAttribute";
    static final String RULE_conceptMismatch = "conceptMismatch";
    static final String RULE_definedConceptForDetailedCategory = "definedConceptForDetailedCategory";
    static final String RULE_expectingOneOneValueAssociation = "expectingOneOneValueAssociation";
    static final String RULE_nameOverlap = "nameOverlap";
    static final String RULE_matchingCardinality = "matchingCardinality";
    static final String RULE_noAttributeForTemporal = "noAttributeForTemporal";
    static final String RULE_excludeTemporalDataType = "excludeTemporalDataType";
    static final String RULE_expectingUniqueValues = "expectingUniqueValues";
    static final String RULE_expectingCardinalityRatio = "expectingCardinalityRatio";
    static final String RULE_expectingOneManyValueAssociation = "expectingOneManyValueAssociation";
    static final String RULE_alreadyHasPart = "ItemOneAlreadyHasPart";
    static final String RULE_alreadyIsWhole = "ItemTwoIsAlreadyWhole";
    static final String RULE_lowDensity = "lowDensity";
    static final String RULE_lowDesnityOrCardinality = "LowDesnityOrCardinality";
    static final String RULE_temporalItem = "temporalItem";
    static final String RULE_failedCategoryIdDataPatterns = "failedCategoryIdDataPatterns";
    static final String RULE_knownMetric = "knownMetric";
    public static final String RULE_QA_dateTemporalMatch = "dateTemporalMatch";
    public static final String RULE_QA_exactNameMatch = "exactNameMatch";
    public static final String RULE_QA_nameMatch = "nameMatch";
    public static final String RULE_QA_semanticMatch = "semanticMatch";
    public static final String RULE_QA_valueMatch = "valueMatch";
    private Element mCurrent = null;

    public Document getReportDocument() {
        return this.mCurrent.getDocument();
    }

    public static String generateReportFile(Document docReport, String baseOutFilePath) {
        String outPath = baseOutFilePath + REPORT_SUFFIX;
        try {
            FileOutputStream fos = new FileOutputStream(outPath);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(docReport);
            writer.flush();
            writer.close();
            fos.close();
            return outPath;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public AnalysisReport() {
        Document document = DocumentHelper.createDocument();
        this.mCurrent = document.addElement("analysisReport");
    }

    public Element addEntry(boolean updateCurrent, String name, String ... attrValuePairs) {
        Element out = this.mCurrent;
        Element elmNew = this.mCurrent.addElement(name);
        for (int idx = 0; idx < attrValuePairs.length; idx += 2) {
            if (idx + 1 < attrValuePairs.length) {
                elmNew.addAttribute(attrValuePairs[idx], attrValuePairs[idx + 1]);
                continue;
            }
            elmNew.addAttribute(attrValuePairs[idx], "");
        }
        if (updateCurrent) {
            this.mCurrent = elmNew;
        }
        return out;
    }

    public void addText(String txt) {
        this.mCurrent.addText(txt);
    }

    public void resetCurrent(Element elmCurrent) {
        this.mCurrent = elmCurrent;
    }
}

