/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.cognos.ccl4j.resource.CCLResourceManager;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import com.ibm.cognos.smd.SmartMetadataImpl;
import com.ibm.cognos.smd.analyzer.AnalysisContext;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.LexicalAnalyzer;
import com.ibm.cognos.smd.analyzer.LexicalClueExtractor;
import com.ibm.cognos.smd.analyzer.LexicalDecorator;
import com.ibm.cognos.smd.analyzer.LexicalHierarchyBuilder;
import com.ibm.cognos.smd.analyzer.NominalDetector;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.BusinessAreaApplicability;
import com.ibm.cognos.smd.kb.CascadingLexicalClueResolver;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.DataHints;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.LexicalClueInventory;
import com.ibm.cognos.smd.kb.LexicalClueInventoryManager;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.kb.SignifierData;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class AnalyzerBase {
    private static final Locale DEFAULT_LOCALE = CCLResourceManager.getLocale((String)SmdConfig.getInstance().getValue("analyzer", "defaultContentLocale", "en"));
    private ExtensionSource mExtensionSrc;
    private final ConceptInventory mKB;
    private final IAssociativeModel mModel;
    private final SmdReqContext mReqContext;
    private final CascadingLexicalClueResolver mClueInventory;
    private AnalysisReport mReport = null;
    private AnalysisContext mContext = null;
    private LexicalClueExtractor mClueExtractor;
    private Map<IDataItem, DataItemExtension> mDataItemExtensions = new HashMap<IDataItem, DataItemExtension>();

    public static AnalyzerBase create(SmartMetadataImpl smd, IAssociativeModel model, SmdReqContext reqContext) {
        AnalyzerBase out = null;
        switch (reqContext.getScope()) {
            case eBuildModel: {
                out = new LexicalAnalyzer(smd, model, reqContext);
                break;
            }
            case eDecorateModel: {
                out = new LexicalDecorator(smd, model, reqContext);
                break;
            }
            case eBuildHierarchicalCategories: {
                out = new LexicalHierarchyBuilder(smd, model, reqContext);
                break;
            }
            default: {
                ToolBox.Assert(false, "Unexpected Alanyzer scope:", reqContext.getScope().toString());
            }
        }
        super.setExtensionSource(smd.getExtensionSource());
        return out;
    }

    protected AnalyzerBase(SmartMetadataImpl smd, IAssociativeModel model, SmdReqContext reqContext) {
        this.mKB = (ConceptInventory)smd.getConceptInventory();
        this.mModel = model;
        this.mReqContext = reqContext;
        this.mReport = new AnalysisReport();
        this.mContext = new AnalysisContext(this.mKB, this.mReport);
        this.reportAnalysisParams();
        Locale localeContent = this.getContentLocale();
        LexicalClueInventoryManager clueMngr = LexicalClueInventoryManager.getInstance();
        LexicalClueInventory primaryClues = clueMngr.getLexicalInventoryFor(smd.getExtensionSource(), localeContent);
        Element elmOld = this.mReport.addEntry(true, "locale", new String[0]);
        this.mReport.addEntry(false, "contentLocale", "value", localeContent.toString(), "displayName", localeContent.getDisplayName());
        this.mReport.addEntry(false, "baseCluesSource", "value", primaryClues.getCluseSourceName());
        LexicalClueInventory defaultClues = null;
        if (!localeContent.getLanguage().equals(DEFAULT_LOCALE.getLanguage())) {
            defaultClues = clueMngr.getLexicalInventoryFor(smd.getExtensionSource(), DEFAULT_LOCALE);
            this.mReport.addEntry(false, "defaultCluesSource", "value", defaultClues.getCluseSourceName());
        }
        this.mClueInventory = new CascadingLexicalClueResolver(primaryClues, defaultClues);
        this.mClueExtractor = new LexicalClueExtractor(primaryClues, this.mReport);
        this.mReport.resetCurrent(elmOld);
    }

    private void setExtensionSource(ExtensionSource srcExt) {
        this.mExtensionSrc = srcExt;
    }

    void establishContext(IDataContainer rootCon) {
    }

    void determineMetadata(IDataContainer rootCon) {
    }

    public Document analyze() {
        IDataContainer rc = this.mModel.getRootContainer();
        Element elmOld = this.mReport.addEntry(true, "establishContext", new String[0]);
        long b4 = System.nanoTime();
        this.establishContext(rc);
        this.mReport.addEntry(false, "performance", "time-ms", ToolBox.elapsedTimeAsString(b4));
        this.mReport.resetCurrent(elmOld);
        this.mContext.reportContext();
        this.mReport.resetCurrent(elmOld);
        elmOld = this.mReport.addEntry(true, "determineMetadata", new String[0]);
        b4 = System.nanoTime();
        this.determineMetadata(rc);
        this.accountForQualifiers();
        this.mReport.addEntry(false, "performance", "time-ms", ToolBox.elapsedTimeAsString(b4));
        this.mReport.resetCurrent(elmOld);
        this.mReport.addEntry(true, "determineDomain", new String[0]);
        b4 = System.nanoTime();
        this.determineAnalysisAreas(rc);
        this.mReport.addEntry(false, "performance", "time-ms", ToolBox.elapsedTimeAsString(b4));
        return this.mReport.getReportDocument();
    }

    protected AnalysisReport getReport() {
        return this.mReport;
    }

    protected CascadingLexicalClueResolver getClueInventory() {
        return this.mClueInventory;
    }

    protected IAssociativeModel getModel() {
        return this.mModel;
    }

    protected ConceptInventory getConceptInventory() {
        return this.mKB;
    }

    protected LexicalClueExtractor getClueExtractor() {
        return this.mClueExtractor;
    }

    protected Map<IDataItem, DataItemExtension> getDItemExtensionsMap() {
        return this.mDataItemExtensions;
    }

    private DataItemExtension addDataItemExtension(IDataItem di, short idxDI) {
        DataItemExtension dix = this.mDataItemExtensions.get(di);
        ToolBox.Assert(dix == null, "The given data item is already accounted for: ", di.getName());
        dix = new DataItemExtension(di, idxDI);
        this.mDataItemExtensions.put(di, dix);
        return dix;
    }

    public List<BusinessAreaApplicability> determineAnalysisAreas(IDataContainer rootCon) {
        if (!this.mExtensionSrc.hasDomains()) {
            return null;
        }
        ArrayList<IConcept> modelConcepts = new ArrayList<IConcept>(20);
        this.collectModelConcepts(rootCon, modelConcepts);
        List<BusinessAreaApplicability> vAreas = this.mExtensionSrc.findApplicableBusinessAreas(modelConcepts);
        for (BusinessAreaApplicability ba : vAreas) {
            this.mReport.addEntry(false, "analysisArea", "name", ba.getArea().getName(), "domain", ba.getArea().getDomian().getName(), "applicability", Float.toString(ba.getApplicability()));
        }
        return vAreas;
    }

    private void collectModelConcepts(IDataContainer dc, List<IConcept> allConcepts) {
        List nodes = dc.getNodes();
        for (INode aNode : nodes) {
            IConcept cNode = aNode.getConcept();
            if (!cNode.isCategory() && !cNode.isMetric()) continue;
            allConcepts.add(cNode);
        }
        if (dc.getChildren() != null) {
            for (IDataContainer c : dc.getChildren()) {
                this.collectModelConcepts(c, allConcepts);
            }
        }
    }

    protected DataItemExtension findDataItemExtension(IDataItem di, boolean bRequired) {
        DataItemExtension dix = this.mDataItemExtensions.get(di);
        if (bRequired) {
            ToolBox.Assert(dix != null, "Unable to find data item extension for data item:", di.getName());
        }
        return dix;
    }

    protected Element reportDataItem(IDataItem di) {
        IDataItemStats stats = di.getStats();
        IValue minVal = stats.minValue();
        String sMinValue = null != minVal && minVal.getStatus() == ValueStatus.OK ? minVal.stringValue() : "";
        IValue maxVal = stats.maxValue();
        String sMaxValue = null != maxVal && maxVal.getStatus() == ValueStatus.OK ? maxVal.stringValue() : "";
        StringBuilder vd = new StringBuilder("");
        for (IValueDecoration valueDecor : di.getValueDecorations()) {
            vd.append(valueDecor.toString());
            vd.append("   ");
        }
        Element elmCurr = this.mReport.addEntry(true, "item", "name", di.getName(), "dataType", di.getDataType().toString(), "numValues", Long.toString(stats.totalCount()), "numDistinctValues", Long.toString(stats.distinctCount()), "minValue", sMinValue, "maxValue", sMaxValue, "density", Float.toString(stats.density()), "valueDecorators", vd.toString());
        return elmCurr;
    }

    Candidate determineDefaultConcept(DataItemExtension dix, Candidate inLineAttr) {
        String selectionCriteria = null;
        Candidate selectedCandidate = null;
        Concept genericCatgeory = (Concept)this.mKB.getGenericCategory();
        IDataType dType = dix.getDataItem().getDataType();
        if (dType.isNumeric()) {
            if (inLineAttr != null && this.mKB.getIdentifierAttribute().equals(inLineAttr.getConcept())) {
                selectedCandidate = new Candidate(genericCatgeory);
                selectionCriteria = "labelSignifiesIdentifier";
            } else if (dix.getDataItemIndex() == 0 && genericCatgeory.getDataHints().evaluateDataHints(dix) > 0.0f) {
                selectedCandidate = new Candidate(genericCatgeory);
                selectionCriteria = "categoryID";
            } else if (this.canBeInterpretedAsYear(dix)) {
                selectedCandidate = new Candidate((Concept)this.mKB.getConcept("cYear"));
                selectionCriteria = "yearValues";
            } else if (dType.isExactNumeric() && !DataHints.hasLowDensity(dix.getDataItem()) && NominalDetector.isBestRepresentedAsNominalCategory(this.mKB, null, dix.getDataItem())) {
                selectedCandidate = new Candidate((Concept)this.mKB.getGenericNominal());
                selectionCriteria = "bestExplainedAsNominal";
            } else {
                selectedCandidate = new Candidate((Concept)this.mKB.getGenericMetric());
                selectionCriteria = "numericDataType";
            }
        } else if (dType.isTemporal()) {
            selectedCandidate = new Candidate((Concept)this.mKB.getGenericTemporal());
            selectionCriteria = "temporalDataType";
        } else {
            selectedCandidate = new Candidate((Concept)this.mKB.getGenericCategory());
            selectionCriteria = "nonNumericDataType";
        }
        if (NominalDetector.isBestRepresentedAsNominalCategory(this.mKB, selectedCandidate, dix.getDataItem())) {
            selectedCandidate = new Candidate((Concept)this.mKB.getGenericNominal());
            selectionCriteria = "bestExplainedAsNominal";
        }
        this.mReport.addEntry(false, "defaultCandidate", "concept", selectedCandidate.getConcept().getName(), "criteria", selectionCriteria);
        return selectedCandidate;
    }

    private boolean canBeInterpretedAsYear(DataItemExtension dix) {
        Concept cYear = (Concept)this.mKB.getConcept("cYear");
        if (cYear.getDataHints().evaluateDataHints(dix) > 0.0f && dix.getDataItem().getStats().density() >= DataHints.NotNull_DENSITY_THRESHOLD) {
            float rValues = -1.0f;
            SignifierData ds = this.mClueInventory.getDataSignifier(cYear);
            if (ds != null) {
                rValues = ((Signifier)ds).evaluateDataValues(dix);
            }
            return rValues >= 0.5f;
        }
        return false;
    }

    void reportCandidates(List<Candidate> candidates) {
        Element elmEntry = this.mReport.addEntry(true, "candidates", new String[0]);
        for (Candidate c : candidates) {
            this.mReport.addEntry(false, "concept", "name", c.getConcept().getName(), "type", c.getConcept().getIsAs().get(0));
        }
        this.mReport.resetCurrent(elmEntry);
    }

    protected void establishContext(IDataItem di, short idx) {
        DataItemExtension dix = this.addDataItemExtension(di, idx);
        List<String> clues = dix.getNameLemmas(this.mClueExtractor);
        this.accountForValueDecorations(di, clues);
        List<ActivationSpread> acs = this.mClueInventory.getActivationFor(clues, dix);
        this.mContext.addActivation(di.getName(), acs);
    }

    protected void accountForValueDecorations(IDataItem di, List<String> clues) {
        for (IValueDecoration vd : di.getValueDecorations()) {
            if (vd.isPercent()) {
                clues.add("%");
                continue;
            }
            if (!vd.isCurrency()) continue;
            clues.add("$");
        }
    }

    protected AnalysisContext getContext() {
        return this.mContext;
    }

    protected SmdReqContext getRequestContext() {
        return this.mReqContext;
    }

    final Object getAnalysisOption(SmdReqContext.EOption opKey) {
        return this.mReqContext.getOption(opKey);
    }

    protected Locale getContentLocale() {
        Locale outLocale = null;
        outLocale = (Locale)this.getAnalysisOption(SmdReqContext.EOption.eContentLocale);
        if (outLocale != null) {
            return outLocale;
        }
        String passedLocale = (String)this.getAnalysisOption(SmdReqContext.EOption.eContentLocaleName);
        if (passedLocale != null && passedLocale.length() > 0) {
            outLocale = CCLResourceManager.getLocale((String)passedLocale);
        }
        if (outLocale == null) {
            outLocale = DEFAULT_LOCALE;
        }
        return outLocale;
    }

    private void reportAnalysisParams() {
        Boolean cap;
        Boolean dis;
        String locName;
        Element elmCurr = this.mReport.addEntry(true, "analysisParams", new String[0]);
        this.mReport.addEntry(false, "analysisScope", "value", this.mReqContext.getScope().toString());
        Locale loc = (Locale)this.getAnalysisOption(SmdReqContext.EOption.eContentLocale);
        if (loc != null) {
            this.mReport.addEntry(false, "CONTENT_LOCALE", "value", loc.toString());
        }
        if ((locName = (String)this.getAnalysisOption(SmdReqContext.EOption.eContentLocaleName)) != null) {
            this.mReport.addEntry(false, "CONTENT_LOCALE_NAME", "value", locName);
        }
        if ((dis = (Boolean)this.getAnalysisOption(SmdReqContext.EOption.eDisableDataDrivenAnalyses)) != null) {
            this.mReport.addEntry(false, "DISABLE_DATA_DRIVEN_ANALYSES", "value", dis.toString());
        }
        if ((cap = (Boolean)this.getAnalysisOption(SmdReqContext.EOption.eExamineCaptionUniqueness)) != null) {
            this.mReport.addEntry(false, "EXAMINE_CAPTION_UNIQUENESS", "value", cap.toString());
        }
        this.mReport.resetCurrent(elmCurr);
    }

    private void accountForQualifiers() {
        Iterator iter = this.mModel.findNodes(NodeFilters.isMetric()).iterator();
        while (iter.hasNext()) {
            this.accountForQualifiers((INode)iter.next());
        }
        iter = this.mModel.findNodes(NodeFilters.isCategory()).iterator();
        while (iter.hasNext()) {
            this.accountForQualifiers((INode)iter.next());
        }
    }

    private void accountForQualifiers(INode aNode) {
        Concept cNode = (Concept)aNode.getConcept();
        List<IConcept> vQualifiers = cNode.getQualifiers();
        if (vQualifiers == null || vQualifiers.isEmpty()) {
            return;
        }
        IDataItem dItem = aNode.getDataItem();
        if (dItem == null) {
            dItem = NavigationHelper.getIdentifierAttributeFromCategory((INode)aNode).getDataItem();
        }
        ToolBox.Assert(dItem != null, "Expecting a valid dataItem associated with node:", aNode.getId());
        DataItemExtension dix = this.findDataItemExtension(dItem, true);
        for (IConcept cQualifier : vQualifiers) {
            String iValue = ((Concept)cQualifier).matchInstances(this.getClueInventory(), dix);
            if (iValue == null) continue;
            aNode.setProperty(cQualifier.getName(), (Object)iValue);
        }
    }
}

