/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.utilities.SmdConfig;

class Candidate {
    private static final float gDefault_Activation = 0.0f;
    private static final float gUnknown_SignifierMatch = 0.0f;
    private static final int Required_Data_Match = SmdConfig.getInstance().getValue("dataValueMatch", "requiredWhenSampleDataExist", 0);
    private static final float[] gConfidence_Weight_Factors = new float[]{0.4f, 0.4f, 0.2f};
    private static final float gDefault_DataHintResult = 0.5f;
    static final float gData_Value_Match_Threashold = 0.5f;
    private Concept mConcept;
    private float mSignifierStrength = 0.0f;
    private float mConceptActivation = 0.0f;
    private float mDataHintsResult = -1.0f;
    private float mDataValuesResult = -1.0f;
    private int mDataNominalResult = -1;

    Candidate(Concept candidate) {
        this.mConcept = candidate;
        this.mSignifierStrength = 0.0f;
        this.mConceptActivation = 0.0f;
        this.mDataHintsResult = 0.5f;
    }

    Candidate(Concept candidate, float signMatchStrength) {
        this.mConcept = candidate;
        this.mSignifierStrength = signMatchStrength;
        this.mConceptActivation = 0.0f;
    }

    Concept getConcept() {
        return this.mConcept;
    }

    void setConceptActivation(float act) {
        this.mConceptActivation = act;
    }

    void setDataValuesMatchIndication(float dvm) {
        this.mDataValuesResult = dvm;
    }

    void setDataHintsEvaluationResult(float dhr) {
        this.mDataHintsResult = dhr;
    }

    void setDataNominalEvaluationResult(int dnr) {
        this.mDataNominalResult = dnr;
    }

    boolean isMetric() {
        return this.mConcept.isMetric();
    }

    boolean isCategory() {
        return this.mConcept.isCategory();
    }

    boolean isAttribute() {
        return this.mConcept.isAttribute();
    }

    float getOverallConfidence() {
        float out = this.mSignifierStrength * gConfidence_Weight_Factors[0];
        if (this.mDataHintsResult > 0.0f) {
            out += this.mDataHintsResult * gConfidence_Weight_Factors[1];
        }
        if (this.mDataValuesResult > 0.0f) {
            out += this.mDataValuesResult * gConfidence_Weight_Factors[2];
        }
        if (out > 1.0f) {
            out = 1.0f;
        }
        return out;
    }

    Candidate compare(Candidate that) {
        if (that == null) {
            return this.isAcceptable() ? this : null;
        }
        if (this.canBeCompared(this.mDataValuesResult, that.mDataValuesResult)) {
            if (this.mDataValuesResult < that.mDataValuesResult) {
                return that;
            }
            if (this.mDataValuesResult > that.mDataValuesResult) {
                return this;
            }
        }
        if (this.canBeCompared(this.mDataHintsResult, that.mDataHintsResult)) {
            if (this.mDataHintsResult < that.mDataHintsResult) {
                return that;
            }
            if (this.mDataHintsResult > that.mDataHintsResult) {
                return this;
            }
        }
        if (this.isAcceptable() && !that.isAcceptable()) {
            return this;
        }
        if (!this.isAcceptable() && that.isAcceptable()) {
            return that;
        }
        if (this.canBeCompared(this.mDataNominalResult, that.mDataNominalResult)) {
            if (this.mDataNominalResult < that.mDataNominalResult) {
                return that;
            }
            if (this.mDataNominalResult > that.mDataNominalResult) {
                return this;
            }
        }
        if (this.mConcept.is(that.mConcept)) {
            return this;
        }
        if (that.mConcept.is(this.mConcept)) {
            return that;
        }
        if (this.mConceptActivation < that.mConceptActivation) {
            return that;
        }
        return this;
    }

    private boolean canBeCompared(float f1, float f2) {
        return f1 > 0.0f || f2 > 0.0f;
    }

    boolean isAcceptable() {
        boolean passesDHints;
        boolean bl = passesDHints = this.mDataHintsResult == -1.0f || this.mDataHintsResult > 0.0f;
        if (!passesDHints) {
            return false;
        }
        if (this.mDataNominalResult == 0) {
            return false;
        }
        if (Required_Data_Match == 1 && this.mDataValuesResult != -1.0f) {
            return this.mDataValuesResult > 0.0f;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Candidate\n");
        sb.append("\tconcept:");
        sb.append(this.mConcept.getName());
        sb.append("\tSignifierStength:");
        sb.append(Float.toString(this.mSignifierStrength));
        sb.append("\tConcept Actication:");
        sb.append(Float.toString(this.mConceptActivation));
        sb.append("\tData Hint Evaluation:");
        sb.append(Float.toString(this.mDataHintsResult));
        sb.append("\tNominal Evaluation:");
        sb.append(Integer.toString(this.mDataNominalResult));
        sb.append("\tData Value Match:");
        sb.append(Float.toString(this.mDataValuesResult));
        return sb.toString();
    }
}

