/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.smd.analyzer.AnalysisContext;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.analyzer.AnalyzerBase;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.NominalDetector;
import com.ibm.cognos.smd.kb.CascadingLexicalClueResolver;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.DataHints;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.kb.SignifierData;
import java.util.List;
import org.dom4j.Element;

class DataAnalyzer {
    private ConceptInventory mKB;
    private CascadingLexicalClueResolver mClueInventory;
    private DataItemExtension mDataItemExt = null;
    private AnalysisReport mReport = null;

    DataAnalyzer(AnalyzerBase la, DataItemExtension dix) {
        this.mKB = la.getConceptInventory();
        this.mClueInventory = la.getClueInventory();
        this.mDataItemExt = dix;
        this.mReport = la.getReport();
    }

    Candidate evaluateCandidates(AnalysisContext aContext, List<Candidate> candidates) {
        Candidate bestCandidate = null;
        for (Candidate curr : candidates) {
            float activation = aContext.getActivationLevel(curr.getConcept());
            Element elmExEntry = this.mReport.addEntry(true, "examiningCandidate", "name", curr.getConcept().getName(), "activationLevel", Float.toString(activation));
            curr.setConceptActivation(activation);
            this.evaluateDataClues(curr);
            bestCandidate = curr.compare(bestCandidate);
            this.mReport.resetCurrent(elmExEntry);
        }
        if (bestCandidate != null && bestCandidate.isAcceptable()) {
            this.mReport.addEntry(false, "selecting", "name", bestCandidate.getConcept().getName());
        }
        return bestCandidate;
    }

    Candidate evaluateCandidate(AnalysisContext aContext, Candidate c) {
        float activation = aContext.getActivationLevel(c.getConcept());
        Element elmExEntry = this.mReport.addEntry(true, "examiningCandidate", "name", c.getConcept().getName(), "activationLevel", Float.toString(activation));
        c.setConceptActivation(activation);
        this.evaluateDataClues(c);
        this.mReport.resetCurrent(elmExEntry);
        if (c.isAcceptable()) {
            return c;
        }
        return null;
    }

    void evaluateDataClues(Candidate candidate) {
        SignifierData ds;
        DataHints dh = candidate.getConcept().getApplicableDataHints();
        if (dh == null) {
            return;
        }
        float rHints = dh.evaluateDataHints(this.mDataItemExt);
        candidate.setDataHintsEvaluationResult(rHints);
        this.mReport.addEntry(false, "dataHintsEvaluation", "result", DataHints.dataHintsResultAsString(rHints));
        if (rHints == 0.0f) {
            return;
        }
        if (candidate.getConcept().is(this.mKB.getGenericNominal())) {
            int isNomonal = NominalDetector.isBestRepresentedAsNominalCategory(this.mKB, candidate, this.mDataItemExt.getDataItem()) ? 1 : 0;
            candidate.setDataNominalEvaluationResult(isNomonal);
            this.mReport.addEntry(false, "dataNominalEvaluation", "result", DataHints.dataHintsResultAsString(isNomonal));
            if (isNomonal == 0) {
                return;
            }
        }
        if ((ds = this.mClueInventory.getDataSignifier(candidate.getConcept())) == null) {
            return;
        }
        float rValues = ((Signifier)ds).evaluateDataValues(this.mDataItemExt);
        candidate.setDataValuesMatchIndication(rValues);
        this.mReport.addEntry(false, "dataValuesEvaluation", "result", Signifier.dataValuesResultAsString(rValues));
    }

    Candidate resolveBasedOnDataValues(List<Concept> activeConcepts) {
        Concept bestConcept = null;
        float bestValueMatch = 0.0f;
        for (Concept c : activeConcepts) {
            float res = 0.0f;
            SignifierData ds = this.mClueInventory.getDataSignifier(c);
            if (ds != null) {
                res = ((Signifier)ds).evaluateDataValues(this.mDataItemExt);
            }
            if (!(res > bestValueMatch)) continue;
            bestConcept = c;
            bestValueMatch = res;
        }
        if (bestValueMatch > 0.5f) {
            this.mReport.addEntry(false, "selecting", "name", bestConcept.getName(), "basedOn", "matchingDataValues");
            Candidate outCandidate = new Candidate(bestConcept);
            outCandidate.setDataValuesMatchIndication(bestValueMatch);
            return outCandidate;
        }
        return null;
    }
}

