/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class DataCollector {
    private static final int SAMPLE_MAX_ROW = SmdConfig.getInstance().getValue("hierarchyDetection", "maxRowsToRead", 2000);
    public static final int SAMPLE_MAX_ROW_OneOne_ASSOCIATION = SmdConfig.getInstance().getValue("itemGrouping", "maxRowsToRead", 200);
    static final int ITEM_GROUPING_MIN_VALUE = 2;
    private static final int PERIODIC_CHECK_OVERLAP = 400;
    private AnalysisReport mReport;

    public DataCollector(AnalysisReport report) {
        this.mReport = report;
    }

    public boolean doValuesHaveOneManyAssociation(IDataItem diOne, IDataItem diTwo) {
        long b4 = System.nanoTime();
        Element elmCurr = this.mReport.addEntry(true, "doValuesHaveOneManyAssociation", new String[0]);
        HashMap<IValue, Set<IValue>> correspondingSets = new HashMap<IValue, Set<IValue>>();
        boolean bOverlap = this.collectValues(diOne, diTwo, correspondingSets);
        if (!bOverlap) {
            bOverlap = this.doValueSetsOverlap(correspondingSets);
        }
        this.mReport.addEntry(false, "performance", "time-ms", ToolBox.elapsedTimeAsString(b4));
        this.mReport.resetCurrent(elmCurr);
        this.mReport.addEntry(false, bOverlap ? "negative" : "affirmative", "reason", "expectingOneManyValueAssociation");
        return !bOverlap;
    }

    public boolean doValuesHaveOneOneAssociation(IDataItem diOne, IDataItem diTwo) {
        long b4 = System.nanoTime();
        Element elmCurr = this.mReport.addEntry(true, "doValuesHaveOneOneAssociation", new String[0]);
        boolean result = this.doesOneOneAssociationExist(diOne, diTwo);
        this.mReport.addEntry(false, "performance", "time-ms", ToolBox.elapsedTimeAsString(b4));
        this.mReport.resetCurrent(elmCurr);
        this.mReport.addEntry(false, result ? "affirmative" : "negative", "reason", "expectingOneOneValueAssociation");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesOneOneAssociationExist(IDataItem diOne, IDataItem diTwo) {
        int related = -1;
        long rowMax = Math.min(diOne.getStats().count(), diTwo.getStats().count());
        HashMap<IValue, IValue> valuesMap = new HashMap<IValue, IValue>();
        IValueIterator vItr1 = null;
        IValueIterator vItr2 = null;
        try {
            vItr1 = diOne.fetchValues(rowMax);
            vItr2 = diTwo.fetchValues(rowMax);
            long idx = 0L;
            while (related == -1 && idx < rowMax) {
                IValue v1 = vItr1.next();
                IValue v2 = vItr2.next();
                IValue corrValue = (IValue)valuesMap.get(v1);
                if (corrValue == null) {
                    valuesMap.put(v1, v2);
                } else if (!corrValue.equals(v2)) {
                    Element elmCurr = this.mReport.addEntry(true, "moreThanOneValueAssociation", "firstItemValue", v1.toString());
                    this.mReport.addEntry(false, "secondItemValue", "v1", corrValue.toString());
                    this.mReport.addEntry(false, "secondItemValue", "v2", v2.toString());
                    this.mReport.resetCurrent(elmCurr);
                    related = 0;
                }
                if (related != -1 || ++idx % (long)SAMPLE_MAX_ROW_OneOne_ASSOCIATION != 0L || valuesMap.keySet().size() <= 2) continue;
                related = 1;
            }
            if (related == -1 && valuesMap.keySet().size() >= 2) {
                related = 1;
            }
        }
        finally {
            try {
                if (null != vItr1) {
                    vItr1.close();
                }
            }
            finally {
                if (null != vItr2) {
                    vItr2.close();
                }
            }
        }
        return related == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectValues(IDataItem diOne, IDataItem diTwo, Map<IValue, Set<IValue>> correspondingSets) {
        long rowMax = Math.min(diOne.getStats().count(), diTwo.getStats().count());
        rowMax = Math.min(rowMax, (long)SAMPLE_MAX_ROW);
        IValueIterator vItr1 = null;
        IValueIterator vItr2 = null;
        try {
            vItr1 = diOne.fetchValues(rowMax);
            vItr2 = diTwo.fetchValues(rowMax);
            long idx = 0L;
            int idxChunk = 0;
            while (idx < rowMax) {
                IValue v1 = vItr1.next();
                IValue v2 = vItr2.next();
                Set<IValue> corrValues = correspondingSets.get(v1);
                if (corrValues == null) {
                    corrValues = new HashSet<IValue>((int)diTwo.getStats().count() / (int)diOne.getStats().distinctCount());
                    correspondingSets.put(v1, corrValues);
                }
                corrValues.add(v2);
                ++idx;
                if (++idxChunk != 400) continue;
                idxChunk = 0;
                if (!this.doValueSetsOverlap(correspondingSets)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                if (null != vItr1) {
                    vItr1.close();
                }
            }
            finally {
                if (null != vItr2) {
                    vItr2.close();
                }
            }
        }
        return false;
    }

    private boolean doValueSetsOverlap(Map<IValue, Set<IValue>> correspondingSets) {
        Object[] keys;
        Object[] valueSets = correspondingSets.values().toArray();
        ToolBox.Assert(valueSets.length == (keys = correspondingSets.keySet().toArray()).length, "Expecting identical numbers!");
        for (int idx = 0; idx < valueSets.length; ++idx) {
            for (int ii = idx + 1; ii < valueSets.length; ++ii) {
                if (!this.overlap((IValue)keys[idx], (Set)valueSets[idx], (IValue)keys[ii], (Set)valueSets[ii])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean overlap(IValue k1, Set<IValue> s1, IValue k2, Set<IValue> s2) {
        for (IValue v : s1) {
            if (v.isNull() || !s2.contains(v)) continue;
            this.reportOverlap(k1, s1, k2, s2, v);
            return true;
        }
        return false;
    }

    private void reportOverlap(IValue k1, Set<IValue> s1, IValue k2, Set<IValue> s2, IValue commonValue) {
        Element elmCurr = this.mReport.addEntry(true, "overlappingSets", "commonValue", commonValue.toString());
        this.reportSet(k1, s1);
        this.reportSet(k2, s2);
        this.mReport.resetCurrent(elmCurr);
    }

    private void reportSet(IValue key, Set<IValue> set) {
        Element elmCurr = this.mReport.addEntry(true, "set", "forValue", key.toString());
        for (IValue v : set) {
            this.mReport.addEntry(false, "e", "v", v.toString());
        }
        this.mReport.resetCurrent(elmCurr);
    }
}

