/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.LexicalClueExtractor;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;

public class DataItemExtension {
    private static final float Sample_Value_Percent = SmdConfig.getInstance().getValue("uniqueValuesSample", "sampleRatio", 0.1f);
    private static final int Sample_Value_Min_Size = SmdConfig.getInstance().getValue("uniqueValuesSample", "lowerLimit", 50);
    private static final int Sample_Value_Max_Size = SmdConfig.getInstance().getValue("uniqueValuesSample", "upperLimit", 200);
    private IDataItem mDataItem;
    private short mDataItemIndex;
    private List<String> mNameLemmas = null;
    private List<Candidate> mCandidates = new ArrayList<Candidate>(3);
    private List<IValue> mDataSample = null;

    public DataItemExtension(IDataItem di, short idxDI) {
        this.mDataItem = di;
        this.mDataItemIndex = idxDI;
    }

    public IDataItem getDataItem() {
        return this.mDataItem;
    }

    public short getDataItemIndex() {
        return this.mDataItemIndex;
    }

    public void addCandidate(ActivationSpread acs, Float sigMatchStrength) {
        Concept[] concepts = acs.getConcepts();
        Concept con = concepts[0];
        for (Candidate c : this.mCandidates) {
            if (!c.getConcept().equals(con)) continue;
            return;
        }
        this.mCandidates.add(new Candidate(con, sigMatchStrength.floatValue()));
    }

    public List<IValue> getSampleDataPoints() {
        if (this.mDataSample == null) {
            this.fetchSampleDataPoints();
        }
        return this.mDataSample;
    }

    List<Candidate> getCandidates() {
        return this.mCandidates;
    }

    List<String> getNameLemmas(LexicalClueExtractor clueExtractor) {
        if (this.mNameLemmas == null) {
            this.mNameLemmas = clueExtractor.identifyClues(this.mDataItem.getName());
        }
        return this.mNameLemmas;
    }

    public List<String> getNameLemmas() {
        ToolBox.Assert(this.mNameLemmas != null, "Name lemmas must be already populated by now!");
        return this.mNameLemmas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSampleDataPoints() {
        int sampleSize = (int)((float)this.mDataItem.getStats().distinctCount() * Sample_Value_Percent);
        if (sampleSize < Sample_Value_Min_Size) {
            sampleSize = Sample_Value_Min_Size;
        } else if (sampleSize > Sample_Value_Max_Size) {
            sampleSize = Sample_Value_Max_Size;
        }
        this.mDataSample = new ArrayList<IValue>(sampleSize);
        IValueIterator valueIter = this.mDataItem.fetchUniqueValues((long)sampleSize);
        try {
            while (valueIter.hasNext() && this.mDataSample.size() < sampleSize) {
                IValue v = valueIter.next();
                if (v.isNull() || v.isError()) continue;
                this.mDataSample.add(v);
            }
        }
        finally {
            valueIter.close();
        }
    }
}

