/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Element;

class DataItemPartition {
    private String mToken;
    private List<DataItemExtension> mDItems = new ArrayList<DataItemExtension>(2);
    private long mMaxDistCount = 0L;
    private DataItemExtension mIdentifierItem;
    private List<DataItemPartition> mChildren = null;

    static List<DataItemPartition> partition(AnalysisReport aReport, List<DataItemExtension> dixs) {
        DataItemPartition rootPart = new DataItemPartition(null);
        for (DataItemExtension dix : dixs) {
            List<String> tokens = dix.getNameLemmas();
            ToolBox.Assert(tokens.size() > 0, "Expecting at least one lemma for dataItem:", dix.getDataItem().getName());
            rootPart.partitionItem(dix, tokens, 0);
        }
        List<DataItemPartition> partitions = DataItemPartition.flattenNestedPartitions(rootPart);
        int pItemsSize = 0;
        for (DataItemPartition part : partitions) {
            pItemsSize += part.mDItems.size();
        }
        ToolBox.Assert(dixs.size() == pItemsSize, "The number of partitioned items must match initial number of items:", Integer.toString(dixs.size()));
        return partitions;
    }

    DataItemPartition(String token) {
        this.mToken = token;
    }

    List<DataItemExtension> getDataItems() {
        return this.mDItems;
    }

    String getToken() {
        return this.mToken;
    }

    long getMaxDistCount() {
        return this.mMaxDistCount;
    }

    void partitionItem(DataItemExtension dix, List<String> tokens, int idxCurr) {
        String currToken;
        if (idxCurr + 1 >= tokens.size()) {
            this.addDataItem(dix);
            return;
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<DataItemPartition>();
        }
        ToolBox.Assert((currToken = tokens.get(idxCurr)) != null && currToken.length() > 0, "Expecting a valid, non-null token for index:", Integer.toString(idxCurr));
        int idxNext = idxCurr + 1;
        for (DataItemPartition subPart : this.mChildren) {
            if (!subPart.mToken.equals(currToken)) continue;
            subPart.partitionItem(dix, tokens, idxNext);
            return;
        }
        DataItemPartition subPart = new DataItemPartition(currToken);
        this.mChildren.add(subPart);
        subPart.partitionItem(dix, tokens, idxNext);
    }

    void addDataItem(DataItemExtension dix) {
        this.mDItems.add(dix);
        long dist = dix.getDataItem().getStats().distinctCount();
        if (dist > this.mMaxDistCount) {
            this.mMaxDistCount = dist;
        }
    }

    void moveItemsFrom(DataItemPartition source) {
        for (DataItemExtension dix : source.mDItems) {
            this.addDataItem(dix);
            this.mIdentifierItem = null;
        }
        source.reset();
    }

    private void reset() {
        this.mToken = null;
        this.mDItems.clear();
        this.mMaxDistCount = 0L;
        this.mIdentifierItem = null;
    }

    DataItemExtension getIdentifierItem() {
        if (this.mIdentifierItem == null) {
            for (DataItemExtension dix : this.mDItems) {
                for (Candidate c : dix.getCandidates()) {
                    if (!"cIdentifier".equals(c.getConcept().getName())) continue;
                    if (this.mIdentifierItem == null) {
                        this.mIdentifierItem = dix;
                        continue;
                    }
                    this.mIdentifierItem = DataItemPartition.betterIdentifier(this.mIdentifierItem, dix);
                }
            }
            if (this.mIdentifierItem != null) {
                return this.mIdentifierItem;
            }
            for (DataItemExtension dix : this.mDItems) {
                if (this.mIdentifierItem == null) {
                    this.mIdentifierItem = dix;
                    continue;
                }
                this.mIdentifierItem = DataItemPartition.betterIdentifier(this.mIdentifierItem, dix);
            }
        }
        return this.mIdentifierItem;
    }

    static DataItemExtension betterIdentifier(DataItemExtension dixOne, DataItemExtension dixTwo) {
        IDataItem diOne = dixOne.getDataItem();
        IDataItem diTwo = dixTwo.getDataItem();
        if (diOne.getStats().distinctCount() > diTwo.getStats().distinctCount()) {
            return dixOne;
        }
        if (diOne.getStats().distinctCount() < diTwo.getStats().distinctCount()) {
            return dixTwo;
        }
        if (diOne.getStats().density() > diTwo.getStats().density()) {
            return dixOne;
        }
        if (diOne.getStats().density() < diTwo.getStats().density()) {
            return dixTwo;
        }
        if (diOne.getDataType().isExactNumeric() && !diTwo.getDataType().isExactNumeric()) {
            return dixOne;
        }
        if (!diOne.getDataType().isExactNumeric() && diTwo.getDataType().isExactNumeric()) {
            return dixTwo;
        }
        return dixOne;
    }

    private static List<DataItemPartition> flattenNestedPartitions(DataItemPartition rootPart) {
        while (rootPart.mDItems.isEmpty() && rootPart.mChildren != null && rootPart.mChildren.size() == 1) {
            rootPart = rootPart.mChildren.get(0);
        }
        ArrayList<DataItemPartition> flatList = new ArrayList<DataItemPartition>();
        for (DataItemExtension dix : rootPart.mDItems) {
            DataItemPartition newPart = new DataItemPartition(dix.getDataItem().getName());
            flatList.add(newPart);
            newPart.addDataItem(dix);
        }
        if (rootPart.mChildren == null) {
            return flatList;
        }
        for (DataItemPartition subPart : rootPart.mChildren) {
            ArrayList<DataItemExtension> dItems = new ArrayList<DataItemExtension>();
            DataItemPartition.collectPartitionItems(dItems, subPart);
            if (dItems.isEmpty()) continue;
            DataItemPartition newPart = new DataItemPartition(subPart.mToken);
            flatList.add(newPart);
            for (DataItemExtension dix : dItems) {
                newPart.addDataItem(dix);
            }
        }
        return flatList;
    }

    private static void collectPartitionItems(List<DataItemExtension> dItems, DataItemPartition part) {
        dItems.addAll(part.mDItems);
        if (part.mChildren == null) {
            return;
        }
        for (DataItemPartition subPart : part.mChildren) {
            DataItemPartition.collectPartitionItems(dItems, subPart);
        }
    }

    static void reportPartition(AnalysisReport aReport, DataItemPartition aPartition) {
        Element elmCurr = aReport.addEntry(true, "partition", "name", aPartition.mToken, "maxDistCount", Long.toString(aPartition.mMaxDistCount));
        for (DataItemExtension dix : aPartition.mDItems) {
            IDataItem di = dix.getDataItem();
            IDataItemStats stats = di.getStats();
            aReport.addEntry(false, "item", "name", di.getName(), "dataType", di.getDataType().toString(), "density", Float.toString(stats.density()), "numValues", Long.toString(stats.count()), "numDistinctValues", Long.toString(stats.distinctCount()));
        }
        if (aPartition.mChildren != null) {
            for (DataItemPartition sp : aPartition.mChildren) {
                DataItemPartition.reportPartition(aReport, sp);
            }
        }
        aReport.resetCurrent(elmCurr);
    }

    static void reportPartitions(AnalysisReport aReport, List<DataItemPartition> partitions) {
        Element elmCurr = aReport.addEntry(true, "partitions", new String[0]);
        for (DataItemPartition p : partitions) {
            DataItemPartition.reportPartition(aReport, p);
        }
        aReport.resetCurrent(elmCurr);
    }

    static class CardinalityComparator
    implements Comparator<DataItemPartition> {
        CardinalityComparator() {
        }

        @Override
        public int compare(DataItemPartition p1, DataItemPartition p2) {
            if (p1.mMaxDistCount < p2.mMaxDistCount) {
                return -1;
            }
            if (p1.mMaxDistCount > p2.mMaxDistCount) {
                return 1;
            }
            return 0;
        }
    }
}

