/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.analyzer.DataCollector;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.DataHints;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;

class HierarchyDetector {
    static final int MIN_HIERARCHY_CARDINALITY = SmdConfig.getInstance().getValue("hierarchyDetection", "minCardinality", 3);
    static final float MIN_HIERARCHY_CARDINALITY_RATIO = SmdConfig.getInstance().getValue("hierarchyDetection", "minCardinalityRatio", 1.5f);
    private AnalysisReport mReport;
    private IAssociativeModel mModel;
    private Map<IConcept, List<INode>> mBusinessHrchyNodes = new HashMap<IConcept, List<INode>>();
    private List<INode> mGeoNodes = new ArrayList<INode>();
    private List<INode> mCategoryNodes = new ArrayList<INode>();

    HierarchyDetector(AnalysisReport report, IAssociativeModel model) {
        this.mReport = report;
        this.mModel = model;
    }

    void examineAsHierarchyCandidate(INode aNode) {
        Concept cNode = (Concept)aNode.getConcept();
        if (!cNode.isMetric()) {
            this.mCategoryNodes.add(aNode);
        }
        if (cNode.isSelfPartWhole()) {
            this.collectBusinessHierarchies(aNode);
        } else if (cNode.instanceOf(IConcept.EConceptClass.geographic)) {
            this.collectGeographicNodes(aNode);
        }
    }

    void makeKnownHierarchies() {
        this.makeEdgesBetweenBusinessHierarchies();
        this.makeEdgesBetweenGeographicNodes();
    }

    private void collectBusinessHierarchies(INode node) {
        List<INode> nodesBH = this.mBusinessHrchyNodes.get(node.getConcept());
        if (nodesBH == null) {
            nodesBH = new ArrayList<INode>(3);
            this.mBusinessHrchyNodes.put(node.getConcept(), nodesBH);
        }
        this.addToCountOrderedList(node, nodesBH);
    }

    private void addToCountOrderedList(INode aNode, List<INode> listAscending) {
        long nodeCard = NavigationHelper.getDefaultAttributeNode((INode)aNode).getDataItem().getStats().distinctCount();
        for (int idx = 0; idx < listAscending.size(); ++idx) {
            long aCard = NavigationHelper.getDefaultAttributeNode((INode)listAscending.get(idx)).getDataItem().getStats().distinctCount();
            if (nodeCard >= aCard) continue;
            listAscending.add(idx, aNode);
            return;
        }
        listAscending.add(aNode);
    }

    private void collectGeographicNodes(INode geoNode) {
        this.mGeoNodes.add(geoNode);
    }

    private void makeEdgesBetweenBusinessHierarchies() {
        DataCollector dc = new DataCollector(this.mReport);
        for (List<INode> nodesBH : this.mBusinessHrchyNodes.values()) {
            for (int idx = 0; idx < nodesBH.size() - 1; ++idx) {
                if (!this.hasOneManyAssociation(dc, nodesBH.get(idx), nodesBH.get(idx + 1))) continue;
                this.mModel.createEdge(nodesBH.get(idx), nodesBH.get(idx + 1), null, ECardinality.OneMany, true);
            }
        }
    }

    private boolean hasWholePartRels(INode node, boolean in) {
        Iterable eItr = in ? node.getInEdges(new String[0]) : node.getOutEdges(new String[0]);
        for (IEdge e : eItr) {
            if (!e.isWholePart()) continue;
            return true;
        }
        return false;
    }

    private void makeEdgesBetweenGeographicNodes() {
        if (this.mGeoNodes.isEmpty()) {
            return;
        }
        ArrayList<INode> knownGeoNodes = new ArrayList<INode>(this.mGeoNodes.size());
        ArrayList<GeoNodeHrchyEntry> unknownGeoHrchy = new ArrayList<GeoNodeHrchyEntry>(this.mGeoNodes.size());
        INode geoRoot = this.examineGeoNodes(unknownGeoHrchy, knownGeoNodes);
        ArrayList<GeoNodeHrchyEntry> knownGeoHrchy = new ArrayList<GeoNodeHrchyEntry>(this.mGeoNodes.size());
        if (geoRoot != null) {
            this.orderGeoNodesInHierarchy(geoRoot, knownGeoNodes, knownGeoHrchy);
        }
        DataCollector dc = new DataCollector(this.mReport);
        for (GeoNodeHrchyEntry entry : unknownGeoHrchy) {
            int idxBefore = this.locateNodeInHierarchy(entry, knownGeoHrchy);
            this.insertEdge(dc, entry, knownGeoHrchy, idxBefore);
        }
    }

    private INode examineGeoNodes(List<GeoNodeHrchyEntry> unknownGeoHrchy, List<INode> knownGeoNodes) {
        INode geoRoot = null;
        for (INode geoNode : this.mGeoNodes) {
            boolean hasInWPRels = this.hasWholePartRels(geoNode, true);
            boolean hasOutWPRels = this.hasWholePartRels(geoNode, false);
            if (!hasInWPRels && !hasOutWPRels) {
                this.findOrAddHrchyEntry(geoNode, unknownGeoHrchy);
                continue;
            }
            knownGeoNodes.add(geoNode);
            if (hasInWPRels || !hasOutWPRels) continue;
            geoRoot = geoNode;
        }
        return geoRoot;
    }

    private void orderGeoNodesInHierarchy(INode geoNode, List<INode> knownGeoNodes, List<GeoNodeHrchyEntry> knownGeoHrchy) {
        this.findOrAddHrchyEntry(geoNode, knownGeoHrchy);
        for (IEdge e : geoNode.getOutEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            INode endNode = e.getEnd();
            ToolBox.Assert(knownGeoNodes.contains(endNode), "This node is not part the geo. nodes we have visited!", endNode.getId());
            this.orderGeoNodesInHierarchy(endNode, knownGeoNodes, knownGeoHrchy);
        }
    }

    private void findOrAddHrchyEntry(INode geoNode, List<GeoNodeHrchyEntry> hrchyGeo) {
        GeoNodeHrchyEntry newEntry = new GeoNodeHrchyEntry(geoNode);
        hrchyGeo.add(newEntry);
    }

    private int locateNodeInHierarchy(GeoNodeHrchyEntry unknownEntry, List<GeoNodeHrchyEntry> knownGeoHrchy) {
        for (int idx = 0; idx < knownGeoHrchy.size(); ++idx) {
            GeoNodeHrchyEntry knownEntry = knownGeoHrchy.get(idx);
            if (knownEntry.mCard <= unknownEntry.mCard) continue;
            return idx;
        }
        return -1;
    }

    private void insertEdge(DataCollector dc, GeoNodeHrchyEntry unknownEntry, List<GeoNodeHrchyEntry> knownGeoHrchy, int insertIdx) {
        if (insertIdx == 0) {
            INode nodeFrom = unknownEntry.mNode;
            INode nodeTo = knownGeoHrchy.get(0).mNode;
            if (this.canGeoNodesBeLinked(dc, unknownEntry, knownGeoHrchy.get(0))) {
                this.mModel.createEdge(nodeFrom, nodeTo, null, ECardinality.OneMany, true);
            }
            knownGeoHrchy.add(0, unknownEntry);
        } else if (insertIdx == -1) {
            if (!knownGeoHrchy.isEmpty()) {
                INode nodeFrom = knownGeoHrchy.get(knownGeoHrchy.size() - 1).mNode;
                INode nodeTo = unknownEntry.mNode;
                if (this.canGeoNodesBeLinked(dc, knownGeoHrchy.get(knownGeoHrchy.size() - 1), unknownEntry)) {
                    this.mModel.createEdge(nodeFrom, nodeTo, null, ECardinality.OneMany, true);
                }
            }
            knownGeoHrchy.add(unknownEntry);
        } else {
            GeoNodeHrchyEntry refEntry = knownGeoHrchy.get(insertIdx);
            INode nodeFrom = refEntry.mNode;
            INode nodeTo = unknownEntry.mNode;
            if (this.canGeoNodesBeLinked(dc, refEntry, unknownEntry)) {
                this.createEdgeBeween(nodeFrom, nodeTo);
            }
            knownGeoHrchy.add(insertIdx, unknownEntry);
        }
    }

    private boolean canGeoNodesBeLinked(DataCollector dc, GeoNodeHrchyEntry geoFrom, GeoNodeHrchyEntry geoTo) {
        INode nodeFrom = geoFrom.mNode;
        INode nodeTo = geoTo.mNode;
        if (!geoFrom.mGenericGeoConcept && !geoTo.mGenericGeoConcept && nodeFrom.getConcept().equals(nodeTo.getConcept())) {
            return false;
        }
        return this.hasOneManyAssociation(dc, nodeFrom, nodeTo);
    }

    private boolean hasOneManyAssociation(DataCollector dc, INode ent1, INode ent2) {
        IDataItem item1 = NavigationHelper.getDefaultAttributeNode((INode)ent1).getDataItem();
        IDataItem item2 = NavigationHelper.getDefaultAttributeNode((INode)ent2).getDataItem();
        Element elmCurr = this.mReport.addEntry(true, "canFormHierarchy", "item1", item1.getName(), "numDistinctValues1", Long.toString(item1.getStats().distinctCount()), "item2", item2.getName(), "numDistinctValues2", Long.toString(item2.getStats().distinctCount()));
        boolean bRes = dc.doValuesHaveOneManyAssociation(item1, item2);
        this.mReport.resetCurrent(elmCurr);
        return bRes;
    }

    private void createEdgeBeween(INode refNode, INode unknownGeo) {
        IEdge existingEdge = null;
        for (IEdge e : refNode.getInEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            ToolBox.Assert(existingEdge == null, "Expecting at most one incoming whole-part relationship for node ", refNode.getId());
            existingEdge = e;
        }
        ToolBox.Assert(existingEdge != null, "Expecting one incoming whole-part relationship for node ", refNode.getId());
        if (!existingEdge.getStart().connectsWith(unknownGeo)) {
            this.mModel.createEdge(existingEdge.getStart(), unknownGeo, null, ECardinality.OneMany, true);
        }
        this.mModel.createEdge(unknownGeo, refNode, null, ECardinality.OneMany, true);
        this.mModel.deleteEdge(existingEdge.getId());
    }

    void makeGenericHierarchies() {
        if (this.mCategoryNodes.size() < 2) {
            return;
        }
        DataCollector dc = new DataCollector(this.mReport);
        long b4 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        Element elmCurr = this.mReport.addEntry(true, "makeGenericHierarchies", new String[0]);
        INode lastNode = this.mCategoryNodes.get(0);
        IDataItem lastDItem = HierarchyDetector.getIdentifierNode(this.mCategoryNodes.get(0)).getDataItem();
        for (int idx = 1; idx < this.mCategoryNodes.size(); ++idx) {
            IDataItem currDItem;
            INode currNode = this.mCategoryNodes.get(idx);
            if (this.canFormHierarchy(dc, lastNode, lastDItem, currNode, currDItem = HierarchyDetector.getIdentifierNode(this.mCategoryNodes.get(idx)).getDataItem())) {
                this.mModel.createEdge(lastNode, currNode, null, ECardinality.OneMany, true);
            }
            lastNode = currNode;
            lastDItem = currDItem;
        }
        this.mReport.addEntry(false, "performance", "time-ms", Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - b4));
        this.mReport.resetCurrent(elmCurr);
    }

    static INode getIdentifierNode(INode catNode) {
        INode nodeCaption = null;
        INode nodeOther = null;
        Iterable edges = catNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            if (e.isWholePart()) continue;
            INode nodeTo = e.getEnd();
            if ("cIdentifier".equals(nodeTo.getConcept().getName())) {
                return nodeTo;
            }
            if ("cCaption".equals(nodeTo.getConcept().getName())) {
                nodeCaption = nodeTo;
                continue;
            }
            nodeOther = nodeTo;
        }
        return nodeCaption != null ? nodeCaption : nodeOther;
    }

    private boolean canFormHierarchy(DataCollector dc, INode lastNode, IDataItem lastDItem, INode currNode, IDataItem currDItem) {
        boolean out = false;
        long lastNodeCard = lastDItem.getStats().distinctCount();
        long currNodeCard = currDItem.getStats().distinctCount();
        Element elmCurr = this.mReport.addEntry(true, "canFormHierarchy", "item1", lastDItem.getName(), "numDistinctValues1", Long.toString(lastNodeCard), "item2", currDItem.getName(), "numDistinctValues2", Long.toString(currNodeCard));
        float cardRatio = (float)currNodeCard / (float)lastNodeCard;
        if (lastDItem.getDataType().isTemporal() || currDItem.getDataType().isTemporal()) {
            this.mReport.addEntry(false, "negative", "reason", "excludeTemporalDataType");
            out = false;
        } else if (lastNodeCard < (long)MIN_HIERARCHY_CARDINALITY) {
            this.mReport.addEntry(false, "negative", "reason", "expectingUniqueValues", "min", Integer.toString(MIN_HIERARCHY_CARDINALITY));
            out = false;
        } else if (lastDItem.getStats().density() < DataHints.NotNull_DENSITY_THRESHOLD || currDItem.getStats().density() < DataHints.NotNull_DENSITY_THRESHOLD) {
            this.mReport.addEntry(false, "negative", "reason", "lowDensity");
            out = false;
        } else if (cardRatio < MIN_HIERARCHY_CARDINALITY_RATIO) {
            this.mReport.addEntry(false, "negative", "reason", "expectingCardinalityRatio", "min", Float.toString(MIN_HIERARCHY_CARDINALITY_RATIO));
            out = false;
        } else if (HierarchyDetector.hasParts(lastNode)) {
            this.mReport.addEntry(false, "negative", "reason", "ItemOneAlreadyHasPart");
            out = false;
        } else if (HierarchyDetector.isWhole(currNode)) {
            this.mReport.addEntry(false, "negative", "reason", "ItemTwoIsAlreadyWhole");
            out = false;
        } else {
            out = dc.doValuesHaveOneManyAssociation(lastDItem, currDItem);
        }
        this.mReport.resetCurrent(elmCurr);
        return out;
    }

    private static boolean hasParts(INode aNode) {
        Iterable edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            if (!e.isWholePart()) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhole(INode aNode) {
        for (IEdge e : aNode.getInEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            return true;
        }
        return false;
    }

    private static class GeoNodeHrchyEntry {
        private INode mNode = null;
        private long mCard = -1L;
        private boolean mGenericGeoConcept = false;

        GeoNodeHrchyEntry(INode aNode) {
            this.mNode = aNode;
            this.mCard = NavigationHelper.getDefaultAttributeNode((INode)aNode).getDataItem().getStats().distinctCount();
            this.mGenericGeoConcept = !((Concept)this.mNode.getConcept()).isInWholePartRelationship();
        }
    }
}

