/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataCollector;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.HierarchyDetector;
import com.ibm.cognos.smd.analyzer.LexicalAnalyzer;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.LinguisticTools;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;

class ItemGroupingDetector {
    private final Candidate DEFAULT_ATTRIBUTE_CANDIDATE;
    private LexicalAnalyzer mAnalyzer = null;
    private List<ItemCandidate> mItems = null;
    private List<PseudoNode> mGroupedItems = null;
    private DataCollector mDataCollector = null;
    private boolean mDisableDataDrivenAnalysis = false;

    ItemGroupingDetector(int num, LexicalAnalyzer az) {
        this.mAnalyzer = az;
        this.mItems = new ArrayList<ItemCandidate>(num);
        this.mGroupedItems = new ArrayList<PseudoNode>(num);
        this.mDataCollector = new DataCollector(this.mAnalyzer.getReport());
        ConceptInventory gKB = this.mAnalyzer.getConceptInventory();
        this.DEFAULT_ATTRIBUTE_CANDIDATE = new Candidate(gKB.getIdentifierAttribute());
        Boolean disDDA = (Boolean)this.mAnalyzer.getAnalysisOption(SmdReqContext.EOption.eDisableDataDrivenAnalyses);
        this.mDisableDataDrivenAnalysis = disDDA != null && disDDA.equals(Boolean.TRUE);
    }

    void addDataItemCandidate(DataItemExtension dix, Candidate c) {
        if (c.isAttribute()) {
            this.mItems.add(new ItemCandidate(dix, null, c));
        } else {
            this.mItems.add(new ItemCandidate(dix, c, null));
        }
    }

    void addDataItemCandidate(DataItemExtension dix, Candidate cBase, Candidate cAttr) {
        ToolBox.Assert(cBase != null && cAttr != null, "Expecting valid base/attribute concepts for item:", dix.getDataItem().getName());
        this.mItems.add(new ItemCandidate(dix, cBase, cAttr));
    }

    private PseudoMetricNode addPseudoMetricNode(ItemCandidate ic) {
        PseudoMetricNode pn = new PseudoMetricNode(ic.mBase, ic.mDix);
        this.mGroupedItems.add(pn);
        return pn;
    }

    private PseudoCategoryNode addPseudoCategoryNode(ItemCandidate ic) {
        PseudoCategoryNode pn = new PseudoCategoryNode(ic.mBase);
        this.mGroupedItems.add(pn);
        pn.addAttribute(ic.mInLineAttr, ic.mDix);
        return pn;
    }

    List<PseudoNode> groupItems() {
        long b4 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        Element elmCurr = this.mAnalyzer.getReport().addEntry(true, "groupDataItems", new String[0]);
        PseudoCategoryNode lastCategoryNode = null;
        for (int idx = 0; idx < this.mItems.size(); ++idx) {
            ItemCandidate ic = this.mItems.get(idx);
            if (ic.mBase != null && ic.mBase.isMetric()) {
                this.addPseudoMetricNode(ic);
                continue;
            }
            lastCategoryNode = this.groupItem(lastCategoryNode, idx);
        }
        for (PseudoNode pn : this.mGroupedItems) {
            if (!(pn instanceof PseudoCategoryNode)) continue;
            PseudoCategoryNode pcn = (PseudoCategoryNode)pn;
            for (int cIdx = 0; cIdx < pcn.mAttributeCandidates.size(); ++cIdx) {
                if (pcn.mAttributeCandidates.get(cIdx) != null) continue;
                pcn.mAttributeCandidates.set(cIdx, this.findBestCandidate(cIdx, pcn));
            }
        }
        this.mAnalyzer.getReport().addEntry(false, "performance", "time-ms", Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - b4));
        this.mAnalyzer.getReport().resetCurrent(elmCurr);
        return this.mGroupedItems;
    }

    private Candidate findBestCandidate(int idx, PseudoCategoryNode pcn) {
        if (pcn.mAttributeCandidates.size() == 1) {
            return this.DEFAULT_ATTRIBUTE_CANDIDATE;
        }
        ConceptInventory gKB = this.mAnalyzer.getConceptInventory();
        DataItemExtension dixID = pcn.findAttribute(gKB.getIdentifierAttribute());
        if (dixID == null) {
            return this.DEFAULT_ATTRIBUTE_CANDIDATE;
        }
        DataItemExtension dixCurr = (DataItemExtension)pcn.mAttributes.get(idx);
        if (pcn.findAttribute(gKB.getCaptionAttribute()) == null && dixCurr.getDataItem().getDataType().isString()) {
            long dcID = dixID.getDataItem().getStats().distinctCount();
            long dcCurr = dixCurr.getDataItem().getStats().distinctCount();
            if (dcID == 0L && dcCurr == 0L) {
                return new Candidate(gKB.getCaptionAttribute());
            }
            if (this.doItemsHaveCloseCardinalityRatio(dixID, dixCurr)) {
                return new Candidate(gKB.getCaptionAttribute());
            }
        }
        return new Candidate((Concept)gKB.getGenericAttribute());
    }

    private PseudoCategoryNode groupItem(PseudoCategoryNode lastCategoryNode, int idxCurr) {
        ItemCandidate currentIC = this.mItems.get(idxCurr);
        boolean bCanBeGrouped = false;
        if (lastCategoryNode != null) {
            Element elmCurr = this.mAnalyzer.getReport().addEntry(true, "canBeGroupedTogether", "item1", lastCategoryNode.getLastDataItem().getDataItem().getName(), "concept1", lastCategoryNode.getBaseConcept().getName(), "item2", currentIC.mDix.getDataItem().getName(), "concept2", currentIC.mBase != null ? currentIC.getBaseConcept().getName() : "", "attribute", currentIC.mInLineAttr != null ? currentIC.mInLineAttr.getConcept().getName() : "");
            bCanBeGrouped = this.canItemsBeGrouped(lastCategoryNode, currentIC, currentIC.mDix);
            this.mAnalyzer.getReport().resetCurrent(elmCurr);
        }
        if (bCanBeGrouped) {
            lastCategoryNode.addAttribute(currentIC.mInLineAttr, currentIC.mDix);
        } else if (currentIC.mInLineAttr != null) {
            boolean bWasGrouped = false;
            bWasGrouped = currentIC.mInLineAttr.getConcept().isCommonAttribute() ? this.findGroupingForCommonAttribute(currentIC, currentIC.mDix) : this.findGroupingForTypedAttribute(currentIC, currentIC.mDix);
            if (!bWasGrouped) {
                lastCategoryNode = this.addPseudoCategoryNode(currentIC);
            }
        } else {
            lastCategoryNode = this.addPseudoCategoryNode(currentIC);
        }
        return lastCategoryNode;
    }

    private boolean findGroupingForCommonAttribute(ItemCandidate currentIC, DataItemExtension dix) {
        PseudoCategoryNode candidateGrouping = null;
        candidateGrouping = dix.getNameLemmas().size() == 1 ? this.findDetailedCategoryForCommonAttribute(currentIC, dix) : this.findNameOverlappingCategoryForCommonAttribute(currentIC, dix);
        if (candidateGrouping == null) {
            return false;
        }
        Element elmCurr = this.mAnalyzer.getReport().addEntry(true, "canBeGroupedTogether", "item1", candidateGrouping.getFirstDataItem().getDataItem().getName(), "concept1", candidateGrouping.getBaseConcept().getName(), "item2", currentIC.mDix.getDataItem().getName(), "concept2", currentIC.mBase != null ? currentIC.getBaseConcept().getName() : "", "attribute", currentIC.mInLineAttr != null ? currentIC.mInLineAttr.getConcept().getName() : "");
        boolean bOneOne = this.mDataCollector.doValuesHaveOneOneAssociation(candidateGrouping.getFirstDataItem().getDataItem(), dix.getDataItem());
        if (bOneOne) {
            this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "definedAttribute");
            candidateGrouping.addAttribute(currentIC.mInLineAttr, currentIC.mDix);
        }
        this.mAnalyzer.getReport().resetCurrent(elmCurr);
        return bOneOne;
    }

    private PseudoCategoryNode findDetailedCategoryForCommonAttribute(ItemCandidate currentIC, DataItemExtension dix) {
        Candidate cAttr = currentIC.mInLineAttr;
        for (int idx = this.mGroupedItems.size() - 2; idx >= 0; --idx) {
            PseudoCategoryNode pcn;
            PseudoNode pn = this.mGroupedItems.get(idx);
            if (!(pn instanceof PseudoCategoryNode) || !(pcn = (PseudoCategoryNode)pn).mIsDetailedLevel || pcn.findAttribute(cAttr.getConcept()) != null) continue;
            return pcn;
        }
        return null;
    }

    private PseudoCategoryNode findNameOverlappingCategoryForCommonAttribute(ItemCandidate currentIC, DataItemExtension dix) {
        Candidate cAttr = currentIC.mInLineAttr;
        float maxOverlap = 0.0f;
        PseudoCategoryNode catWithMaxOverlap = null;
        for (int idx = this.mGroupedItems.size() - 2; idx >= 0; --idx) {
            PseudoNode pn = this.mGroupedItems.get(idx);
            if (!(pn instanceof PseudoCategoryNode)) continue;
            PseudoCategoryNode pcn = (PseudoCategoryNode)pn;
            DataItemExtension dixPcn = pcn.getFirstDataItem();
            int overlappingTokens = LinguisticTools.countCommonLemmas(dix.getNameLemmas(), dixPcn.getNameLemmas());
            float overlap = (float)overlappingTokens / ((float)(dix.getNameLemmas().size() + dixPcn.getNameLemmas().size()) / 2.0f);
            if (!(overlap > maxOverlap)) continue;
            maxOverlap = overlap;
            catWithMaxOverlap = pcn;
        }
        if (catWithMaxOverlap == null) {
            return null;
        }
        if (catWithMaxOverlap.findAttribute(cAttr.getConcept()) == null && catWithMaxOverlap.getBaseConcept().equals(currentIC.getBaseConcept()) && !this.hierarchyCandidate(currentIC.getBaseConcept(), catWithMaxOverlap.getFirstDataItem(), dix)) {
            return catWithMaxOverlap;
        }
        return null;
    }

    private boolean findGroupingForTypedAttribute(ItemCandidate currentIC, DataItemExtension dix) {
        Candidate cAttr = currentIC.mInLineAttr;
        PseudoCategoryNode candidateGrouping = null;
        for (int idx = this.mGroupedItems.size() - 2; idx >= 0; --idx) {
            PseudoCategoryNode pcn;
            PseudoNode pn = this.mGroupedItems.get(idx);
            if (!(pn instanceof PseudoCategoryNode) || !(pcn = (PseudoCategoryNode)pn).getBaseConcept().isRelatedTo(cAttr.getConcept()) || pcn.findAttribute(cAttr.getConcept()) != null) continue;
            candidateGrouping = pcn;
            break;
        }
        if (candidateGrouping == null) {
            return false;
        }
        Element elmCurr = this.mAnalyzer.getReport().addEntry(true, "canBeGroupedTogether", "item1", candidateGrouping.getFirstDataItem().getDataItem().getName(), "concept1", candidateGrouping.getBaseConcept().getName(), "item2", currentIC.mDix.getDataItem().getName(), "concept2", currentIC.mBase != null ? currentIC.getBaseConcept().getName() : "", "attribute", currentIC.mInLineAttr != null ? currentIC.mInLineAttr.getConcept().getName() : "");
        DataItemExtension candidGroupId = candidateGrouping.findAttribute(this.mAnalyzer.getConceptInventory().getIdentifierAttribute());
        boolean bOneOne = true;
        if (candidGroupId != null) {
            bOneOne = this.mDataCollector.doValuesHaveOneOneAssociation(candidGroupId.getDataItem(), dix.getDataItem());
        }
        if (bOneOne) {
            this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "definedAttribute");
            candidateGrouping.addAttribute(currentIC.mInLineAttr, currentIC.mDix);
        }
        this.mAnalyzer.getReport().resetCurrent(elmCurr);
        return bOneOne;
    }

    private boolean canItemsBeGrouped(PseudoCategoryNode lastCategoryNode, ItemCandidate currentIC, DataItemExtension dix) {
        ConceptInventory gKB = this.mAnalyzer.getConceptInventory();
        Candidate cBase = currentIC.mBase;
        Candidate cAttr = currentIC.mInLineAttr;
        DataItemExtension lastCatgDix = lastCategoryNode.getFirstDataItem();
        if (lastCategoryNode.getBaseConcept().isTemporal()) {
            this.mAnalyzer.getReport().addEntry(false, "negative", "rule", "noAttributeForTemporal");
            return false;
        }
        if (cAttr != null && lastCategoryNode.getBaseConcept().isRelatedTo(cAttr.getConcept())) {
            if (lastCategoryNode.findAttribute(cAttr.getConcept()) != null) {
                this.mAnalyzer.getReport().addEntry(false, "negative", "rule", "duplicateAttribute");
                return false;
            }
            if (!cAttr.getConcept().isCommonAttribute()) {
                this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "definedAttribute");
                return true;
            }
            if (cBase.getConcept().equals(lastCategoryNode.getBaseConcept()) && !this.hierarchyCandidate(cBase.getConcept(), lastCatgDix, dix) || gKB.getGenericCategory().equals(cBase.getConcept()) || gKB.getGenericNominal().equals(cBase.getConcept())) {
                return this.canCommonAttribuedBeGrouped(lastCategoryNode.getLastDataItem(), dix);
            }
        } else if (cAttr == null) {
            if (this.mDisableDataDrivenAnalysis) {
                if (!lastCategoryNode.containsUnknownAttribute() && cBase.getConcept().equals(lastCategoryNode.getBaseConcept()) && !this.hierarchyCandidate(cBase.getConcept(), lastCategoryNode.getFirstDataItem(), dix) && this.nameOverlaps(lastCategoryNode.getFirstDataItem(), dix)) {
                    return this.canItemsBeGroupedGenericly(lastCategoryNode.getFirstDataItem(), dix);
                }
            } else {
                if (cBase.getConcept().equals(lastCategoryNode.getBaseConcept()) && !this.hierarchyCandidate(cBase.getConcept(), lastCategoryNode.getFirstDataItem(), dix)) {
                    return this.canItemsBeGroupedGenericly(lastCategoryNode.getFirstDataItem(), dix);
                }
                if (gKB.getGenericCategory().equals(lastCategoryNode.getBaseConcept()) && gKB.getGenericNominal().equals(cBase.getConcept())) {
                    return this.canItemsBeGroupedGenericly(lastCategoryNode.getFirstDataItem(), dix);
                }
                if (this.canBeInterpretedAsAttribute(lastCategoryNode, cBase)) {
                    this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "definedConceptForDetailedCategory");
                    currentIC.mInLineAttr = cBase;
                    return true;
                }
            }
        }
        this.mAnalyzer.getReport().addEntry(false, "negative", "rule", "conceptMismatch");
        return false;
    }

    private boolean hierarchyCandidate(Concept commonConcept, DataItemExtension dixOne, DataItemExtension dixTwo) {
        long cardTwo;
        if (!commonConcept.isSelfPartWhole()) {
            return false;
        }
        long cardOne = dixOne.getDataItem().getStats().distinctCount();
        float cardRatio = (float)Math.max(cardOne, cardTwo = dixTwo.getDataItem().getStats().distinctCount()) / (float)Math.min(cardOne, cardTwo);
        if (cardRatio < HierarchyDetector.MIN_HIERARCHY_CARDINALITY_RATIO) {
            return false;
        }
        boolean goodHierarchy = false;
        goodHierarchy = cardOne < cardTwo ? this.mDataCollector.doValuesHaveOneManyAssociation(dixOne.getDataItem(), dixTwo.getDataItem()) : this.mDataCollector.doValuesHaveOneManyAssociation(dixTwo.getDataItem(), dixOne.getDataItem());
        return goodHierarchy;
    }

    private boolean doItemsHaveCloseCardinalityRatio(DataItemExtension dixOne, DataItemExtension dixTwo) {
        long dcTwo;
        long dcOne = dixOne.getDataItem().getStats().distinctCount();
        float ratioCaptionID = (float)Math.min(dcOne, dcTwo = dixTwo.getDataItem().getStats().distinctCount()) / (float)Math.max(dcOne, dcTwo);
        return ratioCaptionID > 0.8f;
    }

    private boolean canBeInterpretedAsAttribute(PseudoCategoryNode lastCategoryNode, Candidate cBase) {
        if (!lastCategoryNode.mIsDetailedLevel) {
            return false;
        }
        IRelation toRel = lastCategoryNode.getBaseConcept().findRelationTo(cBase.getConcept());
        if (toRel == null) {
            return false;
        }
        return toRel.getCardinality() == ECardinality.OneOne || toRel.getCardinality() == ECardinality.ManyOne;
    }

    private boolean canCommonAttribuedBeGrouped(DataItemExtension dixOne, DataItemExtension dixTwo) {
        IDataItemStats statsOne = dixOne.getDataItem().getStats();
        IDataItemStats statsTwo = dixTwo.getDataItem().getStats();
        if (this.nameOverlaps(dixOne, dixTwo) && (this.doItemsHaveCloseCardinalityRatio(dixOne, dixTwo) || statsOne.distinctCount() < 2L || statsTwo.density() == 0.0f)) {
            this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "nameOverlap");
            return true;
        }
        return this.mDataCollector.doValuesHaveOneOneAssociation(dixOne.getDataItem(), dixTwo.getDataItem());
    }

    private boolean canItemsBeGroupedGenericly(DataItemExtension dixOne, DataItemExtension dixTwo) {
        IDataItemStats statsOne = dixOne.getDataItem().getStats();
        IDataItemStats statsTwo = dixTwo.getDataItem().getStats();
        if (statsOne.distinctCount() < 2L || statsTwo.density() == 0.0f) {
            if (this.nameOverlaps(dixOne, dixTwo)) {
                this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "nameOverlap");
                return true;
            }
        } else {
            if (statsOne.count() > statsOne.distinctCount()) {
                return this.mDataCollector.doValuesHaveOneOneAssociation(dixOne.getDataItem(), dixTwo.getDataItem());
            }
            if (statsOne.distinctCount() == statsTwo.distinctCount()) {
                this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "matchingCardinality");
                return true;
            }
            if (this.nameOverlaps(dixOne, dixTwo)) {
                this.mAnalyzer.getReport().addEntry(false, "affirmative", "rule", "nameOverlap");
                return true;
            }
        }
        return false;
    }

    private boolean nameOverlaps(DataItemExtension dixOne, DataItemExtension dixTwo) {
        int overlappingTokens = LinguisticTools.countCommonLemmas(dixOne.getNameLemmas(), dixTwo.getNameLemmas());
        float overlap = (float)overlappingTokens / ((float)(dixOne.getNameLemmas().size() + dixTwo.getNameLemmas().size()) / 2.0f);
        return (double)overlap >= 0.5;
    }

    static class PseudoMetricNode
    extends PseudoNode {
        private DataItemExtension mIDataItem;

        PseudoMetricNode(Candidate cBase, DataItemExtension dix) {
            super(cBase);
            this.mIDataItem = dix;
        }

        IDataItem getDataItem() {
            return this.mIDataItem.getDataItem();
        }
    }

    static class PseudoCategoryNode
    extends PseudoNode {
        private List<DataItemExtension> mAttributes = new ArrayList<DataItemExtension>(3);
        private List<Candidate> mAttributeCandidates = new ArrayList<Candidate>(3);
        private boolean mIsDetailedLevel = false;

        PseudoCategoryNode(Candidate cBase) {
            super(cBase);
        }

        List<DataItemExtension> getAttributes() {
            return this.mAttributes;
        }

        List<Candidate> getAttributeCandidates() {
            return this.mAttributeCandidates;
        }

        void addAttribute(Candidate cAttr, DataItemExtension dix) {
            this.mAttributes.add(dix);
            this.mAttributeCandidates.add(cAttr);
            if (this.mAttributes.size() == 1) {
                IDataItemStats stats = dix.getDataItem().getStats();
                this.mIsDetailedLevel = stats.density() > 0.9f && stats.count() == stats.distinctCount();
            }
        }

        DataItemExtension findAttribute(Concept cAttr) {
            for (int idx = 0; idx < this.mAttributeCandidates.size(); ++idx) {
                if (this.mAttributeCandidates.get(idx) == null || !cAttr.is(this.mAttributeCandidates.get(idx).getConcept())) continue;
                return this.mAttributes.get(idx);
            }
            return null;
        }

        boolean containsUnknownAttribute() {
            for (Candidate c : this.mAttributeCandidates) {
                if (c != null) continue;
                return true;
            }
            return false;
        }

        DataItemExtension getLastDataItem() {
            int s = this.mAttributes.size();
            if (s == 0) {
                return null;
            }
            return this.mAttributes.get(s - 1);
        }

        DataItemExtension getFirstDataItem() {
            int s = this.mAttributes.size();
            if (s == 0) {
                return null;
            }
            return this.mAttributes.get(0);
        }
    }

    static class PseudoNode {
        private Candidate mBase;

        Concept getBaseConcept() {
            return this.mBase.getConcept();
        }

        float getBaseOverallConfidence() {
            return this.mBase.getOverallConfidence();
        }

        protected PseudoNode(Candidate can) {
            this.mBase = can;
        }
    }

    private static class ItemCandidate {
        private DataItemExtension mDix;
        private Candidate mBase;
        private Candidate mInLineAttr;

        ItemCandidate(DataItemExtension dix, Candidate base, Candidate inLineAttribute) {
            this.mDix = dix;
            this.mBase = base;
            this.mInLineAttr = inLineAttribute;
        }

        Concept getBaseConcept() {
            return this.mBase.getConcept();
        }
    }
}

