/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.smd.SmartMetadataImpl;
import com.ibm.cognos.smd.analyzer.AnalyzerBase;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataAnalyzer;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.ModelGenerator;
import com.ibm.cognos.smd.analyzer.NominalDetector;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.utilities.LinguisticTools;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

class LexicalAnalyzer
extends AnalyzerBase {
    private List<ActivationSpread> mContainerActivations = null;
    private List<String> mContainnerNameClues = null;

    public LexicalAnalyzer(SmartMetadataImpl smd, IAssociativeModel model, SmdReqContext reqContext) {
        super(smd, model, reqContext);
    }

    @Override
    void establishContext(IDataContainer dc) {
        IValue docPath;
        if (!dc.equals(this.getModel().getRootContainer())) {
            this.mContainnerNameClues = this.getClueExtractor().identifyClues(dc.getId().toString());
            this.mContainerActivations = this.getClueInventory().getActivationFor(this.mContainnerNameClues, null);
            this.getContext().addActivation(dc.getId().toString(), this.mContainerActivations);
        }
        if (null != (docPath = dc.getProperty("documentPath")) && docPath.isOK()) {
            List<String> stems = this.getClueExtractor().identifyClues(docPath.stringValue());
            this.getContext().addActivation(docPath.stringValue(), this.getClueInventory().getActivationFor(stems, null));
        }
        for (IDataContainer sc : dc.getChildren()) {
            this.establishContext(sc);
        }
        short idxDI = 0;
        for (IDataItem di : dc.getDataItems()) {
            this.establishContext(di, idxDI);
            idxDI = (short)(idxDI + 1);
        }
    }

    @Override
    void determineMetadata(IDataContainer dc) {
        for (IDataContainer sc : dc.getChildren()) {
            this.determineMetadata(sc);
        }
        if (dc.getDataItems().size() > 0) {
            ModelGenerator genModel = new ModelGenerator(this, this.getDItemExtensionsMap().size());
            for (IDataItem di : dc.getDataItems()) {
                Element elmCurr = this.reportDataItem(di);
                this.determineMetadata(genModel, dc, di);
                this.getReport().resetCurrent(elmCurr);
            }
            genModel.generate(dc);
        }
    }

    private void determineMetadata(ModelGenerator genModel, IDataContainer dc, IDataItem di) {
        DataItemExtension dix = this.findDataItemExtension(di, true);
        Candidate diBestCandidate = null;
        List<Candidate> candidates = dix.getCandidates();
        this.reportCandidates(candidates);
        DataAnalyzer analData = new DataAnalyzer(this, dix);
        boolean areCandidateRelated = this.handleAsConceptAttribute(genModel, analData, dc, dix, candidates);
        if (areCandidateRelated) {
            return;
        }
        diBestCandidate = analData.evaluateCandidates(this.getContext(), candidates);
        if (diBestCandidate != null) {
            if (diBestCandidate.isAttribute()) {
                Candidate cBase = this.findPossibleBaseCandidateForAttribute(analData, diBestCandidate, dix, true, false);
                genModel.addNodeForDataItem(dix, cBase, diBestCandidate);
            } else {
                genModel.addNodeForDataItem(dix, diBestCandidate);
            }
        } else {
            List<Concept> activeConcepts = this.getContext().getContext();
            Candidate c = analData.resolveBasedOnDataValues(activeConcepts);
            if (c != null) {
                genModel.addNodeForDataItem(dix, c);
            } else {
                genModel.addNodeForDataItem(dix, this.determineDefaultConcept(dix, null));
            }
        }
    }

    private boolean handleAsConceptAttribute(ModelGenerator genModel, DataAnalyzer analData, IDataContainer dc, DataItemExtension dix, List<Candidate> candidates) {
        ArrayList<Candidate> cCategories = new ArrayList<Candidate>(candidates.size() / 2);
        ArrayList<Candidate> cMetrics = new ArrayList<Candidate>(candidates.size() / 2);
        ArrayList<Candidate> cAttributes = new ArrayList<Candidate>(candidates.size() / 2);
        for (Candidate c : candidates) {
            if (c.isCategory()) {
                cCategories.add(c);
                continue;
            }
            if (c.isMetric()) {
                cMetrics.add(c);
                continue;
            }
            cAttributes.add(c);
        }
        if (cAttributes.isEmpty()) {
            return false;
        }
        Candidate cAttr = analData.evaluateCandidates(this.getContext(), cAttributes);
        if (cAttr == null) {
            return false;
        }
        Candidate cMetric = null;
        if (!cMetrics.isEmpty()) {
            cMetric = analData.evaluateCandidates(this.getContext(), cMetrics);
        }
        Candidate cBase = null;
        if (cCategories.isEmpty()) {
            cBase = this.findPossibleBaseCandidateForAttribute(analData, cAttr, dix, cMetric == null, cMetrics.isEmpty() && cCategories.isEmpty());
        } else {
            if (cCategories.size() == 1 && cMetric == null) {
                cBase = (Candidate)cCategories.get(0);
            } else {
                cBase = analData.evaluateCandidates(this.getContext(), cCategories);
                if (cBase == null && cCategories.size() == 1) {
                    cBase = this.evaluateBasedOnContainerClues(dc, dix, (Candidate)cCategories.get(0));
                }
            }
            if (cBase != null && !cBase.getConcept().isRelatedTo(cAttr.getConcept())) {
                cBase = null;
            }
        }
        if (cBase == null && cMetric == null) {
            return false;
        }
        if (cBase != null) {
            genModel.addNodeForDataItem(dix, cBase, cAttr);
            this.getReport().addEntry(false, "resolved", "as", cBase.getConcept().getName(), "rule", "categoryAttribute");
        } else {
            genModel.addNodeForDataItem(dix, cMetric);
            this.getReport().addEntry(false, "resolved", "as", cMetric.getConcept().getName(), "rule", "metric");
        }
        return true;
    }

    private Candidate evaluateBasedOnContainerClues(IDataContainer dc, DataItemExtension dix, Candidate orgCandidate) {
        if (dix.getDataItemIndex() != 0) {
            return null;
        }
        int overlappingTokens = LinguisticTools.countCommonLemmas(this.mContainnerNameClues, dix.getNameLemmas());
        if (overlappingTokens == 0) {
            return null;
        }
        for (ActivationSpread as : this.mContainerActivations) {
            if (!orgCandidate.getConcept().equals(as.getConcepts()[0])) continue;
            return orgCandidate;
        }
        return null;
    }

    private Candidate findPossibleBaseCandidateForAttribute(DataAnalyzer analData, Candidate cAttr, DataItemExtension dix, boolean bApplyDefault, boolean bNoEvaluate) {
        IConcept related = null;
        List<IRelation> cInRels = cAttr.getConcept().getInRelations();
        if (cInRels.size() > 0) {
            related = cInRels.get(0).getFromEnd();
        }
        Candidate outCand = new Candidate((Concept)related);
        if (bNoEvaluate && !cAttr.getConcept().isCommonAttribute() && related != null && !related.equals(this.getConceptInventory().getGenericCategory())) {
            if (NominalDetector.isBestRepresentedAsNominalCategory(this.getConceptInventory(), outCand, dix.getDataItem())) {
                outCand = new Candidate((Concept)this.getConceptInventory().getGenericNominal());
            }
            return outCand;
        }
        outCand = analData.evaluateCandidate(this.getContext(), outCand);
        if (outCand != null) {
            if (NominalDetector.isBestRepresentedAsNominalCategory(this.getConceptInventory(), outCand, dix.getDataItem())) {
                outCand = new Candidate((Concept)this.getConceptInventory().getGenericNominal());
            }
            return outCand;
        }
        if (bApplyDefault) {
            outCand = this.determineDefaultConcept(dix, cAttr);
        }
        return outCand;
    }
}

