/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.analyzer.LexicalInfo;
import com.ibm.cognos.smd.kb.LexicalClueInventory;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class LexicalClueExtractor {
    private final LexicalClueInventory mClueInventory;
    private final LexicalInfo mLexicalInfo;
    private final Set<String> mLexicalClues;
    private final AnalysisReport mReport;

    public LexicalClueExtractor(LexicalClueInventory inventory, AnalysisReport hlprReport) {
        this.mClueInventory = inventory;
        this.mLexicalInfo = inventory.getLexicalInfo();
        this.mLexicalClues = inventory.getLexicalClues();
        this.mReport = hlprReport;
    }

    public List<String> identifyClues(String text) {
        String[] tokens = this.tokenize(text);
        ArrayList<String> out = new ArrayList<String>(tokens.length);
        for (String t : tokens) {
            if (!ToolBox.hasStringValue(t)) continue;
            this.advancedTokenize(t, out);
        }
        if (tokens.length == 1 || this.mClueInventory.requiresTokenBasedSearch()) {
            this.searchBasedTokenize(text, out);
        }
        if (out.isEmpty()) {
            out.add(text);
        }
        this.reportCluesFound(text, out);
        return out;
    }

    public List<String> getPossibleStems(String aWord) {
        String sUpper = aWord.toUpperCase(this.mClueInventory.getLocale());
        List<String> stems = this.collectPossibleWordStems(sUpper);
        for (String s : stems) {
            this.mReport.addEntry(false, "replaceClue", "original", aWord, "wordStem", s);
        }
        return stems;
    }

    private void advancedTokenize(String text, List<String> clues) {
        boolean isCaseLow = true;
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < text.length(); ++idx) {
            char c = text.charAt(idx);
            int ssIdx = this.mLexicalInfo.getEmbeddedSymbols().indexOf(Character.toString(c));
            if (ssIdx >= 0) {
                this.lemmatizeAndaddToList(sb, clues);
                clues.add(this.mLexicalInfo.getEmbeddedSymbols().get(ssIdx));
                continue;
            }
            if (sb.length() == 0) {
                sb.append(c);
                continue;
            }
            if (sb.length() == 1) {
                isCaseLow = Character.isLowerCase(c);
                sb.append(c);
                continue;
            }
            if (isCaseLow ^ Character.isLowerCase(c)) {
                this.lemmatizeAndaddToList(sb, clues);
            }
            sb.append(c);
        }
        this.lemmatizeAndaddToList(sb, clues);
    }

    private void searchBasedTokenize(String text, List<String> clues) {
        Set<String> distinctKeywords = this.mClueInventory.getSearchEngine().searchDistinctNonOverlap(text);
        if (this.mClueInventory.isForAsianLanguage()) {
            String[] sortedKeywords;
            for (String kw : sortedKeywords = this.sortKeywords(text, distinctKeywords)) {
                if (clues.contains(kw)) continue;
                clues.add(kw);
            }
        } else {
            for (String kw : distinctKeywords) {
                int kwIdx;
                if (clues.contains(kw) || (kwIdx = this.keywordAppearsAtWordBoundaries(kw, clues)) < 0) continue;
                clues.add(kwIdx + 1, kw);
            }
        }
    }

    private String[] sortKeywords(String text, Set<String> distinctKeywords) {
        String[] sortedKeywords = new String[distinctKeywords.size()];
        distinctKeywords.toArray(sortedKeywords);
        Arrays.sort(sortedKeywords, new KeywordComparator(this.mClueInventory.getLocale(), text));
        return sortedKeywords;
    }

    private int keywordAppearsAtWordBoundaries(String kw, List<String> clues) {
        int kwLen = kw.length();
        for (int idx = 0; idx < clues.size(); ++idx) {
            String aClue = clues.get(idx);
            int clueLen = aClue.length();
            if (kwLen >= clueLen) continue;
            if (aClue.substring(0, kwLen).equals(kw) || aClue.substring(clueLen - kwLen).equals(kw)) {
                return idx;
            }
            List<String> inflated = this.getInflatedForms(kw);
            for (String anInflated : inflated) {
                kwLen = anInflated.length();
                if (kwLen >= clueLen || !aClue.substring(0, kwLen).equals(anInflated) && !aClue.substring(clueLen - kwLen).equals(anInflated)) continue;
                return idx;
            }
        }
        return -1;
    }

    private void lemmatizeAndaddToList(StringBuilder sb, List<String> tokens) {
        if (sb.length() != 0) {
            String lemma = this.lemmatize(sb.toString());
            tokens.add(lemma);
            sb.setLength(0);
        }
    }

    private String lemmatize(String term) {
        String sUpper = term.toUpperCase(this.mClueInventory.getLocale());
        if (this.mLexicalClues.contains(sUpper)) {
            return sUpper;
        }
        String stem = null;
        for (String s : this.collectPossibleWordStems(sUpper)) {
            if (this.mClueInventory.isAbbreviation(s) || !this.mLexicalClues.contains(s)) continue;
            stem = s;
            break;
        }
        if (stem != null) {
            this.mReport.addEntry(false, "replaceClue", "original", term, "wordStem", stem);
            return stem;
        }
        return sUpper;
    }

    private List<String> collectPossibleWordStems(String word) {
        String stem;
        ArrayList<String> out = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.mLexicalInfo.getSpecialReplacements().entrySet()) {
            if (!word.equals(e.getKey())) continue;
            out.add(e.getValue());
        }
        for (Map.Entry<String, String> e : this.mLexicalInfo.getPrefixReplacement().entrySet()) {
            if (!word.startsWith(e.getKey())) continue;
            stem = this.replacePrefix(word, e.getKey(), e.getValue());
            out.add(stem);
        }
        for (Map.Entry<String, String> e : this.mLexicalInfo.getInfixReplacement().entrySet()) {
            if (word.indexOf(e.getKey()) < 0) continue;
            stem = word.replace(e.getKey(), e.getValue());
            out.add(stem);
        }
        for (Map.Entry<String, String> e : this.mLexicalInfo.getSuffixReplacement().entrySet()) {
            if (!word.endsWith(e.getKey())) continue;
            stem = this.replaceSuffix(word, e.getKey(), e.getValue());
            out.add(stem);
        }
        return out;
    }

    private List<String> getInflatedForms(String stem) {
        ArrayList<String> inflatedForms = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.mLexicalInfo.getSpecialReplacements().entrySet()) {
            if (!stem.equals(e.getValue())) continue;
            inflatedForms.add(e.getKey());
            return inflatedForms;
        }
        for (Map.Entry<String, String> e : this.mLexicalInfo.getSuffixReplacement().entrySet()) {
            String derived;
            if (e.getValue() == null) {
                derived = stem.concat(e.getKey());
                inflatedForms.add(derived);
                continue;
            }
            if (!stem.endsWith(e.getValue())) continue;
            derived = this.replaceSuffix(stem, e.getValue(), e.getKey());
            inflatedForms.add(derived);
        }
        return inflatedForms;
    }

    private String replaceSuffix(String word, String suffix, String replace) {
        int lenWord = word.length();
        int lenSuffix = suffix.length();
        if (replace == null) {
            return word.substring(0, lenWord - lenSuffix);
        }
        StringBuilder sb = new StringBuilder(word.substring(0, lenWord - lenSuffix));
        sb.append(replace);
        return sb.toString();
    }

    private String replacePrefix(String word, String prefix, String replace) {
        int lenPrefix = prefix.length();
        if (replace == null) {
            return word.substring(lenPrefix);
        }
        StringBuilder sb = new StringBuilder(replace);
        sb.append(word.substring(lenPrefix));
        return sb.toString();
    }

    private void reportCluesFound(String text, List<String> clues) {
        if (!clues.isEmpty()) {
            Element elmTokens = this.mReport.addEntry(true, "identifiedClues", "label", text);
            for (String s : clues) {
                this.mReport.addText(s);
                this.mReport.addText("\t\t");
            }
            this.mReport.resetCurrent(elmTokens);
        }
    }

    private String[] tokenize(String text) {
        return text.split(this.mLexicalInfo.getDelimitingPattern());
    }

    private static class KeywordComparator
    implements Comparator<String> {
        private String mUpperText;

        KeywordComparator(Locale aLocale, String text) {
            this.mUpperText = text.toUpperCase(aLocale);
        }

        @Override
        public int compare(String kw1, String kw2) {
            int pos1 = this.mUpperText.indexOf(kw1);
            ToolBox.Assert(pos1 >= 0, "Unexpected token '", kw1, "' for initial text:", this.mUpperText);
            int pos2 = this.mUpperText.indexOf(kw2);
            ToolBox.Assert(pos2 >= 0, "Unexpected token '", kw2, "' for initial text:", this.mUpperText);
            return pos1 - pos2;
        }
    }
}

