/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NodeFilters;
import com.ibm.cognos.smd.SmartMetadataImpl;
import com.ibm.cognos.smd.analyzer.AnalyzerBase;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataAnalyzer;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

class LexicalDecorator
extends AnalyzerBase {
    public LexicalDecorator(SmartMetadataImpl smd, IAssociativeModel model, SmdReqContext reqContext) {
        super(smd, model, reqContext);
    }

    @Override
    void establishContext(IDataContainer dc) {
        List<String> stems = this.getClueExtractor().identifyClues(dc.getId().toString());
        this.getContext().addActivation(dc.getId().toString(), this.getClueInventory().getActivationFor(stems, null));
        IValue docPath = dc.getProperty("documentPath");
        if (null != docPath && docPath.isOK()) {
            stems = this.getClueExtractor().identifyClues(docPath.stringValue());
            this.getContext().addActivation(docPath.stringValue(), this.getClueInventory().getActivationFor(stems, null));
        }
        for (IDataContainer sc : dc.getChildren()) {
            this.establishContext(sc);
        }
        short idxDI = 0;
        for (INode n : dc.getNodes()) {
            IDataItem di;
            if (n.isMetric() && n.getDataItem() != null) {
                this.establishContext(n.getDataItem(), idxDI);
                idxDI = (short)(idxDI + 1);
                continue;
            }
            if (!n.isCategory() || (di = this.getDataItemForCategory(n)) == null) continue;
            this.establishContext(di, idxDI);
            idxDI = (short)(idxDI + 1);
        }
    }

    private IDataItem getDataItemForCategory(INode aNode) {
        IDataItem diFirst = null;
        IDataItem diCaption = null;
        Iterable edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            if (e.isWholePart() || !e.getEnd().isAttribute()) continue;
            INode nodeTo = e.getEnd();
            if ("cCaption".equals(nodeTo.getConcept().getName())) {
                diCaption = nodeTo.getDataItem();
                continue;
            }
            if ("cIdentifier".equals(nodeTo.getConcept().getName())) {
                return nodeTo.getDataItem();
            }
            if (diFirst != null) continue;
            diFirst = nodeTo.getDataItem();
        }
        if (diCaption != null) {
            return diCaption;
        }
        return diFirst;
    }

    @Override
    void determineMetadata(IDataContainer dc) {
        for (IDataContainer sc : dc.getChildren()) {
            this.determineMetadata(sc);
        }
        if (dc.getDataItems().size() > 0) {
            for (IDataItem di : dc.getDataItems()) {
                Concept canConcept;
                DataItemExtension dix = this.findDataItemExtension(di, false);
                if (dix == null) continue;
                Element elmCurr = this.reportDataItem(di);
                Candidate diBestCandidate = this.determineMetadata(dix);
                INode node = this.findNodeAssociatedWithDItem(di);
                IConcept nodeConcept = node.getConcept();
                if (!nodeConcept.equals(canConcept = diBestCandidate.getConcept()) && (nodeConcept.isMetric() && canConcept.isMetric() || nodeConcept.isCategory() && canConcept.isCategory() && this.isWholePartAssociationValid(node, canConcept))) {
                    node.setConcept((IConcept)diBestCandidate.getConcept());
                }
                this.getReport().resetCurrent(elmCurr);
            }
        }
    }

    private boolean isWholePartAssociationValid(INode aNode, Concept candidate) {
        ConceptInventory kb = this.getConceptInventory();
        for (IEdge e : aNode.getInEdges(new String[0])) {
            INode nodeFrom;
            Concept cFrom;
            if (!e.isWholePart() || (cFrom = (Concept)(nodeFrom = e.getStart()).getConcept()).equals(kb.getGenericCategory()) || cFrom.isValidPart(candidate)) continue;
            return false;
        }
        for (IEdge e : aNode.getOutEdges(new String[0])) {
            INode nodeTo;
            Concept cTo;
            if (!e.isWholePart() || (cTo = (Concept)(nodeTo = e.getEnd()).getConcept()).equals(kb.getGenericCategory()) || cTo.isValidWhole(candidate)) continue;
            return false;
        }
        return true;
    }

    private INode findNodeAssociatedWithDItem(IDataItem di) {
        Iterator iter = this.getModel().findNodes(NodeFilters.hasDataItem((IDataItem)di)).iterator();
        ToolBox.Assert(iter.hasNext(), "Expecting a valid node corresponding to data item:", di.getName());
        INode node = (INode)iter.next();
        if (node.isMetric()) {
            return node;
        }
        Iterable inEdges = node.getInEdges(new String[0]);
        ToolBox.Assert(inEdges != null && inEdges.iterator().hasNext(), "Expecting one in-edge for the attribute node associated with data item", di.getName());
        return ((IEdge)inEdges.iterator().next()).getStart();
    }

    private Candidate determineMetadata(DataItemExtension dix) {
        Candidate diBestCandidate = null;
        List<Candidate> candidates = dix.getCandidates();
        this.reportCandidates(candidates);
        DataAnalyzer analData = new DataAnalyzer(this, dix);
        Iterator<Candidate> itr = candidates.iterator();
        while (itr.hasNext()) {
            Candidate c = itr.next();
            if (!c.isAttribute()) continue;
            itr.remove();
        }
        diBestCandidate = analData.evaluateCandidates(this.getContext(), candidates);
        if (diBestCandidate == null && dix.getDataItem().getStats().totalCount() > 0L) {
            List<Concept> activeConcepts = this.getContext().getContext();
            diBestCandidate = analData.resolveBasedOnDataValues(activeConcepts);
        }
        if (diBestCandidate == null) {
            diBestCandidate = this.determineDefaultConcept(dix, null);
        }
        return diBestCandidate;
    }
}

