/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.smd.SmartMetadataImpl;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataAnalyzer;
import com.ibm.cognos.smd.analyzer.DataCollector;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.DataItemPartition;
import com.ibm.cognos.smd.analyzer.HierarchyDetector;
import com.ibm.cognos.smd.analyzer.LexicalAnalyzer;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

class LexicalHierarchyBuilder
extends LexicalAnalyzer {
    private static final float Density_Threshold = SmdConfig.getInstance().getValue("detectHierarchicalCategories", "densityThreshold", 0.9f);
    private static final int Enforce_OneMany_Data_Association = SmdConfig.getInstance().getValue("detectHierarchicalCategories", "requireOneManyDataAssociation", 0);
    private DataCollector mDataCollector = new DataCollector(this.getReport());

    LexicalHierarchyBuilder(SmartMetadataImpl smd, IAssociativeModel model, SmdReqContext reqContext) {
        super(smd, model, reqContext);
    }

    @Override
    void determineMetadata(IDataContainer dc) {
        for (IDataContainer sc : dc.getChildren()) {
            this.determineMetadata(sc);
        }
        if (dc.getDataItems().size() > 0) {
            this.genHierarchy(dc);
        }
    }

    private void genHierarchy(IDataContainer dc) {
        List<List<DataItemExtension>> dixLists = this.validateCandidates(dc);
        for (List<DataItemExtension> dixList : dixLists) {
            Element elmCurr = this.getReport().addEntry(true, "validateAndPartitionItems", new String[0]);
            List<DataItemPartition> partitions = DataItemPartition.partition(this.getReport(), dixList);
            Collections.sort(partitions, new DataItemPartition.CardinalityComparator());
            this.getReport().resetCurrent(elmCurr);
            DataItemPartition.reportPartitions(this.getReport(), partitions);
            elmCurr = this.getReport().addEntry(true, "checkForKnownHierarchy", new String[0]);
            List<DataItemPartition> knownPath = this.checkForKnownHierarchy(partitions);
            this.getReport().resetCurrent(elmCurr);
            if (knownPath.size() > 2) {
                this.genNodesForPartitionPaths(dc, partitions, knownPath);
                return;
            }
            this.refinePartitions(partitions);
            this.removeEmptyPartition(partitions);
            DataItemPartition.reportPartitions(this.getReport(), partitions);
            this.genDeepestOneManyPath(dc, partitions);
        }
    }

    private void refinePartitions(List<DataItemPartition> partitions) {
        if (partitions.size() < 2) {
            return;
        }
        Element elmCurr = this.getReport().addEntry(true, "refinePartitions", new String[0]);
        this.eliminateItemsFromPartitions(partitions);
        this.removeEmptyPartition(partitions);
        this.consolidatePrtitions(partitions);
        this.removeEmptyPartition(partitions);
        this.getReport().resetCurrent(elmCurr);
    }

    private List<List<DataItemExtension>> validateCandidates(IDataContainer dc) {
        ArrayList<List<DataItemExtension>> out = null;
        Collection vGroupings = this.getRequestContext().getDataItemsFor(SmdReqContext.EDataItemInfo.eKnownGroup);
        if (vGroupings == null) {
            out = new ArrayList<List<DataItemExtension>>(1);
            List<DataItemExtension> vDIXs = this.validateDataItemGroup(dc.getDataItems());
            out.add(vDIXs);
        } else {
            out = new ArrayList(vGroupings.size());
            for (List dig : vGroupings) {
                List<DataItemExtension> vDIXs = this.validateDataItemGroup(dig);
                out.add(vDIXs);
            }
        }
        return out;
    }

    private List<DataItemExtension> validateDataItemGroup(List<IDataItem> vDIs) {
        ArrayList<DataItemExtension> vDIXs = new ArrayList<DataItemExtension>(vDIs.size());
        for (IDataItem di : vDIs) {
            Element elmCurr = this.reportDataItem(di);
            DataItemExtension dix = this.findDataItemExtension(di, true);
            vDIXs.add(dix);
            this.validateCandidates(dix);
            this.getReport().resetCurrent(elmCurr);
        }
        return vDIXs;
    }

    private void validateCandidates(DataItemExtension dix) {
        if (dix.getCandidates().isEmpty()) {
            return;
        }
        DataAnalyzer analData = new DataAnalyzer(this, dix);
        Iterator<Candidate> cItr = dix.getCandidates().iterator();
        while (cItr.hasNext()) {
            Candidate c = analData.evaluateCandidate(this.getContext(), cItr.next());
            if (c != null) continue;
            cItr.remove();
        }
    }

    private void genDeepestOneManyPath(IDataContainer dc, List<DataItemPartition> partitions) {
        if (partitions.size() < 2) {
            this.genNodeForPartition(dc, partitions.get(0));
            return;
        }
        int maxTryouts = partitions.size() / 4 + 1;
        List<DataItemPartition> deepestPath = null;
        for (int idx = 0; idx < maxTryouts; ++idx) {
            Element elmCurr = this.getReport().addEntry(true, "findOneManyPath", new String[0]);
            List<DataItemPartition> aPath = this.findOneManyPath(partitions, partitions.get(idx));
            if (deepestPath == null || deepestPath.size() < aPath.size()) {
                deepestPath = aPath;
            }
            this.getReport().resetCurrent(elmCurr);
        }
        this.genNodesForPartitionPaths(dc, partitions, deepestPath);
    }

    private void genNodesForPartitionPaths(IDataContainer dc, List<DataItemPartition> allPartitions, List<DataItemPartition> deepestPath) {
        HashMap<DataItemPartition, INode> mapParCat = new HashMap<DataItemPartition, INode>(deepestPath.size() + 1);
        DataItemPartition prtnLast = allPartitions.get(allPartitions.size() - 1);
        for (DataItemPartition prtn : allPartitions) {
            if (deepestPath.contains(prtn) || prtn.equals(prtnLast)) {
                INode newNode = this.genNodeForPartition(dc, prtn);
                mapParCat.put(prtn, newNode);
                continue;
            }
            prtnLast.moveItemsFrom(prtn);
        }
        INode lastWholeNode = null;
        for (DataItemPartition aPath : deepestPath) {
            INode aPartNode = (INode)mapParCat.get(aPath);
            if (lastWholeNode != null && !lastWholeNode.connectsWith(aPartNode)) {
                this.getModel().createEdge(lastWholeNode, aPartNode, "", ECardinality.OneMany, true);
            }
            lastWholeNode = aPartNode;
        }
        this.getModel().createEdge(lastWholeNode, (INode)mapParCat.get(prtnLast), "", ECardinality.OneMany, true);
    }

    private INode genNodeForPartition(IDataContainer dc, DataItemPartition prtn) {
        Candidate c = this.pickBestCandidate(prtn.getIdentifierItem(), true);
        INode newNode = this.getModel().createNode(ENodeType.CATEGORY, (IConcept)c.getConcept(), null, c.getOverallConfidence());
        dc.addNode(newNode);
        for (DataItemExtension dix : prtn.getDataItems()) {
            INode newAttr = null;
            if (dix.equals(prtn.getIdentifierItem())) {
                newAttr = this.getModel().createNode(ENodeType.ATTRIBUTE, (IConcept)this.getConceptInventory().getIdentifierAttribute(), dix.getDataItem(), 0.0f);
            } else {
                Candidate cattr = this.pickBestCandidate(dix, false);
                newAttr = this.getModel().createNode(ENodeType.ATTRIBUTE, (IConcept)cattr.getConcept(), dix.getDataItem(), 0.0f);
            }
            dc.addNode(newAttr);
            this.getModel().createEdge(newNode, newAttr, "", ECardinality.OneOne, false);
        }
        return newNode;
    }

    private Candidate pickBestCandidate(DataItemExtension dix, boolean isCategory) {
        ConceptInventory gKB = this.getConceptInventory();
        Candidate bestCandidate = null;
        for (Candidate c : dix.getCandidates()) {
            if (isCategory && c.isCategory()) {
                bestCandidate = c.compare(bestCandidate);
                continue;
            }
            if (isCategory || !c.isAttribute() || gKB.getIdentifierAttribute().equals(c.getConcept())) continue;
            bestCandidate = c.compare(bestCandidate);
        }
        if (bestCandidate != null) {
            return bestCandidate;
        }
        return new Candidate(isCategory ? (Concept)gKB.getGenericCategory() : (Concept)gKB.getGenericAttribute());
    }

    private void eliminateItemsFromPartitions(List<DataItemPartition> partitions) {
        DataItemPartition last = partitions.get(partitions.size() - 1);
        Iterator<DataItemPartition> pItr = partitions.iterator();
        while (pItr.hasNext()) {
            DataItemPartition p = pItr.next();
            if (p.equals(last)) continue;
            if (p.getDataItems().size() == 1) {
                StringBuilder sbReason;
                DataItemExtension dix = p.getDataItems().get(0);
                if (!this.canItemBeEliminatedFromPartition(dix, sbReason = new StringBuilder())) continue;
                this.getReport().addEntry(false, "eliminateItem", "name", dix.getDataItem().getName(), "fromPartition", p.getToken(), "reason", sbReason.toString());
                last.moveItemsFrom(p);
                pItr.remove();
                continue;
            }
            if (!this.canPartitionBeEliminated(p)) continue;
            this.getReport().addEntry(false, "eliminatePartition", "name", p.getToken(), "reason", "LowDesnityOrCardinality");
            last.moveItemsFrom(p);
            pItr.remove();
        }
    }

    private boolean canItemBeEliminatedFromPartition(DataItemExtension dix, StringBuilder sbReason) {
        sbReason.setLength(0);
        IDataItem di = dix.getDataItem();
        IDataItemStats stats = di.getStats();
        List<Candidate> candidates = dix.getCandidates();
        if (di.getDataType().isTemporal() || candidates.size() == 1 && candidates.get(0).getConcept().getName().equals("cDate")) {
            sbReason.append("temporalItem");
            return true;
        }
        if (candidates.size() == 1 && candidates.get(0).isMetric()) {
            sbReason.append("knownMetric");
            return true;
        }
        if (stats.distinctCount() < (long)HierarchyDetector.MIN_HIERARCHY_CARDINALITY || stats.density() < Density_Threshold) {
            sbReason.append("LowDesnityOrCardinality");
            return true;
        }
        Concept genericCategory = (Concept)this.getConceptInventory().getGenericCategory();
        if (di.getDataType().isNumeric() && candidates.size() == 0 && genericCategory.getDataHints().evaluateDataHints(dix) <= 0.0f) {
            sbReason.append("failedCategoryIdDataPatterns");
            return true;
        }
        return false;
    }

    private boolean canPartitionBeEliminated(DataItemPartition p) {
        boolean bResult = true;
        for (DataItemExtension dix : p.getDataItems()) {
            IDataItemStats stats = dix.getDataItem().getStats();
            if (!(stats.density() >= Density_Threshold)) continue;
            return false;
        }
        return bResult;
    }

    private List<DataItemPartition> findOneManyPath(List<DataItemPartition> partitions, DataItemPartition startPart) {
        ArrayList<DataItemPartition> outPath = new ArrayList<DataItemPartition>();
        outPath.add(startPart);
        for (int idx = 0; idx < partitions.size() - 1; ++idx) {
            DataItemPartition currPart = partitions.get(idx);
            if (outPath.contains(currPart) || currPart.getMaxDistCount() < startPart.getMaxDistCount()) continue;
            Element elmCurr = this.getReport().addEntry(true, "canFormHierarchy", "partition1", startPart.getToken(), "item1", startPart.getIdentifierItem().getDataItem().getName(), "partition2", currPart.getToken(), "item2", currPart.getIdentifierItem().getDataItem().getName());
            boolean bOneMany = this.mDataCollector.doValuesHaveOneManyAssociation(startPart.getIdentifierItem().getDataItem(), currPart.getIdentifierItem().getDataItem());
            if (bOneMany) {
                startPart = currPart;
                outPath.add(startPart);
            }
            this.getReport().resetCurrent(elmCurr);
        }
        Element elmCurr = this.getReport().addEntry(true, "oneManyPartitionPath", new String[0]);
        for (DataItemPartition prtn : outPath) {
            this.getReport().addText(prtn.getToken());
            this.getReport().addText("\t\t");
        }
        this.getReport().resetCurrent(elmCurr);
        return outPath;
    }

    private void removeEmptyPartition(List<DataItemPartition> partitions) {
        Iterator<DataItemPartition> pItr = partitions.iterator();
        while (pItr.hasNext()) {
            DataItemPartition curr = pItr.next();
            if (!curr.getDataItems().isEmpty()) continue;
            pItr.remove();
        }
    }

    private boolean doPartitionsHaveCloseCardinality(DataItemPartition partOne, DataItemPartition partTwo) {
        boolean result = partOne.getMaxDistCount() == partTwo.getMaxDistCount() || (float)partOne.getMaxDistCount() / (float)partTwo.getMaxDistCount() < HierarchyDetector.MIN_HIERARCHY_CARDINALITY_RATIO;
        return result;
    }

    private void consolidatePrtitions(List<DataItemPartition> partitions) {
        DataItemPartition prev = partitions.get(partitions.size() - 1);
        for (int idx = partitions.size() - 2; idx >= 0; --idx) {
            DataItemPartition curr = partitions.get(idx);
            if (this.doPartitionsHaveCloseCardinality(prev, curr)) {
                DataItemExtension diID = DataItemPartition.betterIdentifier(prev.getIdentifierItem(), curr.getIdentifierItem());
                if (diID == prev.getIdentifierItem()) {
                    boolean bMerged = this.mergeIntoIfPossible(curr, prev);
                    prev = bMerged ? prev : curr;
                    continue;
                }
                this.mergeIntoIfPossible(prev, curr);
                prev = curr;
                continue;
            }
            prev = curr;
        }
    }

    private boolean mergeIntoIfPossible(DataItemPartition source, DataItemPartition target) {
        Element elmCurr = this.getReport().addEntry(true, "canBeMerged", "partition1", source.getToken(), "item1", source.getIdentifierItem().getDataItem().getName(), "partition2", target.getToken(), "item2", target.getIdentifierItem().getDataItem().getName());
        boolean bRes = this.mDataCollector.doValuesHaveOneOneAssociation(target.getIdentifierItem().getDataItem(), source.getIdentifierItem().getDataItem());
        if (bRes) {
            target.moveItemsFrom(source);
            this.getReport().addEntry(false, "mergePartition", "name", source.getToken(), "into", target.getToken(), "reason", "expectingOneOneValueAssociation");
        }
        this.getReport().resetCurrent(elmCurr);
        return bRes;
    }

    private List<DataItemPartition> checkForKnownHierarchy(List<DataItemPartition> partitions) {
        ArrayList<DataItemPartition> paths = new ArrayList<DataItemPartition>();
        DataItemPartition root = null;
        HashMap<Concept, DataItemPartition> partitionConcepts = new HashMap<Concept, DataItemPartition>(partitions.size());
        for (DataItemPartition p : partitions) {
            Concept c = this.pickBestCandidate(p.getIdentifierItem(), true).getConcept();
            partitionConcepts.put(c, p);
            if (!c.isWholePartRoot()) continue;
            if (root == null) {
                root = p;
                continue;
            }
            return paths;
        }
        if (root == null) {
            return paths;
        }
        paths.add(root);
        this.findPartPartition(partitionConcepts, paths);
        Element elmCurr = this.getReport().addEntry(true, "partitionPath", new String[0]);
        for (DataItemPartition prtn : paths) {
            this.getReport().addText(prtn.getToken());
            this.getReport().addText("\t\t");
        }
        this.getReport().resetCurrent(elmCurr);
        return paths;
    }

    private void findPartPartition(Map<Concept, DataItemPartition> partitionConcepts, List<DataItemPartition> paths) {
        Concept cPart;
        DataItemPartition pWhole = paths.get(paths.size() - 1);
        DataItemPartition pPart = null;
        Concept cWhole = this.getPartitionConcept(pWhole, partitionConcepts);
        Iterator<Concept> i$ = cWhole.getImmediateParts().iterator();
        while (i$.hasNext() && (pPart = this.findPartPartition(partitionConcepts, cPart = i$.next(), pWhole)) == null) {
        }
        if (pPart != null) {
            paths.add(pPart);
            this.findPartPartition(partitionConcepts, paths);
        }
    }

    private DataItemPartition findPartPartition(Map<Concept, DataItemPartition> partitionConcepts, Concept cPart, DataItemPartition pWhole) {
        DataItemPartition outPart = partitionConcepts.get(cPart);
        if (outPart == null) {
            return null;
        }
        if (Enforce_OneMany_Data_Association != 0) {
            Element elmCurr = this.getReport().addEntry(true, "canFormHierarchy", "partition1", pWhole.getToken(), "item1", pWhole.getIdentifierItem().getDataItem().getName(), "partition2", outPart.getToken(), "item2", outPart.getIdentifierItem().getDataItem().getName());
            boolean bOneMany = this.mDataCollector.doValuesHaveOneManyAssociation(pWhole.getIdentifierItem().getDataItem(), outPart.getIdentifierItem().getDataItem());
            this.getReport().resetCurrent(elmCurr);
            if (!bOneMany) {
                outPart = null;
            }
        }
        return outPart;
    }

    private Concept getPartitionConcept(DataItemPartition p, Map<Concept, DataItemPartition> partitionConcepts) {
        for (Map.Entry<Concept, DataItemPartition> entry : partitionConcepts.entrySet()) {
            if (!entry.getValue().equals(p)) continue;
            return entry.getKey();
        }
        ToolBox.Assert(false, "Expected to find a concept associated with a partition!");
        return null;
    }
}

