/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.analyzer.DataCollector;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.HierarchyDetector;
import com.ibm.cognos.smd.analyzer.ItemGroupingDetector;
import com.ibm.cognos.smd.analyzer.LexicalAnalyzer;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.Relation;
import com.ibm.cognos.smd.utilities.LinguisticTools;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class ModelGenerator {
    private ItemGroupingDetector mGroupingDetector;
    private final LexicalAnalyzer mAnalyzer;
    private final ConceptInventory mKB;
    private boolean mExamineCaptionUniqueness = false;

    ModelGenerator(LexicalAnalyzer az, int numOfItems) {
        this.mAnalyzer = az;
        this.mKB = az.getConceptInventory();
        this.mGroupingDetector = new ItemGroupingDetector(numOfItems, this.mAnalyzer);
        Boolean capU = (Boolean)this.mAnalyzer.getAnalysisOption(SmdReqContext.EOption.eExamineCaptionUniqueness);
        this.mExamineCaptionUniqueness = capU != null && capU.equals(Boolean.TRUE);
    }

    void addNodeForDataItem(DataItemExtension dix, Candidate cBase, Candidate cAttr) {
        this.mGroupingDetector.addDataItemCandidate(dix, cBase, cAttr);
    }

    void addNodeForDataItem(DataItemExtension dix, Candidate cBase) {
        this.mGroupingDetector.addDataItemCandidate(dix, cBase);
    }

    void generate(IDataContainer dc) {
        HierarchyDetector genHrchy = new HierarchyDetector(this.mAnalyzer.getReport(), this.mAnalyzer.getModel());
        for (ItemGroupingDetector.PseudoNode pn : this.mGroupingDetector.groupItems()) {
            if (pn instanceof ItemGroupingDetector.PseudoCategoryNode) {
                INode newNode = this.makeNodeForPseudoCategoryNode(dc, (ItemGroupingDetector.PseudoCategoryNode)pn);
                if (this.mExamineCaptionUniqueness) {
                    this.examineCaptionUniqueness(newNode);
                }
                genHrchy.examineAsHierarchyCandidate(newNode);
                continue;
            }
            this.makeNodeForPseudoMetricNode(dc, (ItemGroupingDetector.PseudoMetricNode)pn);
        }
        this.makeEdges(dc);
        this.addImplicitWholePartEdges(dc);
        genHrchy.makeKnownHierarchies();
        Boolean disableDataDriven = (Boolean)this.mAnalyzer.getAnalysisOption(SmdReqContext.EOption.eDisableDataDrivenAnalyses);
        if (disableDataDriven == null || disableDataDriven.equals(Boolean.FALSE)) {
            genHrchy.makeGenericHierarchies();
        }
    }

    private void examineCaptionUniqueness(INode aNode) {
        INode nodeID = null;
        INode nodeCaption = null;
        Iterable edges = aNode.getOutEdges(new String[0]);
        for (IEdge e : edges) {
            if (e.isWholePart()) continue;
            INode nodeTo = e.getEnd();
            if (this.mKB.getCaptionAttribute().equals(nodeTo.getConcept())) {
                nodeCaption = nodeTo;
                continue;
            }
            if (!this.mKB.getIdentifierAttribute().equals(nodeTo.getConcept())) continue;
            nodeID = nodeTo;
        }
        if (nodeID == null || nodeCaption == null) {
            return;
        }
        Element elmCurr = this.mAnalyzer.getReport().addEntry(true, "examineCaptionUniqueness", "item1", nodeCaption.getDataItem().getName(), "item2", nodeID.getDataItem().getName());
        DataCollector dc = new DataCollector(this.mAnalyzer.getReport());
        boolean b = dc.doValuesHaveOneOneAssociation(nodeCaption.getDataItem(), nodeID.getDataItem());
        nodeCaption.setProperty("isUnique", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
        this.mAnalyzer.getReport().resetCurrent(elmCurr);
    }

    private INode makeNodeForPseudoMetricNode(IDataContainer dc, ItemGroupingDetector.PseudoMetricNode pn) {
        INode newNode = this.mAnalyzer.getModel().createNode(ENodeType.METRIC, (IConcept)pn.getBaseConcept(), pn.getDataItem(), pn.getBaseOverallConfidence());
        dc.addNode(newNode);
        return newNode;
    }

    private INode makeNodeForPseudoCategoryNode(IDataContainer dc, ItemGroupingDetector.PseudoCategoryNode pn) {
        ToolBox.Assert(!pn.getAttributes().isEmpty(), "Expecting at least one data item when generating node! The base concept is:", pn.getBaseConcept().getName());
        Concept nodeConcept = pn.getBaseConcept();
        INode nodeBase = this.mAnalyzer.getModel().createNode(ENodeType.CATEGORY, (IConcept)nodeConcept, null, pn.getBaseOverallConfidence());
        dc.addNode(nodeBase);
        for (int idx = 0; idx < pn.getAttributeCandidates().size(); ++idx) {
            Concept con = pn.getAttributeCandidates().get(idx).getConcept();
            this.makeAttrNode(dc, nodeBase, pn.getBaseConcept(), pn.getAttributes().get(idx).getDataItem(), con);
        }
        return nodeBase;
    }

    private INode makeAttrNode(IDataContainer dc, INode nodeBase, Concept baseConcept, IDataItem di, Concept cAttr) {
        INode nodeAttr = this.mAnalyzer.getModel().createNode(ENodeType.ATTRIBUTE, (IConcept)cAttr, di, 0.0f);
        dc.addNode(nodeAttr);
        Relation r = (Relation)baseConcept.findRelationTo(cAttr);
        ToolBox.Assert(r != null || this.mKB.getGenericAttribute().equals(cAttr), "Expecting a valid attribure relationship when generating attribute node for dataItem:", di.getName());
        this.makeEdgeForRelation(nodeBase, nodeAttr, r);
        return nodeAttr;
    }

    private IEdge makeEdgeForRelation(INode from, INode to, Relation r) {
        IEdge newEdge = this.mAnalyzer.getModel().createEdge(from, to, r != null ? r.getLabel() : "", r != null ? r.getCardinality() : ECardinality.OneOne, r != null ? r.isWholePart() : false);
        return newEdge;
    }

    private void makeEdges(IDataContainer dc) {
        for (INode nodeFrom : dc.getNodes()) {
            if (!NavigationHelper.isRootNode((INode)nodeFrom)) continue;
            IConcept conFrom = nodeFrom.getConcept();
            List rels = conFrom.getOutRelations();
            for (IRelation r : rels) {
                List<INode> partCandidates;
                INode nodeTo;
                IConcept conTo = r.getToEnd();
                if (!r.isWholePart() || (nodeTo = this.findBestPartNode(nodeFrom, partCandidates = ModelGenerator.findNodesByConcept(dc, conTo))) == null) continue;
                this.makeEdgeForRelation(nodeFrom, nodeTo, (Relation)r);
            }
        }
    }

    private INode findClosestNode(INode child, INode nodeOne, INode nodeTwo) {
        float ovrTwo;
        DataItemExtension dixChild = this.mAnalyzer.findDataItemExtension(HierarchyDetector.getIdentifierNode(child).getDataItem(), true);
        DataItemExtension dixOne = this.mAnalyzer.findDataItemExtension(HierarchyDetector.getIdentifierNode(nodeOne).getDataItem(), true);
        DataItemExtension dixTwo = this.mAnalyzer.findDataItemExtension(HierarchyDetector.getIdentifierNode(nodeTwo).getDataItem(), true);
        int distOne = dixChild.getDataItemIndex() - dixOne.getDataItemIndex();
        int distTwo = dixChild.getDataItemIndex() - dixTwo.getDataItemIndex();
        float ovrOne = this.nameOverlaps(dixChild, dixOne);
        if (ovrOne > (ovrTwo = this.nameOverlaps(dixChild, dixTwo))) {
            return nodeOne;
        }
        if (ovrOne < ovrTwo) {
            return nodeTwo;
        }
        if (Math.abs(distOne) < Math.abs(distTwo)) {
            return nodeOne;
        }
        return nodeTwo;
    }

    private float nameOverlaps(DataItemExtension dixOne, DataItemExtension dixTwo) {
        int overlappingTokens = LinguisticTools.countCommonLemmas(dixOne.getNameLemmas(), dixTwo.getNameLemmas());
        float overlap = (float)overlappingTokens / ((float)(dixOne.getNameLemmas().size() + dixTwo.getNameLemmas().size()) / 2.0f);
        return overlap;
    }

    private static IEdge getParentEdge(INode aNode) {
        Iterable edges = aNode.getInEdges(new String[0]);
        for (IEdge e : edges) {
            if (!e.isWholePart()) continue;
            return e;
        }
        return null;
    }

    static List<INode> findNodesByConcept(IDataContainer dc, IConcept c) {
        ArrayList<INode> outNodes = new ArrayList<INode>(5);
        for (INode aNode : dc.getNodes()) {
            if (!aNode.getConcept().is(c)) continue;
            outNodes.add(aNode);
        }
        return outNodes;
    }

    private void addImplicitWholePartEdges(IDataContainer dc) {
        for (INode nodeFrom : dc.getNodes()) {
            IConcept conFrom;
            if (!NavigationHelper.isRootNode((INode)nodeFrom) || (conFrom = nodeFrom.getConcept()).instanceOf(IConcept.EConceptClass.geographic)) continue;
            Set<IConcept> existingPartConcepts = this.getPartConcepts(nodeFrom);
            for (IRelation directRel : conFrom.getOutRelations()) {
                if (!directRel.isWholePart() || existingPartConcepts.contains(directRel.getToEnd())) continue;
                this.makeEdgesForIndirectlyRelatedConcepts(dc, nodeFrom, existingPartConcepts, directRel.getToEnd());
            }
        }
    }

    private Set<IConcept> getPartConcepts(INode nodeParent) {
        HashSet<IConcept> out = new HashSet<IConcept>(3);
        for (INode part : NavigationHelper.getPartNodes((INode)nodeParent)) {
            if (out.contains(part.getConcept())) continue;
            out.add(part.getConcept());
            out.addAll(part.getConcept().getParts());
        }
        return out;
    }

    private void makeEdgesForIndirectlyRelatedConcepts(IDataContainer dc, INode nodeFrom, Set<IConcept> existingPartConcepts, IConcept dirConTo) {
        for (IRelation r : dirConTo.getOutRelations()) {
            if (!r.isWholePart() || existingPartConcepts.contains(r.getToEnd())) continue;
            Concept indirConTo = (Concept)r.getToEnd();
            List<INode> partCandidates = ModelGenerator.findNodesByConcept(dc, indirConTo);
            INode nodeTo = this.findBestPartNode(nodeFrom, partCandidates);
            if (nodeTo != null) {
                this.makeEdgeForRelation(nodeFrom, nodeTo, (Relation)r);
                existingPartConcepts.add(indirConTo);
                existingPartConcepts.addAll(indirConTo.getParts());
            }
            if (existingPartConcepts.contains(indirConTo) || indirConTo.isSelfPartWhole()) continue;
            this.makeEdgesForIndirectlyRelatedConcepts(dc, nodeFrom, existingPartConcepts, indirConTo);
        }
    }

    private INode findBestPartNode(INode nodeFrom, List<INode> candidates) {
        Iterator<INode> itr = candidates.iterator();
        while (itr.hasNext()) {
            INode nodePart = itr.next();
            if (ModelGenerator.getParentEdge(nodePart) != null) {
                itr.remove();
                continue;
            }
            if (!nodeFrom.connectsWith(nodePart) && !nodeFrom.getConcept().equals(nodePart.getConcept())) continue;
            itr.remove();
        }
        if (candidates.isEmpty()) {
            return null;
        }
        INode closestNode = candidates.get(0);
        for (int idx = 1; idx < candidates.size(); ++idx) {
            closestNode = this.findClosestNode(nodeFrom, closestNode, candidates.get(idx));
        }
        return closestNode;
    }
}

