/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.analyzer;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.smd.analyzer.Candidate;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.SmdConfig;

public final class NominalDetector {
    private static float gMin_Value_Repetition_Factor = SmdConfig.getInstance().getValue("nominalDetection", "valueRepetitionFactor", 0.2f);
    private static int gMax_Size_UniqueValue = SmdConfig.getInstance().getValue("nominalDetection", "maxDistinctValues", 20);

    static boolean isBestRepresentedAsNominalCategory(ConceptInventory aKB, Candidate candidate, IDataItem di) {
        if (candidate != null && !candidate.getConcept().equals(aKB.getGenericCategory()) && !candidate.getConcept().is(aKB.getGenericNominal())) {
            return false;
        }
        long diUniqueValue = di.getStats().distinctCount();
        long diAllValues = di.getStats().count();
        if (diUniqueValue <= 0L || diAllValues <= 0L) {
            return false;
        }
        if (diUniqueValue > (long)gMax_Size_UniqueValue) {
            return false;
        }
        return NominalDetector.hasHighRepetition(di);
    }

    public static boolean hasHighRepetition(IDataItem di) {
        float diUniqueValue = di.getStats().distinctCount();
        long diAllValues = di.getStats().count();
        float ratio = diUniqueValue / (di.getStats().density() * (float)diAllValues);
        return ratio < gMin_Value_Repetition_Factor;
    }
}

