/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.geoInfo;

import com.ibm.cognos.smd.geoInfo.MapLayerInfo;
import com.ibm.cognos.smd.geoInfo.MapRecommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MapInfo {
    private String mName;
    private int mScopeLevel;
    private MapRecommender.LocEntry mRepresenting = null;
    private List<MapLayerInfo> mLayers = new ArrayList<MapLayerInfo>();
    private Map<MapRecommender.LocEntry, MapRecommender.LocEntry> mLocContext = null;

    MapInfo(String name, int scopeLevel) {
        this.mName = name;
        this.mScopeLevel = scopeLevel;
    }

    String getName() {
        return this.mName;
    }

    int getScopeLevel() {
        return this.mScopeLevel;
    }

    List<MapLayerInfo> getLayers() {
        return this.mLayers;
    }

    MapLayerInfo addLayer(String name, String regionName) {
        MapLayerInfo newLayer = new MapLayerInfo(this, name, regionName);
        this.mLayers.add(newLayer);
        return newLayer;
    }

    void addLocationContext(MapRecommender.LocEntry loc, MapRecommender.LocEntry locContext) {
        if (this.mLocContext == null) {
            this.mLocContext = new HashMap<MapRecommender.LocEntry, MapRecommender.LocEntry>();
        }
        this.mLocContext.put(loc, locContext);
    }

    boolean isLocationInContext(MapRecommender.LocEntry loc, MapRecommender.LocEntry locContext) {
        if (this.mLocContext == null) {
            return true;
        }
        MapRecommender.LocEntry aContext = this.mLocContext.get(loc);
        if (aContext == null) {
            return true;
        }
        return aContext.equals(locContext);
    }

    void setRepresenting(MapRecommender.LocEntry rep) {
        this.mRepresenting = rep;
    }

    MapRecommender.LocEntry getRepresenting() {
        return this.mRepresenting;
    }
}

