/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.geoInfo;

import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.geoInfo.MapLayerInfo;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;

public final class MapRecommendation {
    private AnalysisReport mReport;
    private MapLayerInfo mLayerInfo;
    private boolean mIsFullCoverage = false;
    private List<String> mMissingLocations = new ArrayList<String>();

    MapRecommendation(AnalysisReport aReport) {
        this.mReport = aReport;
        this.mLayerInfo = null;
    }

    void setLayer(MapLayerInfo layerInfo, List<String> inputLocations, List<String> coveredLocations) {
        this.mLayerInfo = layerInfo;
        boolean bl = this.mIsFullCoverage = inputLocations.size() == coveredLocations.size();
        if (!this.mIsFullCoverage) {
            this.determineUncoveredLocation(inputLocations, coveredLocations);
        }
    }

    private void determineUncoveredLocation(List<String> inputLocations, List<String> coveredLocations) {
        for (String aLoc : inputLocations) {
            if (coveredLocations.contains(aLoc)) continue;
            this.mMissingLocations.add(aLoc);
        }
    }

    public boolean mapExists() {
        return this.mLayerInfo != null;
    }

    public boolean isCompleteCoverage() {
        ToolBox.Assert(this.mLayerInfo != null, "Map coverage can be queried only if a valid map recommendation exists!");
        return this.mIsFullCoverage;
    }

    public List<String> getMissingLocations() {
        ToolBox.Assert(this.mLayerInfo != null, "Missing locations can be queried only if a valid map recommendation exists!");
        return this.mMissingLocations;
    }

    public String getMapName() {
        if (this.mLayerInfo == null) {
            return null;
        }
        return this.mLayerInfo.getParentMap().getName();
    }

    public String getLayerName() {
        if (this.mLayerInfo == null) {
            return null;
        }
        return this.mLayerInfo.getName();
    }

    public String getRegionName() {
        if (this.mLayerInfo == null) {
            return null;
        }
        return this.mLayerInfo.getRegionName();
    }

    public boolean hasRegionName() {
        if (this.mLayerInfo == null) {
            return false;
        }
        return this.mLayerInfo.getRegionName() != null && this.mLayerInfo.getRegionName().length() > 0;
    }

    public void generateRecommendationReport(String outFilePath) {
        AnalysisReport.generateReportFile(this.mReport.getReportDocument(), outFilePath);
    }
}

