/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.geoInfo;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.smd.analyzer.AnalysisReport;
import com.ibm.cognos.smd.geoInfo.LocationContext;
import com.ibm.cognos.smd.geoInfo.MapInfo;
import com.ibm.cognos.smd.geoInfo.MapLayerInfo;
import com.ibm.cognos.smd.geoInfo.MapRecommendation;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.StaxParsingHelper;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Element;

public final class MapRecommender {
    static final float MIN_REC_COVERAGE = SmdConfig.getInstance().getValue("geoInfo", "recommendationCoverageThreshold", 0.8f);
    private static final ILogger LOGGER = LoggerManager.getLogger((String)"ATHENA.core.smd");
    private static final String GEO_INFO_SRC = "GeoMapCatalog.xml";
    private static final MapRecommender gInstance = new MapRecommender();
    private XMLStreamReader mParser;
    private List<MapInfo> mMaps = new ArrayList<MapInfo>(50);
    private Map<String, LocEntry> mEntryLookup = new HashMap<String, LocEntry>(5000);
    private Map<LocEntry, List<MapLayerInfo>> mLayerLookup = new HashMap<LocEntry, List<MapLayerInfo>>(3500);

    public static MapRecommender getInstance() {
        return gInstance;
    }

    public MapRecommendation recommendMap(List<String> geoLocations) {
        return this.recommendMap(null, geoLocations);
    }

    public MapRecommendation recommendMap(LocationContext context, List<String> geoLocations) {
        PerfLogEvent perfEvent = null;
        if (LOGGER.isPerfDebugEnabled()) {
            perfEvent = LOGGER.startPerfDebug(this.getClass().getName(), "recommendMap", "Starting geo map recommendation");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Recommending geo map with context=%s and locations=%s", context, geoLocations), this.getClass().getName() + "::recommendMap()");
        }
        AnalysisReport aReport = new AnalysisReport();
        this.reportLocationContext(aReport, context);
        Element elmCurr = aReport.addEntry(true, "inputLocations", new String[0]);
        ArrayList<LayerWeight> candidates = new ArrayList<LayerWeight>();
        for (int idx = 0; idx < geoLocations.size(); ++idx) {
            String loc = geoLocations.get(idx);
            List<MapLayerInfo> listLayers = this.lookupLocationInContext(aReport, loc, idx, context);
            if (listLayers == null) continue;
            this.incorporateCandidates(loc, candidates, listLayers);
        }
        aReport.resetCurrent(elmCurr);
        this.reportCandidates(aReport, candidates);
        MapRecommendation out = new MapRecommendation(aReport);
        this.findBestCandidate(out, geoLocations, candidates);
        if (out != null) {
            aReport.addEntry(false, "recommending", "map", out.getMapName(), "layer", out.getLayerName(), "region", out.getRegionName());
        }
        if (perfEvent != null) {
            LOGGER.stopPerfDebug(perfEvent, "Finished geo map recommendation");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result of analysis:\n" + aReport.getReportDocument().asXML(), this.getClass().getName() + "::analyze()");
        }
        return out;
    }

    private List<MapLayerInfo> lookupLocationInContext(AnalysisReport aReport, String loc, int idxLoc, LocationContext context) {
        String normalizedLoc = MapRecommender.normalize(loc);
        LocEntry entLoc = this.mEntryLookup.get(normalizedLoc);
        LocEntry entContext = null;
        if (context != null && idxLoc < context.getLocationContext().size()) {
            String locContext = context.getLocationContext().get(idxLoc);
            entContext = this.mEntryLookup.get(locContext);
        }
        List<MapLayerInfo> listLayers = null;
        Element elmCurr = aReport.addEntry(true, "lookupLocation", "name", loc, "context", entContext != null ? entContext.getID() : "null");
        if (entLoc != null) {
            listLayers = this.mLayerLookup.get(entLoc);
        }
        ArrayList<MapLayerInfo> out = null;
        if (listLayers != null) {
            out = new ArrayList<MapLayerInfo>(listLayers.size());
            for (MapLayerInfo li : listLayers) {
                if (!this.isInContext(entLoc, entContext, li)) continue;
                out.add(li);
                aReport.addEntry(false, "candidate", "map", li.getParentMap().getName(), "layer", li.getName());
            }
        }
        aReport.resetCurrent(elmCurr);
        return out;
    }

    private boolean isInContext(LocEntry entLoc, LocEntry entContext, MapLayerInfo aLayer) {
        if (entContext == null) {
            return true;
        }
        List<MapLayerInfo> contextLayers = this.mLayerLookup.get(entContext);
        LocEntry mapRep = aLayer.getParentMap().getRepresenting();
        if (mapRep != null) {
            if (mapRep.equals(entContext)) {
                return true;
            }
            if (contextLayers != null) {
                for (MapLayerInfo conLayer : contextLayers) {
                    if (!mapRep.equals(conLayer.getParentMap().getRepresenting())) continue;
                    return true;
                }
            }
        } else if (aLayer.getParentMap().isLocationInContext(entLoc, entContext)) {
            return true;
        }
        return false;
    }

    private void incorporateCandidates(String loc, List<LayerWeight> candidates, List<MapLayerInfo> listLayers) {
        for (MapLayerInfo aLayer : listLayers) {
            LayerWeight aCandidate = null;
            for (LayerWeight lw : candidates) {
                if (!lw.getMapLayer().equals(aLayer)) continue;
                aCandidate = lw;
                break;
            }
            if (aCandidate == null) {
                aCandidate = new LayerWeight(aLayer);
                candidates.add(aCandidate);
            }
            aCandidate.recordHit(loc);
        }
    }

    private void findBestCandidate(MapRecommendation out, List<String> geoLocations, List<LayerWeight> candidates) {
        int coverageThreshold = Math.round(MIN_REC_COVERAGE * (float)geoLocations.size());
        List<LayerWeight> selections = this.selectCandidatesForCoverage(candidates, coverageThreshold);
        if (selections != null) {
            LayerWeight lw = this.selectLowestScope(selections);
            out.setLayer(lw.getMapLayer(), geoLocations, lw.getCovered());
        }
    }

    private List<LayerWeight> selectCandidatesForCoverage(List<LayerWeight> allCandidates, int coverageThreshold) {
        int maxCoverage = 0;
        for (LayerWeight lw : allCandidates) {
            if (lw.getHitCount() < coverageThreshold || lw.getHitCount() <= maxCoverage) continue;
            maxCoverage = lw.getHitCount();
        }
        if (maxCoverage == 0) {
            return null;
        }
        ArrayList<LayerWeight> out = new ArrayList<LayerWeight>();
        for (LayerWeight lw : allCandidates) {
            if (lw.getHitCount() != maxCoverage) continue;
            out.add(lw);
        }
        return out;
    }

    private LayerWeight selectLowestScope(List<LayerWeight> candidates) {
        int lowestScope = Integer.MAX_VALUE;
        LayerWeight lowestLayer = null;
        for (LayerWeight lw : candidates) {
            if (lw.getMapLayer().getParentMap().getScopeLevel() >= lowestScope) continue;
            lowestScope = lw.getMapLayer().getParentMap().getScopeLevel();
            lowestLayer = lw;
        }
        return lowestLayer;
    }

    private void reportCandidates(AnalysisReport aReport, List<LayerWeight> candidates) {
        Element elmCurr = aReport.addEntry(true, "candidates", new String[0]);
        for (LayerWeight lw : candidates) {
            MapLayerInfo aLayer = lw.getMapLayer();
            aReport.addEntry(false, "candidate", "map", aLayer.getParentMap().getName(), "layer", aLayer.getName(), "scopeLevel", Integer.toString(aLayer.getParentMap().getScopeLevel()), "hitCount", Integer.toString(lw.getHitCount()));
        }
        aReport.resetCurrent(elmCurr);
    }

    private MapRecommender() {
        InputStream str = this.openGeoInfoStream();
        this.setup(str);
    }

    private void setup(InputStream iStr) {
        long b4 = ToolBox.logPerfIndicators("/geoInfo/setup/time", 0L);
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.mParser = factory.createXMLStreamReader(iStr);
            Map<String, LocEntry> mapEntries = this.parseEntities();
            this.parseMaps(mapEntries);
        }
        catch (Exception st) {
            throw new RuntimeException(st.getMessage(), st);
        }
        ToolBox.logPerfIndicators("/geoInfo/setup//time", b4);
        System.out.println("Total EntryLookup entries:" + this.mEntryLookup.size());
        System.out.println("Total LayerLookup entries:" + this.mLayerLookup.size());
    }

    private Map<String, LocEntry> parseEntities() throws XMLStreamException {
        HashMap<String, LocEntry> mapEntries = new HashMap<String, LocEntry>(3500);
        while (StaxParsingHelper.moveToTag(this.mParser, "e", "entries")) {
            String sName = this.mParser.getAttributeValue(null, "name");
            ToolBox.Assert(sName != null && sName.length() > 0, "Expecting a valid enity name");
            ToolBox.Assert(mapEntries.get(sName) == null, "Duplicate entry! Another entry with this name exists:", sName);
            LocEntry newEntry = new LocEntry(sName);
            mapEntries.put(sName, newEntry);
            while (StaxParsingHelper.moveToTag(this.mParser, "a", "e")) {
                String alias = this.mParser.getElementText();
                this.mEntryLookup.put(alias, newEntry);
            }
        }
        return mapEntries;
    }

    private void parseMaps(Map<String, LocEntry> mapEntries) throws XMLStreamException {
        while (StaxParsingHelper.moveToTag(this.mParser, "map", "mapCatalog")) {
            String sMapName = this.mParser.getAttributeValue(null, "name");
            String sScopeLevel = this.mParser.getAttributeValue(null, "scopeLevel");
            MapInfo newMap = new MapInfo(sMapName, Integer.parseInt(sScopeLevel));
            this.mMaps.add(newMap);
            String sRepresenting = this.mParser.getAttributeValue(null, "representing");
            LocEntry entryRep = null;
            if (sRepresenting != null) {
                entryRep = mapEntries.get(sRepresenting);
                ToolBox.Assert(entryRep != null, "Unable to resolve 'representing' ref:", sRepresenting);
                newMap.setRepresenting(entryRep);
            }
            boolean bAlreadyAtFirstLayer = this.parseLocationContexts(newMap, mapEntries);
            while (bAlreadyAtFirstLayer || StaxParsingHelper.moveToTag(this.mParser, "layer", "map")) {
                bAlreadyAtFirstLayer = false;
                String sLayerName = this.mParser.getAttributeValue(null, "name");
                String sRegionName = this.mParser.getAttributeValue(null, "region");
                MapLayerInfo newLayer = newMap.addLayer(sLayerName, sRegionName);
                while (StaxParsingHelper.moveToTag(this.mParser, "r", "refs")) {
                    String entryRef = this.mParser.getElementText();
                    LocEntry entry = mapEntries.get(entryRef);
                    ToolBox.Assert(entry != null, "Unable to resolve entry ref:", entryRef);
                    this.indexEntry(entry, newLayer);
                }
            }
        }
    }

    boolean parseLocationContexts(MapInfo aMap, Map<String, LocEntry> mapEntries) throws XMLStreamException {
        boolean bFound = StaxParsingHelper.moveToOptionalTag(this.mParser, "locationContext");
        if (!bFound) {
            return true;
        }
        while (StaxParsingHelper.moveToTag(this.mParser, "lc", "locationContext")) {
            String sLoc = this.mParser.getAttributeValue(null, "loc");
            LocEntry eLoc = mapEntries.get(sLoc);
            ToolBox.Assert(eLoc != null, "Unable to resolve location context 'loc':", sLoc);
            String sContext = this.mParser.getAttributeValue(null, "context");
            LocEntry eContext = mapEntries.get(sContext);
            ToolBox.Assert(eContext != null, "Unable to resolve location context:", sContext);
            aMap.addLocationContext(eLoc, eContext);
        }
        return false;
    }

    private void indexEntry(LocEntry entry, MapLayerInfo layer) {
        List<MapLayerInfo> listLayers = this.mLayerLookup.get(entry);
        if (listLayers == null) {
            listLayers = new ArrayList<MapLayerInfo>(3);
            this.mLayerLookup.put(entry, listLayers);
        }
        listLayers.add(layer);
    }

    static String normalize(String entry) {
        return entry.toUpperCase();
    }

    private void reportLocationContext(AnalysisReport aReport, LocationContext aContext) {
        if (aContext == null) {
            return;
        }
        Element elmCurr = aReport.addEntry(true, "locationContext", new String[0]);
        for (String loc : aContext.getLocationContext()) {
            aReport.addEntry(false, "context", "name", loc);
        }
        aReport.resetCurrent(elmCurr);
    }

    private InputStream openGeoInfoStream() {
        InputStream str = this.getClass().getResourceAsStream(GEO_INFO_SRC);
        if (str == null) {
            throw new RuntimeException("A knowledge base inventory file was not specified.");
        }
        return str;
    }

    static class LocEntry {
        private String mID;

        String getID() {
            return this.mID;
        }

        LocEntry(String id) {
            this.mID = id;
        }
    }

    private static class LayerWeight {
        private MapLayerInfo mLayer;
        private List<String> mCoverage = new ArrayList<String>();

        LayerWeight(MapLayerInfo aLayer) {
            this.mLayer = aLayer;
        }

        void recordHit(String loc) {
            this.mCoverage.add(loc);
        }

        int getHitCount() {
            return this.mCoverage.size();
        }

        List<String> getCovered() {
            return this.mCoverage;
        }

        MapLayerInfo getMapLayer() {
            return this.mLayer;
        }
    }
}

