/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.importer;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.importer.importspec.EDocumentType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.TabularExtracterFactory;
import com.ibm.cognos.aurora.core.extract.process.ITabularDatasetProcessor;
import com.ibm.cognos.aurora.core.extract.process.ReconcileISO8601CompactDates;
import com.ibm.cognos.aurora.core.model.SimpleDataItem;
import com.ibm.cognos.aurora.core.util.ConfigHelper;
import com.ibm.cognos.smd.utilities.ToolBox;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class Importer {
    private static final List<String> DEFAULT_NULL_TOKENS = new LinkedList<String>();
    private final ISmartMetadata mSMD;
    private final IQueryLogicalStorage mQLS;
    private String mTempDirPath;
    private ULocale mLocale;
    private TimeZone mZone;
    private List<String> mNullTokens;

    public Importer(Properties config, ISmartMetadata smd, IQueryLogicalStorage qls) {
        this.mSMD = smd;
        this.mQLS = qls;
        this.mTempDirPath = ConfigHelper.getString((Properties)config, (String)"aurora.temp_dir");
        String defaultLocaleId = ConfigHelper.getString((Properties)config, (String)"aurora.importer.default_locale", (String)"en_US@calendar=gregorian");
        this.setLocale(new ULocale(defaultLocaleId));
        String defaultZoneId = ConfigHelper.getString((Properties)config, (String)"aurora.importer.default_zone", (String)"American/New_York");
        this.setZone(TimeZone.getTimeZone((String)defaultZoneId));
        this.mNullTokens = ConfigHelper.getList((Properties)config, (String)"aurora.importer.null_tokens");
        if (this.getNullTokens().isEmpty()) {
            this.setNullTokens(DEFAULT_NULL_TOKENS);
        }
    }

    public ISmartMetadata getSMD() {
        return this.mSMD;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public ULocale getLocale() {
        return this.mLocale;
    }

    public void setLocale(ULocale locale) {
        this.mLocale = locale;
    }

    public TimeZone getZone() {
        return this.mZone;
    }

    public void setZone(TimeZone zone) {
        this.mZone = zone;
    }

    public List<String> getNullTokens() {
        return this.mNullTokens;
    }

    public void setNullTokens(List<String> nullTokens) {
        this.mNullTokens = nullTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAssociativeModel importDocument(String filePath) {
        ToolBox.Assert(null != this.mLocale, "Illegal state ... mLocale was null");
        ToolBox.Assert(null != this.mZone, "Illegal state ... mZone was null");
        ToolBox.Assert(null != this.mNullTokens, "Illegal state ... mNullTokens was null");
        IAssociativeModel model = null;
        model = null != this.mQLS ? this.mQLS.createModel(this.mSMD.getConceptInventory()) : this.mSMD.createModel();
        ExtractionContext extractionContext = new ExtractionContext(this.mTempDirPath, this.mLocale, this.mZone, this.mNullTokens);
        extractionContext.setDataSourceName(FilenameUtils.getName((String)filePath));
        extractionContext.setDataSourceType("Unknown");
        extractionContext.getDataSourceProperties().put("documentPath", ValueFactory.create((Object)filePath));
        try {
            TabularExtracter extractor = TabularExtracterFactory.create((String)filePath, (EDocumentType)EDocumentType.AUTO);
            try {
                extractor.extractDatasets(extractionContext);
            }
            finally {
                extractor.close();
            }
            this.processDatasets(extractionContext);
            IDataContainer dataSourceContainer = model.getRootContainer().createChild(extractionContext.getDataSourceName(), extractionContext.getDataSourceType());
            for (Map.Entry e : extractionContext.getDataSourceProperties().entrySet()) {
                dataSourceContainer.setProperty((String)e.getKey(), (IValue)e.getValue());
            }
            for (TabularDataset ds : extractionContext.getAllDatasets()) {
                IDataContainer datasetContainer = dataSourceContainer.createChild(ds.getDatasetName(), ds.getDatasetType());
                for (Map.Entry e : ds.getDatasetProperties().entrySet()) {
                    datasetContainer.setProperty((String)e.getKey(), (IValue)e.getValue());
                }
                for (TabularDataset.ColumnInfo colInfo : ds.getColumns()) {
                    SimpleDataItem di = new SimpleDataItem(datasetContainer, colInfo.getName());
                    datasetContainer.addDataItem((IDataItem)di);
                    IValueIterator iter = colInfo.openIterator();
                    try {
                        while (iter.hasNext()) {
                            di.addValue(iter.next());
                        }
                    }
                    finally {
                        iter.close();
                    }
                    di.setDataType(colInfo.getDataType());
                    for (IValueDecoration decor : colInfo.getValueDecorations()) {
                        di.addValueDecoration(decor);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new ImportException((Throwable)ex);
        }
        finally {
            extractionContext.dispose();
        }
        return model;
    }

    protected void processDatasets(ExtractionContext ctx) {
        ArrayList<ReconcileISO8601CompactDates> processors = new ArrayList<ReconcileISO8601CompactDates>();
        if (ctx.getNeedsISO6801Reconciliation()) {
            processors.add(new ReconcileISO8601CompactDates(this.getLocale(), this.getZone()));
        }
        if (!processors.isEmpty()) {
            for (TabularDataset ds : ctx.getAllDatasets()) {
                for (ITabularDatasetProcessor iTabularDatasetProcessor : processors) {
                    iTabularDatasetProcessor.process(ds);
                }
            }
        }
    }

    static {
        DEFAULT_NULL_TOKENS.add("");
        DEFAULT_NULL_TOKENS.add("na");
        DEFAULT_NULL_TOKENS.add("n/a");
        DEFAULT_NULL_TOKENS.add("--");
        DEFAULT_NULL_TOKENS.add("-");
    }
}

