/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.importer.enterprise;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.core.model.SimpleDataItem;
import com.ibm.cognos.smd.importer.enterprise.DataSourceReader;
import com.ibm.cognos.smd.utilities.FMDataTypeConvertor;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class PMCDumpReader
extends DataSourceReader {
    private String mDumpFilePath;
    private XMLStreamReader mParser;
    private List<String> mMeasureNames = new ArrayList<String>();
    private List<List<String>> mLevelsAndTheirNames = new ArrayList<List<String>>();

    PMCDumpReader(String filePath) {
        this.mDumpFilePath = filePath;
    }

    @Override
    public void buildModel(IDataContainer container) {
        IDataContainer dataSourceContainer = container.createChild(this.mDumpFilePath, "Database");
        try {
            FileInputStream inStream = new FileInputStream(this.mDumpFilePath);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.mParser = factory.createXMLStreamReader(inStream);
            this.startRoot(dataSourceContainer);
        }
        catch (XMLStreamException st) {
            throw new RuntimeException(st.getMessage(), st);
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException(fe.getMessage(), fe);
        }
        this.genNodesForLevels(dataSourceContainer);
        this.genNodesForMeasures(dataSourceContainer);
    }

    private void genNodesForMeasures(IDataContainer container) {
        IAssociativeModel model = container.getModel();
        IConceptInventory kb = model.getConceptInventory();
        for (String msrName : this.mMeasureNames) {
            IDataItem di = container.getDataItemByName(msrName);
            ToolBox.Assert(di != null, "Expecting a valid dataItem for measure:", msrName);
            INode newNode = model.createNode(ENodeType.METRIC, kb.getGenericMetric(), di, 0.99f);
            container.addNode(newNode);
        }
    }

    private void genNodesForLevels(IDataContainer container) {
        IAssociativeModel model = container.getModel();
        IConceptInventory kb = model.getConceptInventory();
        for (List<String> levelNames : this.mLevelsAndTheirNames) {
            INode lastLevel = null;
            for (String lvlName : levelNames) {
                IDataItem di = container.getDataItemByName(lvlName);
                ToolBox.Assert(di != null, "Expecting a valid dataItem for level:", lvlName);
                INode attrLevel = model.createNode(ENodeType.ATTRIBUTE, kb.getConcept("cIdentifier"), di, 0.99f);
                container.addNode(attrLevel);
                INode newLevel = model.createNode(ENodeType.CATEGORY, kb.getGenericCategory(), null, 0.99f);
                container.addNode(newLevel);
                model.createEdge(newLevel, attrLevel, null, ECardinality.OneOne, false);
                if (lastLevel != null) {
                    model.createEdge(lastLevel, newLevel, null, ECardinality.OneMany, true);
                }
                lastLevel = newLevel;
            }
        }
    }

    private void startRoot(IDataContainer container) throws XMLStreamException {
        ToolBox.Assert(this.moveToTag("project", null), "Failed to find 'project' node ...  ensure the input is a valid PMC model.");
        while (this.moveToTag("dimension", "project")) {
            this.processDimension(container);
        }
    }

    private void processDimension(IDataContainer container) throws XMLStreamException {
        String dimType = this.getElementValue("type");
        if ("measure".equals(dimType)) {
            this.processMeasures(container);
        } else {
            while (this.moveToTag("hierarchy", "dimension")) {
                this.processDimensionHierarchy(container);
            }
        }
    }

    private void processMeasures(IDataContainer container) throws XMLStreamException {
        while (this.moveToTag("measure", "dimension")) {
            String extName = this.getElementValue("externalName");
            String dTypeFm = null;
            if (this.moveToTag("datatype", "measure")) {
                dTypeFm = this.mParser.getElementText();
            }
            IDataType dType = FMDataTypeConvertor.convertFMType(dTypeFm);
            SimpleDataItem dataItem = new SimpleDataItem(container, extName);
            dataItem.setDataType(dType);
            container.addDataItem((IDataItem)dataItem);
            this.mMeasureNames.add(extName);
        }
    }

    private void processDimensionHierarchy(IDataContainer container) throws XMLStreamException {
        ArrayList<String> levelNames = new ArrayList<String>();
        while (this.moveToTag("level", "hierarchy")) {
            String lvlName = this.getElementValue("externalName");
            SimpleDataItem dataItem = new SimpleDataItem(container, lvlName);
            dataItem.setDataType((IDataType)DataTypes.getStringType((int)255));
            container.addDataItem((IDataItem)dataItem);
            levelNames.add(lvlName);
        }
        this.mLevelsAndTheirNames.add(levelNames);
    }

    private boolean moveToTag(String localName, String parentContext) throws XMLStreamException {
        int next = this.mParser.next();
        while (next != 8) {
            if (next == 1 && localName.equals(this.mParser.getLocalName())) {
                return true;
            }
            if (next == 2 && parentContext != null && parentContext.equals(this.mParser.getLocalName())) {
                return false;
            }
            next = this.mParser.next();
        }
        return false;
    }

    private String getElementValue(String tagName) throws XMLStreamException {
        boolean r = this.moveToTag(tagName, this.mParser.getLocalName());
        ToolBox.Assert(r, "Failed to get a value for required property:'", tagName, "' in the context of:", this.mParser.getLocalName());
        return this.mParser.getElementText();
    }
}

