/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.importer.enterprise;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.smd.SMDAPI;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.SimpleDataItem;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.FMDataTypeConvertor;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RolapModelReader {
    private XMLStreamReader mParser;
    private Element mRolapRoot;
    private ISmartMetadata mSMD;
    private IAssociativeModel mModel;

    public RolapModelReader(InputStream modelContent, List<String> modelViews) {
        this.parseModel(modelContent);
        Properties cfg = new Properties();
        cfg.put("aurora.temp_dir", "../temp/aurora/temp");
        this.mSMD = SMDAPI.getInstance((Properties)cfg);
    }

    public Document transformModel(SmdReqContext reqContext) {
        ToolBox.Assert(reqContext != null && reqContext.getScope() == SmdReqContext.EScope.eDecorateModel, "Expecting a valid request context of type 'decorate model' scope");
        this.mModel = this.mSMD.createModel();
        Element elmCube = (Element)this.mRolapRoot.selectSingleNode("olap:mdSchema/olap:cubeModel/olap:cube");
        this.transformFacts(elmCube);
        this.transformDimensions(elmCube);
        Document docReport = this.mSMD.analyze(this.mModel, reqContext);
        return docReport;
    }

    public IAssociativeModel getModel() {
        return this.mModel;
    }

    private void transformDimensions(Element elmCube) {
        List elmDims = elmCube.selectNodes("olap:cubeDimensionRef");
        for (Element elmDimRef : elmDims) {
            String sDimRef = elmDimRef.attributeValue("name");
            String sHryRef = elmDimRef.element("hierarchyRef").attributeValue("name");
            Element elmHry = (Element)elmCube.getParent().getParent().selectSingleNode("olap:cubeModel/olap:dimension[@name=\"#DIMREF\"]/olap:hierarchy[@name=\"#HRYREF\"]".replace("#DIMREF", sDimRef).replace("#HRYREF", sHryRef));
            ToolBox.Assert(elmHry != null, "Unable to resolve hierarchy reference:", sHryRef);
            this.transformHierarchy(elmHry, this.mModel.getRootContainer());
        }
    }

    private void transformHierarchy(Element elmHry, IDataContainer dc) {
        INode lastLevel = null;
        List elmLevelRefs = elmHry.elements("levelRef");
        for (Element elmLvlRef : elmLevelRefs) {
            String sLvlRef = elmLvlRef.attributeValue("name");
            Element elmLvl = (Element)elmHry.getParent().selectSingleNode("olap:level[@name=\"#LVLREF\"]".replace("#LVLREF", sLvlRef));
            ToolBox.Assert(elmLvl != null, "Unable to resolve level reference:", sLvlRef);
            INode newLevel = this.transformLevel(elmLvl, dc);
            if (lastLevel != null) {
                dc.getModel().createEdge(lastLevel, newLevel, "", ECardinality.OneMany, true);
            }
            lastLevel = newLevel;
        }
    }

    private INode transformLevel(Element elmLvl, IDataContainer dc) {
        ConceptInventory kb = (ConceptInventory)this.mSMD.getConceptInventory();
        INode newLevel = dc.getModel().createNode(ENodeType.CATEGORY, this.mSMD.getConceptInventory().getGenericCategory(), null, 1.0f);
        dc.addNode(newLevel);
        for (Element elmAtrRef : elmLvl.elements()) {
            INode nodeAtr = null;
            String attrType = elmAtrRef.getName();
            if ("levelKeyRef".equals(attrType)) {
                boolean isKey = elmAtrRef.attributeValue("name").toLowerCase().indexOf(elmLvl.attributeValue("name").toLowerCase()) >= 0;
                nodeAtr = this.makeAttributeNode(elmAtrRef, dc, isKey ? kb.getIdentifierAttribute() : kb.getGenericAttribute());
                this.makeEdgeForAttribute(dc, newLevel, nodeAtr);
                continue;
            }
            if ("captionAttributeRef".equals(attrType)) {
                nodeAtr = this.makeAttributeNode(elmAtrRef, dc, kb.getCaptionAttribute());
                this.makeEdgeForAttribute(dc, newLevel, nodeAtr);
                continue;
            }
            if (!"relatedAttributeRef".equals(attrType)) continue;
            nodeAtr = this.makeAttributeNode(elmAtrRef, dc, kb.getGenericAttribute());
            this.makeEdgeForAttribute(dc, newLevel, nodeAtr);
        }
        return newLevel;
    }

    private INode makeAttributeNode(Element elmAtrRef, IDataContainer dc, IConcept c) {
        String sAtrRef = elmAtrRef.attributeValue("name");
        Element elmAtr = (Element)elmAtrRef.getParent().getParent().selectSingleNode("olap:attribute[@name=\"#ATTRREF\"]".replace("#ATTRREF", sAtrRef));
        ToolBox.Assert(elmAtr != null, "Unable to resolve attribute reference:", sAtrRef);
        String dTypeFm = "characterLength16";
        IDataType dType = FMDataTypeConvertor.convertFMType(dTypeFm);
        SimpleDataItem dataItem = new SimpleDataItem(dc, elmAtr.attributeValue("name"));
        dataItem.setDataType(dType);
        dc.addDataItem((IDataItem)dataItem);
        INode nodeAttr = dc.getModel().createNode(ENodeType.ATTRIBUTE, c, (IDataItem)dataItem, 1.0f);
        dc.addNode(nodeAttr);
        nodeAttr.setProperty("refObject", (Object)elmAtr.element("queryItem").attributeValue("refObject"));
        return nodeAttr;
    }

    private void makeEdgeForAttribute(IDataContainer dc, INode from, INode to) {
        dc.getModel().createEdge(from, to, "", ECardinality.OneOne, false);
    }

    private void transformFacts(Element elmCube) {
        List elmFacts = elmCube.selectNodes("olap:cubeFacts/olap:measureRef");
        for (Element elmFactRef : elmFacts) {
            String sRef = elmFactRef.attributeValue("name");
            Element elmFact = (Element)elmCube.getParent().selectSingleNode("olap:facts/olap:measure[@name=\"#MEASUREREF\"]".replace("#MEASUREREF", sRef));
            ToolBox.Assert(elmFact != null, "Unable to resolve measure reference:", sRef);
            this.transformFact(elmFact, this.mModel.getRootContainer(), false);
        }
        List elmCalcFacts = elmCube.selectNodes("olap:cubeFacts/olap:calculatedMeasureRef");
        for (Element elmFactRef : elmCalcFacts) {
            String sRef = elmFactRef.attributeValue("name");
            Element elmFact = (Element)elmCube.getParent().selectSingleNode("olap:facts/olap:calculatedMeasure[@name=\"#MEASUREREF\"]".replace("#MEASUREREF", sRef));
            ToolBox.Assert(elmFact != null, "Unable to resolve calculated measure reference:", sRef);
            this.transformFact(elmFact, this.mModel.getRootContainer(), true);
        }
    }

    private INode transformFact(Element elmFact, IDataContainer dc, boolean isCalculated) {
        String dTypeFm = "float32";
        IDataType dType = FMDataTypeConvertor.convertFMType(dTypeFm);
        SimpleDataItem dataItem = new SimpleDataItem(dc, elmFact.attributeValue("name"));
        dataItem.setDataType(dType);
        dc.addDataItem((IDataItem)dataItem);
        INode nodeMteric = dc.getModel().createNode(ENodeType.METRIC, this.mSMD.getConceptInventory().getGenericMetric(), (IDataItem)dataItem, 1.0f);
        dc.addNode(nodeMteric);
        if (isCalculated) {
            nodeMteric.setProperty("v5Expr", (Object)elmFact.element("V5Expression").attributeValue("template"));
        } else {
            nodeMteric.setProperty("refObject", (Object)elmFact.element("queryItem").attributeValue("refObject"));
        }
        return nodeMteric;
    }

    private void parseModel(InputStream iStr) {
        long b4 = ToolBox.logPerfIndicators("/parseModel/setup/time", 0L);
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.mParser = factory.createXMLStreamReader(iStr);
            String rolapModel = this.locateRolapSource();
            ToolBox.Assert(rolapModel != null && rolapModel.length() > 0, "Expecting a valid ROLAP content");
            this.parseROLAPCubeSpec(rolapModel);
        }
        catch (Exception st) {
            throw new RuntimeException(st.getMessage(), st);
        }
        ToolBox.logPerfIndicators("/parseModel/setup//time", b4);
    }

    private void parseROLAPCubeSpec(String rolapModel) {
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(IOUtils.toInputStream((String)rolapModel));
            this.mRolapRoot = document.getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException("Failed to parse the rolap model!", e);
        }
    }

    private String locateRolapSource() throws XMLStreamException {
        String out = null;
        while (this.moveToTag("property", "namespace")) {
            String sName = this.mParser.getAttributeValue(null, "name");
            if (!"ROLAPSource".equals(sName)) continue;
            out = this.mParser.getElementText();
        }
        return out;
    }

    private boolean moveToTag(String localName, String parentContext) throws XMLStreamException {
        int next = this.mParser.next();
        while (next != 8) {
            if (next == 1 && localName.equals(this.mParser.getLocalName())) {
                return true;
            }
            if (next == 2 && parentContext != null && parentContext.equals(this.mParser.getLocalName())) {
                return false;
            }
            next = this.mParser.next();
        }
        return false;
    }
}

