/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import java.util.List;

public final class ActivationSpread {
    private static final short MAX_ACTIVE_CONCEPT = 10;
    private static final float INITIAL_ACTIVATION = 1.0f;
    private static final float RELATED_SPREAD_FACTOR = 0.75f;
    private static final float WHOLE_PART_SPREAD_FACTOR = 0.75f;
    private static final float SPREAD_THRESHOLD = 0.7f;
    private static int gCreated = 0;
    private Concept[] mActivated = null;
    private float[] mActivation = null;
    private short mIdx = 0;

    static ActivationSpread activate(ConceptInventory kb, Concept c) {
        ++gCreated;
        ActivationSpread as = new ActivationSpread(c);
        as.spread(kb, c, 1.0f);
        return as;
    }

    static int getCreated() {
        return gCreated;
    }

    ActivationSpread(Concept c) {
        List<IRelation> rels = c.getOutRelations();
        int lowerBound = rels.size();
        this.mActivated = new Concept[lowerBound + 10];
        this.mActivation = new float[lowerBound + 10];
    }

    public Concept[] getConcepts() {
        return this.mActivated;
    }

    public float[] getActivations() {
        return this.mActivation;
    }

    public short getSize() {
        return this.mIdx;
    }

    private void spread(ConceptInventory kb, Concept c, float inActv) {
        this.mActivated[this.mIdx] = c;
        this.mActivation[this.mIdx] = inActv;
        this.mIdx = (short)(this.mIdx + 1);
        if (c.isAttribute()) {
            return;
        }
        this.spreadToRelations(kb, c, inActv, true);
        this.spreadToRelations(kb, c, inActv, false);
    }

    private void spreadToRelations(ConceptInventory kb, Concept c, float inActv, boolean bOutBound) {
        List<IRelation> rels = bOutBound ? c.getOutRelations() : c.getInRelations();
        for (IRelation r : rels) {
            IConcept otherEnd;
            IConcept iConcept = otherEnd = bOutBound ? r.getToEnd() : r.getFromEnd();
            if (kb.getConcept(otherEnd.getName()) == null) continue;
            float outActv = 0.0f;
            if (r.isWholePart()) {
                outActv = inActv * 0.75f;
            } else {
                if (otherEnd.isCommonAttribute()) continue;
                ECardinality eCard = r.getCardinality();
                if (eCard == ECardinality.OneOne || bOutBound && eCard == ECardinality.ManyOne || !bOutBound && eCard == ECardinality.OneMany) {
                    outActv = inActv * 0.75f;
                }
            }
            if (!(outActv > 0.7f)) continue;
            this.spread(kb, (Concept)otherEnd, outActv);
        }
    }
}

