/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.smd.kb.BusinessAreaAnalysis;
import com.ibm.cognos.smd.kb.BusinessAreaApplicability;
import com.ibm.cognos.smd.kb.BusinessDomain;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.SignifierContainer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public final class BusinessArea {
    private String mName;
    private ExtensionSource mExtensionSource;
    private BusinessDomain mBasedOnDomain;
    private SignifierContainer mSignifierContainer;
    private List<Concept> mAreaConcepts = new ArrayList<Concept>(20);
    private List<BusinessAreaAnalysis> mAnalyses = new ArrayList<BusinessAreaAnalysis>();

    BusinessArea(ExtensionSource extSource, String aName, BusinessDomain baseDomain) {
        this.mName = aName;
        this.mExtensionSource = extSource;
        this.mBasedOnDomain = baseDomain;
    }

    public String getName() {
        return this.mName;
    }

    public BusinessDomain getDomian() {
        return this.mBasedOnDomain;
    }

    public List<BusinessAreaAnalysis> getAnalyses() {
        return this.mAnalyses;
    }

    ConceptInventory getConceptInventory() {
        return this.mExtensionSource.getConceptInventory();
    }

    void collectSignifierContainers(List<SignifierContainer> containers) {
        if (this.mSignifierContainer != null) {
            containers.add(this.mSignifierContainer);
        }
    }

    void setup(Element elmSpec) {
        Element elmSignifiers;
        Element elmConcepts = elmSpec.element("concepts");
        if (elmConcepts != null) {
            this.getConceptInventory().loadConcepts(elmConcepts, this.mAreaConcepts);
        }
        if ((elmSignifiers = elmSpec.element("conceptSignifiers")) != null) {
            this.mSignifierContainer = new SignifierContainer(this.mExtensionSource);
            this.mSignifierContainer.setup(elmSignifiers);
        }
        List listAnalyses = elmSpec.selectNodes("analyses/analysis");
        for (Element elmAnalysis : listAnalyses) {
            BusinessAreaAnalysis analysis = BusinessAreaAnalysis.create(this, elmAnalysis);
            this.mAnalyses.add(analysis);
        }
    }

    void findApplicableBusinessAreas(List<IConcept> modelConcepts, List<BusinessAreaApplicability> vOut) {
        int totalMatches = 0;
        for (Concept c : this.mBasedOnDomain.getConcepts()) {
            if (!modelConcepts.contains(c)) continue;
            ++totalMatches;
        }
        for (Concept c : this.mAreaConcepts) {
            if (!modelConcepts.contains(c)) continue;
            ++totalMatches;
        }
        float rate = (float)totalMatches / (float)(this.mBasedOnDomain.getConcepts().size() + this.mAreaConcepts.size());
        if (rate > 0.3f) {
            vOut.add(new BusinessAreaApplicability(this, rate));
        }
    }
}

