/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.smd.kb.BusinessArea;
import com.ibm.cognos.smd.kb.ConceptInventory;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public final class BusinessAreaAnalysis {
    private BusinessArea mBusinessArea;
    private String mName;
    private String mDescription;
    private String mAnlaysisTemplate;
    private List<Slot> mSlots = new ArrayList<Slot>(5);

    static BusinessAreaAnalysis create(BusinessArea ba, Element elmAnalysis) {
        String aName = elmAnalysis.attributeValue("name");
        ToolBox.Assert(aName != null && aName.length() > 0, "Expecting a valid name for 'analysis'");
        BusinessAreaAnalysis baa = new BusinessAreaAnalysis(ba, aName);
        baa.setup(elmAnalysis);
        return baa;
    }

    public String getName() {
        return this.mName;
    }

    public BusinessArea getBusinessArea() {
        return this.mBusinessArea;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getAnalysisTemplateName() {
        return this.mAnlaysisTemplate;
    }

    public List<Slot> getSlots() {
        return this.mSlots;
    }

    private BusinessAreaAnalysis(BusinessArea ba, String name) {
        this.mName = name;
        this.mBusinessArea = ba;
    }

    private void setup(Element elmAnalysis) {
        this.mAnlaysisTemplate = elmAnalysis.attributeValue("analysisTemplate");
        ToolBox.Assert(this.mAnlaysisTemplate != null && this.mAnlaysisTemplate.length() > 0, "Expecting a valid 'analysisTemplate' for analysis:", this.mName);
        this.mDescription = elmAnalysis.attributeValue("desc");
        ConceptInventory kb = this.mBusinessArea.getConceptInventory();
        List listSlots = elmAnalysis.elements("slot");
        for (Element elmSlot : listSlots) {
            String[] sConcepts;
            String aName = elmSlot.attributeValue("name");
            ToolBox.Assert(aName != null && aName.length() > 0, "Expecting a valid 'name' attribute for the slot of analysis ", this.mName);
            String sFilledWith = elmSlot.attributeValue("filledWith");
            ToolBox.Assert(sFilledWith != null && sFilledWith.length() > 0, "Expecting a valid 'filledWith' attribute for analysis slot: ", aName);
            Slot newSlot = new Slot(aName);
            this.mSlots.add(newSlot);
            for (String sConcept : sConcepts = sFilledWith.split("\\s+")) {
                IConcept c = kb.getConcept(sConcept);
                ToolBox.Assert(c != null, "Unable to look up concept ", sConcept, " when processing analysis ", this.mName);
                newSlot.addFiller(c);
            }
        }
    }

    public static class Slot {
        private String mName;
        private List<IConcept> mPossibleFillers = new ArrayList<IConcept>(5);

        Slot(String name) {
            this.mName = name;
        }

        void addFiller(IConcept c) {
            this.mPossibleFillers.add(c);
        }

        public String getName() {
            return this.mName;
        }

        public List<IConcept> getFillerConcepts() {
            return this.mPossibleFillers;
        }
    }
}

