/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.smd.kb.BusinessArea;
import com.ibm.cognos.smd.kb.BusinessAreaApplicability;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ExtensionSource;
import com.ibm.cognos.smd.kb.SignifierContainer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public final class BusinessDomain {
    private String mName;
    private BusinessDomain mBaseDomain;
    private ExtensionSource mExtensionSource;
    private SignifierContainer mSignifierContainer;
    private List<BusinessArea> mBusinessAreas = new ArrayList<BusinessArea>();
    private List<Concept> mDomainConcepts = new ArrayList<Concept>(20);

    BusinessDomain(ExtensionSource extSource, String dName, BusinessDomain baseDomain) {
        this.mName = dName;
        this.mBaseDomain = baseDomain;
        this.mExtensionSource = extSource;
    }

    public String getName() {
        return this.mName;
    }

    public BusinessDomain getBaseDomain() {
        return this.mBaseDomain;
    }

    List<Concept> getConcepts() {
        return this.mDomainConcepts;
    }

    void addAreaOfAnalysis(BusinessArea ba) {
        this.mBusinessAreas.add(ba);
    }

    void collectSignifierContainers(List<SignifierContainer> containers) {
        if (this.mSignifierContainer != null) {
            containers.add(this.mSignifierContainer);
        }
        for (BusinessArea ba : this.mBusinessAreas) {
            ba.collectSignifierContainers(containers);
        }
    }

    void setup(Element elmSpec) {
        Element elmSignifiers;
        Element elmConcepts = elmSpec.element("concepts");
        if (elmConcepts != null) {
            this.mExtensionSource.getConceptInventory().loadConcepts(elmConcepts, this.mDomainConcepts);
        }
        if ((elmSignifiers = elmSpec.element("conceptSignifiers")) != null) {
            this.mSignifierContainer = new SignifierContainer(this.mExtensionSource);
            this.mSignifierContainer.setup(elmSignifiers);
        }
    }

    void findApplicableBusinessAreas(List<IConcept> modelConcepts, List<BusinessAreaApplicability> vOut) {
        for (BusinessArea ba : this.mBusinessAreas) {
            ba.findApplicableBusinessAreas(modelConcepts, vOut);
        }
    }
}

