/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.LexicalClueInventory;
import com.ibm.cognos.smd.kb.Signifier;
import com.ibm.cognos.smd.kb.SignifierData;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CascadingLexicalClueResolver {
    private final LexicalClueInventory mPrimaryClues;
    private final LexicalClueInventory mDefaultClues;

    public CascadingLexicalClueResolver(LexicalClueInventory primaryClues, LexicalClueInventory defaultClues) {
        this.mPrimaryClues = primaryClues;
        this.mDefaultClues = defaultClues;
    }

    public SignifierData getDataSignifier(Concept c) {
        SignifierData signifier = this.mPrimaryClues.getDataSignifier(c);
        if (signifier == null && this.mDefaultClues != null) {
            signifier = this.mDefaultClues.getDataSignifier(c);
        }
        return signifier;
    }

    public Set<String> getLexicalClues() {
        return this.mPrimaryClues.getLexicalClues();
    }

    public Set<String> getLexicalCluesForConcepts(List<Concept> concepts) {
        return this.mPrimaryClues.getLexicalCluesForConcepts(concepts);
    }

    private Map<Signifier, Float> collectSignifiers(List<String> multiPartClue, List<String> usedClues) {
        ArrayList<String> clues = new ArrayList<String>(multiPartClue);
        if (usedClues == null) {
            usedClues = new ArrayList<String>();
        } else {
            usedClues.clear();
        }
        Map<Signifier, Float> signifiers = this.mPrimaryClues.collectSignifiers(clues, usedClues);
        clues.removeAll(usedClues);
        if (!multiPartClue.isEmpty() && this.mDefaultClues != null) {
            signifiers.putAll(this.mDefaultClues.collectSignifiers(clues, usedClues));
        }
        return signifiers;
    }

    public List<ActivationSpread> getActivationFor(List<String> multiPartClue, DataItemExtension dix) {
        Map<Signifier, Float> signifiers = this.collectSignifiers(multiPartClue, null);
        return this.mPrimaryClues.getActivationFor(signifiers, dix);
    }

    public boolean evaluateSignifier(String signifierName, DataItemExtension dix) {
        Signifier sig = this.mPrimaryClues.lookupSignifierByName(signifierName);
        if (sig == null && this.mDefaultClues != null) {
            sig = this.mDefaultClues.lookupSignifierByName(signifierName);
        }
        ToolBox.Assert(sig != null, "UNable to lookup signifier by name:", signifierName);
        float match = sig.evaluateLabel(dix.getNameLemmas());
        return (double)match > 0.0;
    }
}

