/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.kb.CascadingLexicalClueResolver;
import com.ibm.cognos.smd.kb.ConceptInstances;
import com.ibm.cognos.smd.kb.DataHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Concept
implements IConcept {
    private static final String DEFAULT_SORT_ORDER = "ascending";
    private String mName;
    private Concept mBaseConcept;
    private String mDesc;
    private Map<String, String> mPropValues;
    private List<String> mIsAs = new ArrayList<String>(3);
    private List<IRelation> mInRelations = new ArrayList<IRelation>(3);
    private List<IRelation> mOutRelations = new ArrayList<IRelation>(3);
    private DataHints mDataHints = null;
    private boolean mIsSelfPartWhole = false;
    private List<IConcept.EConceptClass> mSupportedClassifications;
    private List<IConcept> mQualifiers = null;
    private ConceptInstances mInstances = null;

    Concept(String name) {
        this.mName = name;
    }

    public final String getName() {
        return this.mName;
    }

    final void setDescription(String desc) {
        this.mDesc = desc;
    }

    public final String getDescription() {
        return this.mDesc;
    }

    final void setDataHints(DataHints dh) {
        this.mDataHints = dh;
    }

    void addIsA(String isA) {
        this.mIsAs.add(isA);
    }

    void setBaseConcept(Concept cBase) {
        this.mBaseConcept = cBase;
    }

    public IConcept getBaseConcept() {
        return this.mBaseConcept;
    }

    public DataHints getDataHints() {
        return this.mDataHints;
    }

    public List<String> getIsAs() {
        return this.mIsAs;
    }

    public boolean isA(String type) {
        return this.mIsAs.contains(type);
    }

    public boolean isAttribute() {
        return this.isA("attribute");
    }

    public boolean isCommonAttribute() {
        return "cCaption".equals(this.mName) || "cIdentifier".equals(this.mName) || "cDescription".equals(this.mName);
    }

    public boolean isTemporal() {
        return this.isA("temporal");
    }

    public boolean isGeographic() {
        return this.isA("geographic");
    }

    public boolean isCategory() {
        return this.isA("category");
    }

    public boolean isMetric() {
        return this.isA("metric");
    }

    public boolean instanceOf(IConcept.EConceptClass cc) {
        return this.mIsAs.contains(cc.toString());
    }

    public boolean is(IConcept c) {
        if (this.equals(c)) {
            return true;
        }
        Concept base = this.mBaseConcept;
        while (base != null) {
            if (base.equals(c)) {
                return true;
            }
            base = base.mBaseConcept;
        }
        return false;
    }

    public boolean is(String cName) {
        if (this.getName().equals(cName)) {
            return true;
        }
        Concept base = this.mBaseConcept;
        while (base != null) {
            if (base.getName().equals(cName)) {
                return true;
            }
            base = base.mBaseConcept;
        }
        return false;
    }

    void setSelfPartWhole(boolean flag) {
        this.mIsSelfPartWhole = flag;
    }

    public boolean isSelfPartWhole() {
        return this.mIsSelfPartWhole;
    }

    void addProperty(String name, String value) {
        if (this.mPropValues == null) {
            this.mPropValues = new HashMap<String, String>();
        }
        this.mPropValues.put(name, value);
    }

    public Set<String> getPropertyNames() {
        if (null == this.mPropValues) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mPropValues.keySet());
    }

    public String getProperty(String name) {
        if ("defSortOrder".equals(name)) {
            return this.getSortOrder();
        }
        String outValue = null;
        if (this.mPropValues != null) {
            outValue = this.mPropValues.get(name);
        }
        if (outValue != null) {
            return outValue;
        }
        return this.getInheritedProperty(name);
    }

    private String getInheritedProperty(String name) {
        String outValue = null;
        Concept base = this.mBaseConcept;
        while (base != null) {
            if (base.mPropValues != null) {
                outValue = base.mPropValues.get(name);
            }
            if (outValue != null) {
                return outValue;
            }
            base = base.mBaseConcept;
        }
        return outValue;
    }

    public DataHints getApplicableDataHints() {
        if (this.mDataHints != null) {
            return this.mDataHints;
        }
        Concept base = this.mBaseConcept;
        while (base != null) {
            if (base.mDataHints != null) {
                return base.mDataHints;
            }
            base = base.mBaseConcept;
        }
        return null;
    }

    public List<IRelation> getInRelations() {
        return this.mInRelations;
    }

    public List<IRelation> getOutRelations() {
        return this.mOutRelations;
    }

    public boolean isInWholePartRelationship() {
        for (IRelation r : this.mOutRelations) {
            if (!r.isWholePart()) continue;
            return true;
        }
        for (IRelation r : this.mInRelations) {
            if (!r.isWholePart()) continue;
            return true;
        }
        return false;
    }

    public boolean isWholePartRoot() {
        return !this.hasWholePartRels(true) && this.hasWholePartRels(false);
    }

    private boolean hasWholePartRels(boolean in) {
        List<IRelation> eItr = in ? this.mInRelations : this.mOutRelations;
        for (IRelation e : eItr) {
            if (!e.isWholePart()) continue;
            return true;
        }
        return false;
    }

    public List<IConcept> getQualifiers() {
        if (this.mQualifiers != null) {
            return this.mQualifiers;
        }
        Concept base = this.mBaseConcept;
        while (base != null) {
            if (base.mQualifiers != null) {
                return base.mQualifiers;
            }
            base = base.mBaseConcept;
        }
        return null;
    }

    void setSupportedClassifications(String[] classifications) {
        if (this.mSupportedClassifications == null) {
            this.mSupportedClassifications = new ArrayList<IConcept.EConceptClass>(classifications.length);
        }
        for (int idx = 0; idx < classifications.length; ++idx) {
            this.mSupportedClassifications.add(IConcept.EConceptClass.valueOf((String)classifications[idx]));
        }
    }

    void addQualifier(Concept aConcept) {
        if (this.mQualifiers == null) {
            this.mQualifiers = new ArrayList<IConcept>(3);
        }
        this.mQualifiers.add(aConcept);
    }

    void setInstanceContainer(ConceptInstances anInstanceContainer) {
        this.mInstances = anInstanceContainer;
    }

    public String matchInstances(CascadingLexicalClueResolver anInventory, DataItemExtension dix) {
        String out = null;
        if (this.mInstances != null) {
            out = this.mInstances.match(anInventory, dix);
        }
        return out;
    }

    public boolean supportsClassification(IConcept.EConceptClass eClass) {
        if (this.isA(eClass.toString())) {
            return true;
        }
        return this.mSupportedClassifications != null && this.mSupportedClassifications.contains(eClass);
    }

    public List<IConcept> getParts() {
        ArrayList<IConcept> out = new ArrayList<IConcept>(5);
        this.getParts(out);
        return out;
    }

    private void getParts(List<IConcept> parts) {
        for (IRelation r : this.mOutRelations) {
            if (!r.isWholePart()) continue;
            Concept cPart = (Concept)r.getToEnd();
            parts.add(cPart);
            if (cPart.equals(this)) continue;
            cPart.getParts(parts);
        }
    }

    public List<Concept> getImmediateParts() {
        ArrayList<Concept> out = new ArrayList<Concept>(3);
        for (IRelation r : this.mOutRelations) {
            if (!r.isWholePart()) continue;
            Concept cPart = (Concept)r.getToEnd();
            out.add(cPart);
        }
        return out;
    }

    public boolean isValidPart(Concept inPart) {
        for (IRelation r : this.mOutRelations) {
            if (!r.isWholePart()) continue;
            Concept cPart = (Concept)r.getToEnd();
            if (cPart.is(inPart) || inPart.is(cPart)) {
                return true;
            }
            if (cPart.is(this) || !cPart.isValidPart(inPart)) continue;
            return true;
        }
        if ("cGeography".equals(inPart.getName())) {
            return this.isGeographic();
        }
        if ("cGeography".equals(this.getName())) {
            return inPart.isGeographic();
        }
        return false;
    }

    public boolean isValidWhole(Concept inWhole) {
        for (IRelation r : this.mInRelations) {
            if (!r.isWholePart()) continue;
            Concept cWhole = (Concept)r.getFromEnd();
            if (cWhole.is(inWhole) || inWhole.is(cWhole)) {
                return true;
            }
            if (cWhole.is(this) || !cWhole.isValidWhole(inWhole)) continue;
            return true;
        }
        if ("cGeography".equals(inWhole.getName())) {
            return this.isGeographic();
        }
        if ("cGeography".equals(this.getName())) {
            return inWhole.isGeographic();
        }
        return false;
    }

    void addInRelation(IRelation r) {
        this.mInRelations.add(r);
    }

    void addOutRelation(IRelation r) {
        this.mOutRelations.add(r);
    }

    public boolean isRelatedTo(IConcept that) {
        return this.findRelationTo(that) != null || this.findRelationFrom(that) != null;
    }

    public IRelation findRelationTo(IConcept that) {
        for (IRelation r : this.mOutRelations) {
            if (!r.getToEnd().equals(that)) continue;
            return r;
        }
        return null;
    }

    IRelation findRelationToImplied(IConcept that) {
        for (IRelation r : this.mOutRelations) {
            if (!r.getToEnd().is(that)) continue;
            return r;
        }
        return null;
    }

    public IRelation findRelationFrom(IConcept that) {
        for (IRelation r : this.mInRelations) {
            if (!r.getFromEnd().equals(that)) continue;
            return r;
        }
        return null;
    }

    public String asXML() {
        StringBuilder sb = new StringBuilder("<concept name=\"");
        sb.append(this.mName);
        sb.append("\"><isA>");
        for (String string : this.mIsAs) {
            sb.append(string);
            sb.append(" ");
        }
        sb.append("</isA>");
        if (this.mPropValues != null) {
            for (Map.Entry entry : this.mPropValues.entrySet()) {
                sb.append("<prop name=\"");
                sb.append((String)entry.getKey());
                sb.append("\" value=\"");
                sb.append((String)entry.getValue());
                sb.append("\"/>");
            }
        }
        sb.append("</concept>");
        return sb.toString();
    }

    public List<IConcept> getMetricConceptsInScope() {
        if (!this.isCategory()) {
            return null;
        }
        List<IConcept> out = this.getReferenceToConcepts(IConcept.EConceptClass.metric);
        for (IRelation ir : this.mInRelations) {
            Concept another = (Concept)ir.getFromEnd();
            List<IConcept> toAdd = another.getReferenceToConcepts(IConcept.EConceptClass.metric);
            for (IConcept c : toAdd) {
                if (out.contains(c)) continue;
                out.add(c);
            }
        }
        return out;
    }

    public boolean isInScopeWith(IConcept other) {
        Concept cCategory = null;
        Concept cMetric = null;
        if (this.isCategory() && other.isMetric()) {
            cCategory = this;
            cMetric = (Concept)other;
        } else if (this.isMetric() && other.isCategory()) {
            cCategory = (Concept)other;
            cMetric = this;
        } else {
            return false;
        }
        boolean out = cCategory.isRelatedTo(cMetric);
        if (out) {
            return true;
        }
        HashSet<IConcept> intersection = new HashSet<IConcept>(cCategory.getReferencedByConcepts(null));
        intersection.retainAll(cMetric.getReferencedByConcepts(null));
        return !intersection.isEmpty();
    }

    private List<IConcept> getReferencedByConcepts(IConcept.EConceptClass eClass) {
        ArrayList<IConcept> out = new ArrayList<IConcept>(this.mInRelations.size());
        for (IRelation ir : this.mInRelations) {
            IConcept cRef = ir.getFromEnd();
            if (eClass != null && cRef.instanceOf(eClass)) {
                out.add(cRef);
                continue;
            }
            if (eClass != null) continue;
            out.add(cRef);
        }
        return out;
    }

    private List<IConcept> getReferenceToConcepts(IConcept.EConceptClass eClass) {
        ArrayList<IConcept> out = new ArrayList<IConcept>(this.mOutRelations.size());
        for (IRelation or : this.mOutRelations) {
            IConcept cRef = or.getToEnd();
            if (eClass != null && cRef.instanceOf(eClass)) {
                out.add(cRef);
                continue;
            }
            if (eClass != null) continue;
            out.add(cRef);
        }
        return out;
    }

    public String toString() {
        return this.mName;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IConcept)) {
            return false;
        }
        Concept other = (Concept)o;
        return this.mName.equals(other.mName);
    }

    private String getSortOrder() {
        String aValue;
        if (this.isMetric()) {
            return null;
        }
        String out = DEFAULT_SORT_ORDER;
        if (this.mPropValues != null && (aValue = this.mPropValues.get("defSortOrder")) != null && aValue.length() > 0) {
            out = aValue;
        }
        return out;
    }
}

