/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.kb.CascadingLexicalClueResolver;
import java.util.ArrayList;
import java.util.List;

public class ConceptInstances {
    private String mType;
    private List<Instance> mInstances = new ArrayList<Instance>(5);

    ConceptInstances(String type) {
        this.mType = type;
    }

    String match(CascadingLexicalClueResolver anInventory, DataItemExtension dix) {
        for (Instance aVal : this.mInstances) {
            if (!anInventory.evaluateSignifier(aVal.getSigRef(), dix)) continue;
            return aVal.getSymbol();
        }
        return null;
    }

    void addInstance(String val, String sigRef) {
        this.mInstances.add(new Instance(val, sigRef));
    }

    List<Instance> getValues() {
        return this.mInstances;
    }

    private static class Instance {
        private String mSymbol;
        private String mSigRef;

        Instance(String val, String sigRef) {
            this.mSymbol = val;
            this.mSigRef = sigRef;
        }

        String getSymbol() {
            return this.mSymbol;
        }

        String getSigRef() {
            return this.mSigRef;
        }
    }
}

