/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.api.smd.kb.IConceptInventory;
import com.ibm.cognos.aurora.api.smd.kb.IRelation;
import com.ibm.cognos.smd.kb.ActivationSpread;
import com.ibm.cognos.smd.kb.Concept;
import com.ibm.cognos.smd.kb.ConceptInstances;
import com.ibm.cognos.smd.kb.DataHints;
import com.ibm.cognos.smd.kb.Relation;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ConceptInventory
implements IConceptInventory {
    private static final String DEFAULT_KB_RESOURCE = "/config/KnowledgeBase.xml";
    static final List<String> gCategories = Arrays.asList("category", "geographic", "goodsService", "institution", "nominal", "temporal");
    static final List<String> gMetrics = Arrays.asList("metric", "count", "distance", "duration", "monetary", "ratio", "volume", "weight");
    private static ConceptInventory gInstance = null;
    private Map<String, Concept> mConcepts = new HashMap<String, Concept>(200);
    private List<Concept> mPlaceHolders = new ArrayList<Concept>(10);
    private short mRelationNo = 0;
    private Concept mAttributeCaption;
    private Concept mAttributeIdentifier;
    private Map<Concept, ActivationSpread> mConcept2Activation = new HashMap<Concept, ActivationSpread>(200);

    static ConceptInventory getCoreInventory() {
        return gInstance;
    }

    protected ConceptInventory() {
    }

    private void initializeCore() {
        this.loadCoreSource();
        this.calculateActivationSpreads();
        this.initializeMembers();
    }

    protected void initializeMembers() {
        this.mAttributeCaption = (Concept)this.getConcept("cCaption");
        this.mAttributeIdentifier = (Concept)this.getConcept("cIdentifier");
    }

    public IConcept getConcept(String name) {
        return this.mConcepts.get(name);
    }

    public IConcept getGenericAttribute() {
        IConcept gm = this.getConcept("cAttribute");
        ToolBox.Assert(gm != null, "Expecting a valid 'generic' attribute");
        return gm;
    }

    public IConcept getGenericCategory() {
        IConcept gc = this.getConcept("cCategory");
        ToolBox.Assert(gc != null, "Expecting a valid 'generic' category");
        return gc;
    }

    public IConcept getGenericMetric() {
        IConcept gm = this.getConcept("cMetric");
        ToolBox.Assert(gm != null, "Expecting a valid 'generic' metric");
        return gm;
    }

    public IConcept getGenericNominal() {
        IConcept gm = this.getConcept("cNominal");
        ToolBox.Assert(gm != null, "Expecting a valid 'generic' nominal category");
        return gm;
    }

    public IConcept getGenericTemporal() {
        IConcept gm = this.getConcept("cTemporal");
        ToolBox.Assert(gm != null, "Expecting a valid 'generic' temporal category");
        return gm;
    }

    public Concept getIdentifierAttribute() {
        return this.mAttributeIdentifier;
    }

    public Concept getCaptionAttribute() {
        return this.mAttributeCaption;
    }

    public ActivationSpread getActivationSpread(Concept c) {
        return this.mConcept2Activation.get(c);
    }

    public void collectAllConcepts(List<Concept> out) {
        for (Map.Entry<String, Concept> e : this.mConcepts.entrySet()) {
            out.add(e.getValue());
        }
    }

    protected Map<String, Concept> getConcepts() {
        return this.mConcepts;
    }

    void loadConcepts(Element elmRoot, List<Concept> loadedConcepts) {
        List elmConcepts = elmRoot.elements();
        for (Element elmCon : elmConcepts) {
            Concept newCon = this.newConcept(elmCon);
            if (loadedConcepts == null) continue;
            loadedConcepts.add(newCon);
        }
    }

    void calculateActivationSpreads() {
        this.ensureAllReferencesAreResolved();
        long b4 = ToolBox.logPerfIndicators("/KB/activationSpreads/time", 0L);
        this.doCalculateActivationSpreads(this.mConcepts);
        ToolBox.trace("/KB/activationSpreads/totalActivationSpreadPatterns", Integer.toString(ActivationSpread.getCreated()));
        ToolBox.logPerfIndicators("/KB/activationSpreads/time", b4);
    }

    protected void doCalculateActivationSpreads(Map<String, Concept> conceptMap) {
        for (Map.Entry<String, Concept> e : conceptMap.entrySet()) {
            ActivationSpread as = ActivationSpread.activate(this, e.getValue());
            this.mConcept2Activation.put(e.getValue(), as);
        }
    }

    protected void ensureAllReferencesAreResolved() {
        if (!this.mPlaceHolders.isEmpty()) {
            StringBuilder sb = new StringBuilder("Some concepts are unresolved:");
            for (Concept c : this.mPlaceHolders) {
                sb.append(c.getName());
                sb.append(", ");
            }
            ToolBox.Assert(false, sb.toString());
        }
    }

    private Concept newConcept(Element elmConcept) {
        String aValue = elmConcept.attributeValue("name");
        ToolBox.Assert(aValue != null && aValue.length() > 0, "Expecting a valid name for concept");
        Concept newCon = this.findOrAddConcept(aValue);
        aValue = elmConcept.attributeValue("desc");
        if (aValue != null && aValue.length() > 0) {
            newCon.setDescription(aValue);
        }
        this.addIsAProperties(newCon, elmConcept.getName());
        String baseConcept = null;
        List listChildren = elmConcept.elements();
        for (Element elmChild : listChildren) {
            String tagName = elmChild.getName();
            if ("dataHints".equals(tagName)) {
                DataHints dh = this.parseDataHints(elmChild);
                newCon.setDataHints(dh);
                continue;
            }
            if ("supportedClassifications".equals(tagName)) {
                newCon.setSupportedClassifications(elmChild.getText().split("\\s+"));
                continue;
            }
            if ("extends".equals(tagName)) {
                baseConcept = elmChild.getText();
                continue;
            }
            if ("has".equals(tagName)) {
                this.addRelation(newCon, false, elmChild);
                continue;
            }
            if ("hasPart".equals(tagName)) {
                this.addRelation(newCon, true, elmChild);
                continue;
            }
            if ("hasQualifier".equals(tagName)) {
                this.addQualifier(newCon, elmChild);
                continue;
            }
            if ("instances".equals(tagName)) {
                this.addConceptInstances(newCon, elmChild);
                continue;
            }
            newCon.addProperty(tagName, elmChild.getText());
        }
        if (baseConcept != null) {
            this.addInheritance(newCon, baseConcept);
        }
        ToolBox.Assert(!newCon.getIsAs().isEmpty(), "Expecting a valid type (isA element) for concept:", newCon.getName());
        return newCon;
    }

    private Concept addPlaceHolderConcept(String aName) {
        Concept c = new Concept(aName);
        this.mPlaceHolders.add(c);
        this.mConcepts.put(aName, c);
        return c;
    }

    private Concept findOrAddConcept(String aName) {
        for (Concept aPlaceHolder : this.mPlaceHolders) {
            if (!aPlaceHolder.getName().equals(aName)) continue;
            this.mPlaceHolders.remove(aPlaceHolder);
            return aPlaceHolder;
        }
        ToolBox.Assert(this.mConcepts.get(aName) == null, "A concept with the same name already exists:", aName);
        Concept c = new Concept(aName);
        this.mConcepts.put(aName, c);
        return c;
    }

    private void addInheritance(Concept c, String baseType) {
        Concept cBaseType = (Concept)this.getConcept(baseType);
        ToolBox.Assert(cBaseType != null, "Unable to find the base concept:", baseType);
        ToolBox.Assert(!cBaseType.equals(c), "Concept cannot inherit from self. Double check the definition for:", baseType);
        if (cBaseType.isAttribute()) {
            ToolBox.Assert(c.isAttribute(), "An 'Attribute' cannot be specified as base when extending:", c.getName());
            c.setBaseConcept(cBaseType);
        } else if (cBaseType.isCategory()) {
            ToolBox.Assert(c.isCategory(), "A 'Category' cannot be specified as base when extending:", c.getName());
            c.setBaseConcept(cBaseType);
            this.addInheritedRelationships(c, cBaseType);
        } else {
            ToolBox.Assert(c.isMetric(), "A 'Metric' cannot be specified as base when extending:", c.getName());
            c.setBaseConcept(cBaseType);
        }
    }

    private void addIsAProperties(Concept c, String conceptTag) {
        if ("attribute".equals(conceptTag)) {
            c.addIsA("attribute");
        } else {
            int idxCat = gCategories.indexOf(conceptTag);
            if (idxCat > -1) {
                c.addIsA("category");
                if (idxCat > 0) {
                    c.addIsA(conceptTag);
                }
            } else {
                int idxMet = gMetrics.indexOf(conceptTag);
                ToolBox.Assert(idxMet >= 0, "Unrecognised concept type:", conceptTag);
                c.addIsA("metric");
                if (idxMet > 0) {
                    c.addIsA(conceptTag);
                }
            }
        }
    }

    private void addInheritedRelationships(Concept cDerived, IConcept cBase) {
        for (IRelation r : cBase.getOutRelations()) {
            Concept endTo = (Concept)r.getToEnd();
            if (cDerived.findRelationToImplied(endTo) != null) continue;
            Relation nr = new Relation((IConcept)cDerived, (IConcept)endTo, r.getLabel(), r.getCardinality(), r.isWholePart());
            cDerived.addOutRelation(nr);
            endTo.addInRelation(nr);
        }
    }

    private DataHints parseDataHints(Element elmDataHints) {
        Element elmRegExpr;
        DataHints dataHints = new DataHints();
        List elmPatterns = elmDataHints.elements("pattern");
        for (Element elmPtrn : elmPatterns) {
            dataHints.addPatterns(elmPtrn.getText().split("\\s+"));
        }
        List elmRanges = elmDataHints.elements("range");
        for (Element elmRange : elmRanges) {
            String sFrom = elmRange.attributeValue("from");
            String sTo = elmRange.attributeValue("to");
            dataHints.addRange(sFrom, sTo);
        }
        Element elmDistinctVal = elmDataHints.element("distinctValuesCount");
        if (elmDistinctVal != null) {
            dataHints.setMaxDistinctValuesCount(Integer.parseInt(elmDistinctVal.attributeValue("max")));
        }
        if ((elmRegExpr = elmDataHints.element("regularExpression")) != null) {
            dataHints.setRegularExpression(elmRegExpr.getTextTrim());
        }
        return dataHints;
    }

    private void addRelation(Concept c, boolean isWholePart, Element elmRel) {
        this.mRelationNo = (short)(this.mRelationNo + 1);
        String card = elmRel.attributeValue("card");
        ToolBox.Assert(card != null && card.length() > 0, "Cardinality is a required attribute for a relationship spec:", elmRel.asXML());
        String relEndName = elmRel.getText();
        ToolBox.Assert(relEndName != null && relEndName.length() > 0, "The relationship specification is missing the other-end concept:", elmRel.asXML());
        Concept relEnd = (Concept)this.getConcept(relEndName);
        if (relEnd == null) {
            relEnd = this.addPlaceHolderConcept(relEndName);
        }
        ToolBox.Assert(!relEnd.isRelatedTo(c), "These concepts are already made related:", c.getName(), " and ", relEnd.getName());
        if (relEnd.equals(c)) {
            c.setSelfPartWhole(true);
        }
        Relation r = new Relation((IConcept)c, (IConcept)relEnd, elmRel.attributeValue("label"), card, isWholePart);
        c.addOutRelation(r);
        relEnd.addInRelation(r);
    }

    private void addQualifier(Concept c, Element elmQualifier) {
        String sQualifier = elmQualifier.getText();
        ToolBox.Assert(sQualifier != null && sQualifier.length() > 0, "The qualifier specification is missing the qualifier concept:", elmQualifier.asXML());
        Concept cQualifier = (Concept)this.getConcept(sQualifier);
        if (cQualifier == null) {
            cQualifier = this.addPlaceHolderConcept(sQualifier);
        }
        c.addQualifier(cQualifier);
    }

    private void addConceptInstances(Concept c, Element elmInstances) {
        String sType = elmInstances.attributeValue("type");
        ToolBox.Assert(sType != null && sType.length() > 0, "Type is a required attribute for a concept value:", elmInstances.asXML());
        ToolBox.Assert("signified".equals(sType), "Only values of type 'signified' are currently supported");
        ConceptInstances instContainer = new ConceptInstances(sType);
        c.setInstanceContainer(instContainer);
        List elmInsts = elmInstances.elements("inst");
        for (Element elmInst : elmInsts) {
            instContainer.addInstance(elmInst.getText(), elmInst.attributeValue("sigRef"));
        }
    }

    private void loadCoreSource() {
        long b4 = ToolBox.logPerfIndicators("/KB/setup/time", 0L);
        InputStream kbStream = null;
        try {
            kbStream = this.openKnowledgeBaseStream();
            try {
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(kbStream);
                Element elmRoot = document.getRootElement();
                this.loadConcepts(elmRoot, null);
                ToolBox.trace("/KB/setup/totalConcepts", Integer.toString(this.mConcepts.size()));
                ToolBox.trace("/KB/setup/totalRelations", Integer.toString(this.mRelationNo));
                ToolBox.logPerfIndicators("/KB/setup/time", b4);
            }
            catch (DocumentException e) {
                throw new RuntimeException("Failed to set up the knowledge base!", e);
            }
            finally {
                if (null != kbStream) {
                    kbStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set up the knowledge base!", e);
        }
    }

    private InputStream openKnowledgeBaseStream() throws IOException {
        InputStream str = this.getClass().getResourceAsStream(DEFAULT_KB_RESOURCE);
        if (str == null) {
            throw new RuntimeException("A knowledge base inventory file was not specified.");
        }
        return str;
    }

    static {
        gInstance = new ConceptInventory();
        gInstance.initializeCore();
    }
}

