/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.smd.analyzer.DataCollector;
import com.ibm.cognos.smd.analyzer.DataItemExtension;
import com.ibm.cognos.smd.analyzer.NominalDetector;
import com.ibm.cognos.smd.kb.KnowledgeBaseEnums;
import com.ibm.cognos.smd.utilities.SmdConfig;
import com.ibm.cognos.smd.utilities.ToolBox;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DataHints {
    private static final int UNDEFINED_DISTINCT_VAUE = -1;
    private static final int VALIDATE_REG_EXPRESSION_NUM_VALUES = SmdConfig.getInstance().getValue("dataHints", "maxDataValuesToCheckForRegExprMatch", 5);
    public static final float NotNull_DENSITY_THRESHOLD = SmdConfig.getInstance().getValue("dataHints", "minDensityForNotNull", 0.9f);
    private List<KnowledgeBaseEnums.EDataPattern[]> mPatterns;
    private List<Range> mRanges;
    private int mMaxDistinctValuesCount = -1;
    private Pattern mRegExpPattern = null;

    private boolean hasPrimitiveDataType(IDataItem di) {
        IDataType dType = di.getDataType();
        return dType.isNumeric() || dType.isString() || dType.isTemporal();
    }

    public float evaluateDataHints(DataItemExtension dix) {
        float out = -1.0f;
        if (this.mPatterns != null && this.hasPrimitiveDataType(dix.getDataItem()) && (out = (float)this.evaluatePatterns(dix)) == 1.0f) {
            return out;
        }
        if (dix.getDataItem().getStats().totalCount() <= 0L) {
            return out;
        }
        if (this.mRanges != null && (out = this.evaluateRanges(dix.getDataItem())) == 1.0f) {
            return out;
        }
        if (this.mMaxDistinctValuesCount != -1) {
            if (!dix.getDataItem().getDataType().isNumeric() || this.mRanges == null) {
                out = this.evaluateDistinctCount(dix.getDataItem());
            }
            if (out == 1.0f) {
                return out;
            }
        }
        if (this.mRegExpPattern != null) {
            out = this.evaluateRegularExpression(dix);
        }
        return out;
    }

    private float evaluateDistinctCount(IDataItem di) {
        if (di.getStats().distinctCount() <= (long)this.mMaxDistinctValuesCount) {
            return (float)di.getStats().distinctCount() / (float)this.mMaxDistinctValuesCount;
        }
        return 0.0f;
    }

    private int evaluateRegularExpression(DataItemExtension dix) {
        if (!dix.getDataItem().getDataType().isString()) {
            return 0;
        }
        List<IValue> sampleValues = dix.getSampleDataPoints();
        for (int idx = 0; idx < sampleValues.size() && idx < VALIDATE_REG_EXPRESSION_NUM_VALUES; ++idx) {
            String s = sampleValues.get(idx).stringValue();
            if (!this.mRegExpPattern.matcher(s).matches()) continue;
            return 1;
        }
        return 0;
    }

    private int evaluatePatterns(DataItemExtension dix) {
        for (KnowledgeBaseEnums.EDataPattern[] formats : this.mPatterns) {
            int out = this.evaluatePatternGroup(dix, formats);
            if (out != 1) continue;
            return 1;
        }
        return 0;
    }

    private float evaluateRanges(IDataItem di) {
        return DataHints.evaluateRanges(this.mRanges, di);
    }

    static float evaluateRanges(List<Range> vRanges, IDataItem di) {
        if (!di.getDataType().isNumeric()) {
            return 0.0f;
        }
        if (di.getStats().minValue() == null || di.getStats().maxValue() == null) {
            return -1.0f;
        }
        float min = di.getStats().minValue().floatValue();
        float max = di.getStats().maxValue().floatValue();
        for (Range r : vRanges) {
            boolean out = r.mFrom <= min && max <= r.mTo;
            if (!out) continue;
            return max / r.mTo;
        }
        return 0.0f;
    }

    private int evaluatePatternGroup(DataItemExtension dix, KnowledgeBaseEnums.EDataPattern[] formats) {
        IDataType dType = dix.getDataItem().getDataType();
        block17: for (KnowledgeBaseEnums.EDataPattern f : formats) {
            switch (f) {
                case Temporal: {
                    if (dType.isTemporal()) continue block17;
                    return 0;
                }
                case Integer: {
                    if (dType.isInteger()) continue block17;
                    return 0;
                }
                case Negative: {
                    if (dix.getDataItem().getStats().minValue().intValue() < 0) continue block17;
                    return 0;
                }
                case NoThousandSeparator: {
                    if (!this.valuesHaveThousandSeparator(dix)) continue block17;
                    return 0;
                }
                case NotNull: {
                    if (!DataHints.hasLowDensity(dix.getDataItem())) continue block17;
                    return 0;
                }
                case RowIdentifier: {
                    if (this.evaluateRowIdentifier(dix)) continue block17;
                    return 0;
                }
                case String: {
                    if (dType.isString()) continue block17;
                    return 0;
                }
                case Numeric: {
                    if (dType.isNumeric()) continue block17;
                    return 0;
                }
                case OrderedValues: {
                    if (this.evaluateHasOrderedValues(dix)) continue block17;
                    return 0;
                }
                case Positive: {
                    if (dix.getDataItem().getStats().minValue() == null || dix.getDataItem().getStats().minValue().intValue() >= 0) continue block17;
                    return 0;
                }
                case UniformValues: {
                    if (dix.getDataItem().getStats().totalCount() <= 0L || this.evaluateUniformValues(dix)) continue block17;
                    return 0;
                }
                case HighValueRepetition: {
                    if (NominalDetector.hasHighRepetition(dix.getDataItem())) continue block17;
                    return 0;
                }
                case LowValueRepetition: {
                    if (!NominalDetector.hasHighRepetition(dix.getDataItem())) continue block17;
                    return 0;
                }
                case YY: {
                    if (this.evaluateYearDigits(dix, true)) continue block17;
                    return 0;
                }
                case YYYY: {
                    if (this.evaluateYearDigits(dix, false)) continue block17;
                    return 0;
                }
                default: {
                    ToolBox.Assert(false, "Unexpected format pattern: ", f.toString());
                }
            }
        }
        return 1;
    }

    public static boolean hasLowDensity(IDataItem di) {
        return di.getStats().totalCount() > 0L && di.getStats().density() < NotNull_DENSITY_THRESHOLD;
    }

    private boolean valuesHaveThousandSeparator(DataItemExtension dix) {
        for (IValueDecoration vd : dix.getDataItem().getValueDecorations()) {
            if (!vd.isThousandsSeparator()) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateUniformValues(DataItemExtension dix) {
        IDataType dt = dix.getDataItem().getDataType();
        if (dt.isNumeric()) {
            return this.evaluateUniformNumricValues(dix);
        }
        if (dt.isString()) {
            return this.evaluateUniformStringValues(dix);
        }
        return false;
    }

    private boolean evaluateUniformStringValues(DataItemExtension dix) {
        int len = -1;
        for (IValue v : dix.getSampleDataPoints()) {
            String s;
            if (!v.isOK() || v.isNull() || (s = v.stringValue()) == null || s.length() == 0) continue;
            if (len == -1) {
                len = s.length();
                continue;
            }
            if (len == s.length()) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateUniformNumricValues(DataItemExtension dix) {
        int maxLen;
        IDataItem di = dix.getDataItem();
        if (di.getStats().minValue() == null || di.getStats().maxValue() == null || di.getStats().minValue().isNull() || di.getStats().maxValue().isNull()) {
            return false;
        }
        int minLen = di.getStats().minValue().stringValue().length();
        return minLen == (maxLen = di.getStats().maxValue().stringValue().length());
    }

    private boolean evaluateRowIdentifier(DataItemExtension dix) {
        IDataItemStats stats = dix.getDataItem().getStats();
        return dix.getDataItemIndex() == 0 && stats.distinctCount() == stats.count();
    }

    private boolean evaluateHasOrderedValues(DataItemExtension dix) {
        IValueIterator vItr = dix.getDataItem().fetchValues((long)DataCollector.SAMPLE_MAX_ROW_OneOne_ASSOCIATION);
        IValue first = null;
        while (vItr.hasNext() && first == null) {
            IValue v = vItr.next();
            if (!v.isOK()) continue;
            first = v;
        }
        if (first == null) {
            return false;
        }
        IValue last = null;
        while (vItr.hasNext() && last == null) {
            IValue v = vItr.next();
            if (!v.isOK() || v.equals(first)) continue;
            last = v;
        }
        if (last == null) {
            return false;
        }
        int comp = last.compareTo((Object)first);
        boolean isOrderAscending = comp > 0;
        boolean isOrdered = true;
        while (vItr.hasNext() && isOrdered) {
            IValue curr = vItr.next();
            comp = curr.compareTo((Object)last);
            if (comp == 0) continue;
            isOrdered = isOrderAscending && comp > 0 || !isOrderAscending && comp < 0;
            last = curr;
        }
        vItr.close();
        return isOrdered;
    }

    void addRange(String sFrom, String sTo) {
        this.mRanges = DataHints.addRange(this.mRanges, sFrom, sTo);
    }

    static List<Range> addRange(List<Range> vRanges, String sFrom, String sTo) {
        ToolBox.Assert(sFrom != null || sTo != null, "Invalid range specification! Neither 'from' nor 'to' are specified!");
        if (vRanges == null) {
            vRanges = new ArrayList<Range>(3);
        }
        Range r = new Range();
        if (sFrom != null) {
            r.mFrom = Float.parseFloat(sFrom);
        }
        if (sTo != null) {
            r.mTo = Float.parseFloat(sTo);
        }
        vRanges.add(r);
        return vRanges;
    }

    void addPatterns(String[] patterns) {
        if (this.mPatterns == null) {
            this.mPatterns = new ArrayList<KnowledgeBaseEnums.EDataPattern[]>(3);
        }
        KnowledgeBaseEnums.EDataPattern[] ptrn = new KnowledgeBaseEnums.EDataPattern[patterns.length];
        for (int idx = 0; idx < patterns.length; ++idx) {
            ptrn[idx] = KnowledgeBaseEnums.EDataPattern.valueOf(patterns[idx]);
        }
        this.mPatterns.add(ptrn);
    }

    void setMaxDistinctValuesCount(int max) {
        this.mMaxDistinctValuesCount = max;
    }

    void setRegularExpression(String regEx) {
        if (regEx != null) {
            this.mRegExpPattern = Pattern.compile(regEx);
        }
    }

    private boolean evaluateYearDigits(DataItemExtension dix, boolean isShortForm) {
        int maxLen;
        IDataItem di = dix.getDataItem();
        if (di.getStats().minValue() == null || di.getStats().minValue().isNull() || di.getStats().maxValue().isNull()) {
            return false;
        }
        int minLen = di.getStats().minValue().stringValue().length();
        if (minLen != (maxLen = di.getStats().maxValue().stringValue().length())) {
            return false;
        }
        if (isShortForm) {
            return minLen == 2;
        }
        return minLen == 4;
    }

    public static String dataHintsResultAsString(float result) {
        if (result < 0.0f) {
            return "N/A";
        }
        if (result == 0.0f) {
            return "failed";
        }
        StringBuilder sb = new StringBuilder("passed (");
        sb.append(Float.toString(result));
        sb.append(")");
        return sb.toString();
    }

    static class Range {
        private float mFrom = -2.1474836E9f;
        private float mTo = 2.1474836E9f;

        Range() {
        }
    }
}

