/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.smd.kb;

import com.ibm.cognos.smd.kb.ExtensionSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ExtensionManager {
    public static final String PARAM_EXTENSION_DIR = "smd.kb.extensionDir";
    public static final String PARAM_EXTENSION_RES = "smd.kb.extensionRes";
    private static ExtensionManager gInstance = null;
    private ReentrantReadWriteLock mRWLock = new ReentrantReadWriteLock();
    private Map<String, ExtensionSource> mExtensionSources = new HashMap<String, ExtensionSource>(10);
    private ExtensionSource mExtensionSourceCore = ExtensionSource.load(null, false);

    public static final ExtensionManager getInstance() {
        return gInstance;
    }

    private ExtensionManager() {
    }

    public ExtensionSource getExtensionSource(Properties cfg) {
        if (cfg == null) {
            return this.mExtensionSourceCore;
        }
        String extensionSrc = null;
        extensionSrc = (String)cfg.get(PARAM_EXTENSION_DIR);
        if (extensionSrc != null && extensionSrc.length() >= 0) {
            return this.findOrAddSource(extensionSrc, true);
        }
        extensionSrc = (String)cfg.get(PARAM_EXTENSION_RES);
        if (extensionSrc != null && extensionSrc.length() >= 0) {
            return this.findOrAddSource(extensionSrc, false);
        }
        return this.mExtensionSourceCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionSource findOrAddSource(String sourceID, boolean isDirPath) {
        if (sourceID == null) {
            return this.mExtensionSourceCore;
        }
        ExtensionSource out = null;
        this.mRWLock.readLock().lock();
        try {
            out = this.mExtensionSources.get(sourceID);
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        if (out == null) {
            this.mRWLock.writeLock().lock();
            try {
                out = ExtensionSource.load(sourceID, isDirPath);
                this.mExtensionSources.put(sourceID, out);
            }
            finally {
                this.mRWLock.writeLock().unlock();
            }
        }
        return out;
    }

    static {
        gInstance = new ExtensionManager();
    }
}

